/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.NameValue;

@Singleton
public class MetaDataReader {
    private static final Log LOG = LogFactory.getLog(MetaDataReader.class);
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final LimeXMLSchemaRepository limeXMLSchemaRepository;
    private final Provider<MetaDataFactory> metaDataFactory;

    @Inject
    MetaDataReader(LimeXMLDocumentFactory limeXMLDocumentFactory, LimeXMLSchemaRepository limeXMLSchemaRepository, Provider<MetaDataFactory> metaDataFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        this.metaDataFactory = metaDataFactory;
    }

    public LimeXMLDocument readDocument(File file) throws IOException {
        MetaData data = this.metaDataFactory.get().parse(file);
        if (data == null) {
            throw new IOException("unable to parse file");
        }
        List<NameValue<String>> nameValList = data.toNameValueList();
        if (nameValList.isEmpty()) {
            throw new IOException("invalid/no data.");
        }
        String uri = data.getSchemaURI();
        LimeXMLSchema schema = this.limeXMLSchemaRepository.getSchema(uri);
        if (schema == null || schema.getCanonicalizedFields().isEmpty()) {
            throw new IOException("schema: " + uri + " doesn't exist");
        }
        try {
            return this.limeXMLDocumentFactory.createLimeXMLDocument(nameValList, uri);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Error creating document", iae);
            throw (IOException)new IOException().initCause(iae);
        }
    }
}

