/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.service.ErrorService;

public class ContentResponse
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private GGEP ggep;

    public ContentResponse(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 29, version, payload, network);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        try {
            this.ggep = new GGEP(this.getPayload(), 0);
        }
        catch (BadGGEPBlockException bgbe) {
            throw new BadPacketException(bgbe);
        }
    }

    public ContentResponse(URN sha1, boolean okay) {
        super(F_LIME_VENDOR_ID, 29, 1, ContentResponse.derivePayload(sha1, okay));
        try {
            this.ggep = new GGEP(this.getPayload(), 0);
        }
        catch (BadGGEPBlockException bgbe) {
            ErrorService.error(bgbe);
        }
    }

    private static byte[] derivePayload(URN sha1, boolean okay) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        GGEP ggep = new GGEP();
        ggep.put("S1", sha1.getBytes());
        ggep.put("SV", okay ? 1 : 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ggep.write(out);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        return out.toByteArray();
    }

    public URN getURN() {
        try {
            return URN.createSHA1UrnFromBytes(this.ggep.getBytes("S1"));
        }
        catch (IOException iox) {
            return null;
        }
        catch (BadGGEPPropertyException bgpe) {
            return null;
        }
    }

    public boolean getOK() {
        try {
            return this.ggep.getInt("SV") != 0;
        }
        catch (BadGGEPPropertyException bgpe) {
            return false;
        }
    }
}

