/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.DangerousFileType;
import com.limegroup.gnutella.malware.FileExtensionEncoder;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inject.LazySingleton;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;

@LazySingleton
class FileExtensionChecker
implements DangerousFileChecker {
    private static final Log LOG = LogFactory.getLog(FileExtensionChecker.class);
    private final DangerousFileType[] fileTypes;

    FileExtensionChecker() {
        DangerousFileType[] ft;
        try {
            String setting = FilterSettings.DANGEROUS_FILE_TYPES.get();
            ft = FileExtensionEncoder.decodeSetting(setting);
        }
        catch (IllegalArgumentException e) {
            ft = new DangerousFileType[]{};
        }
        this.fileTypes = ft;
    }

    protected int getNumKnownTypes() {
        return this.fileTypes.length;
    }

    @Override
    public boolean isDangerous(File file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking " + file);
        }
        if (!file.exists()) {
            return false;
        }
        HashSet<String> types = new HashSet<String>();
        try {
            for (Object o : MimeUtil.getMimeTypes(file)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MIME type " + o);
                }
                types.add(o.toString());
            }
        }
        catch (MimeException e) {
            LOG.debug(e);
            return false;
        }
        String ext = FileUtils.getFileExtension(file).toLowerCase(Locale.US);
        if (LOG.isDebugEnabled()) {
            LOG.debug(ext.isEmpty() ? "No extension" : "Extension " + ext);
        }
        for (DangerousFileType type : this.fileTypes) {
            if (!types.contains(type.mimeType)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dangerous MIME type " + type.mimeType);
            }
            boolean extensionMatchesType = false;
            for (String allowed : type.extensions) {
                if (!ext.equals(allowed)) continue;
                LOG.debug("Safe extension");
                extensionMatchesType = true;
                break;
            }
            if (extensionMatchesType) continue;
            LOG.debug("Dangerous extension");
            return true;
        }
        return false;
    }
}

