/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.hashing.AudioHashingUtils;
import com.limegroup.gnutella.library.DiskIo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.SimpleFuture;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.ServiceScheduler;
import org.limewire.listener.EventBroadcaster;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

@EagerSingleton
public final class UrnCache {
    private static final Log LOG = LogFactory.getLog(UrnCache.class);
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private final ListeningExecutorService QUEUE;
    private volatile boolean dirty = false;
    private final Future<Map<UrnSetKey, Set<URN>>> deserializer;
    private final EventBroadcaster<FileProcessingEvent> broadcaster;

    @Inject
    UrnCache(@DiskIo ListeningExecutorService diskIoExecutor, EventBroadcaster<FileProcessingEvent> broadcaster) {
        this.QUEUE = diskIoExecutor;
        this.broadcaster = broadcaster;
        this.deserializer = this.QUEUE.submit(new Callable<Map<UrnSetKey, Set<URN>>>(){

            @Override
            public Map<UrnSetKey, Set<URN>> call() {
                Map map = UrnCache.createMap();
                UrnCache.this.dirty = UrnCache.scanAndRemoveOldEntries(map);
                return map;
            }
        });
    }

    @Inject
    void register(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, ServiceScheduler serviceScheduler) {
        serviceScheduler.scheduleWithFixedDelay("urncache persister", new Runnable(){

            @Override
            public void run() {
                UrnCache.this.persistCache();
            }
        }, 30L, 30L, TimeUnit.SECONDS, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningFuture<Set<URN>> calculateAndCacheSHA1(File file) {
        Set<URN> urns;
        UrnCache urnCache = this;
        synchronized (urnCache) {
            urns = this.getUrns(file);
            if (UrnSet.getSha1(urns) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding: " + file + " to be hashed.");
                }
                return this.QUEUE.submit(new SHA1Processor(file));
            }
        }
        assert (!urns.isEmpty());
        return new SimpleFuture<Set<URN>>(urns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningFuture<URN> calculateAndCacheNMS1(File file) {
        URN nms1 = null;
        UrnCache urnCache = this;
        synchronized (urnCache) {
            nms1 = UrnSet.getNMS1(this.getUrns(file));
            if (nms1 == null) {
                return this.QUEUE.submit(new NMS1Processor(file));
            }
        }
        return new SimpleFuture<URN>(nms1);
    }

    public synchronized Set<URN> getUrns(File file) {
        long modified = file.lastModified();
        if (modified == 0L) {
            return Collections.emptySet();
        }
        UrnSetKey key = new UrnSetKey(file);
        if (key._modTime != modified) {
            return Collections.emptySet();
        }
        Set<URN> cachedUrns = this.getUrnMap().get(key);
        if (cachedUrns == null) {
            return Collections.emptySet();
        }
        return cachedUrns;
    }

    public synchronized void removeUrns(File f) {
        UrnSetKey k = new UrnSetKey(f);
        this.getUrnMap().remove(k);
        this.dirty = true;
    }

    public synchronized void addUrns(File file, Set<? extends URN> urns) {
        UrnSetKey key = new UrnSetKey(file);
        this.getUrnMap().put(key, UrnSet.unmodifiableSet(urns));
        this.dirty = true;
    }

    private static Map createMap() {
        HashMap result = UrnCache.readMap(URN_CACHE_FILE);
        if (result == null) {
            result = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readMap(File file) {
        Map map;
        if (!file.exists()) {
            return null;
        }
        ConverterObjectInputStream ois = null;
        try {
            ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            ois.addLookup("com.limegroup.gnutella.UrnCache$UrnSetKey", UrnSetKey.class.getName());
            map = (Map)ois.readObject();
        }
        catch (Throwable t) {
            Map map2;
            try {
                LOG.error("Unable to read UrnCache", t);
                map2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                throw throwable;
            }
            IOUtils.close(ois);
            return map2;
        }
        IOUtils.close(ois);
        return map;
    }

    private static boolean scanAndRemoveOldEntries(Map<Object, Object> map) {
        boolean dirty = false;
        Iterator<Map.Entry<Object, Object>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (!(entry.getKey() instanceof UrnSetKey)) {
                i.remove();
                dirty = true;
                continue;
            }
            UrnSetKey key = (UrnSetKey)entry.getKey();
            File f = new File(key._path);
            if (!f.exists() || f.lastModified() != key._modTime) {
                dirty = true;
                i.remove();
                continue;
            }
            if (!(entry.getValue() instanceof Set)) {
                i.remove();
                dirty = true;
                continue;
            }
            Set<URN> set = GenericsUtils.scanForSet(entry.getValue(), URN.class, GenericsUtils.ScanMode.NEW_COPY_REMOVED, UrnSet.class);
            if (set.isEmpty()) {
                i.remove();
                dirty = true;
                continue;
            }
            if (set == entry.getValue()) continue;
            dirty = true;
            entry.setValue(UrnSet.unmodifiableSet(set));
        }
        return dirty;
    }

    synchronized void persistCache() {
        LOG.debug("persist cache");
        if (!this.dirty) {
            LOG.debug("not dirty");
            return;
        }
        if (FileUtils.writeWithBackupFile(this.getUrnMap(), URN_CACHE_BACKUP_FILE, URN_CACHE_FILE, LOG)) {
            this.dirty = false;
        }
    }

    private Map<UrnSetKey, Set<URN>> getUrnMap() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                Map<UrnSetKey, Set<URN>> map = this.deserializer.get();
                return map;
            }
            catch (InterruptedException tryAgain) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class UrnSetKey
    implements Serializable {
        private static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int result = 17;
            result = result * 37 + this._path.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey key = (UrnSetKey)o;
            return this._path.equals(key._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeLong(this._modTime);
            s.writeObject(this._path);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._modTime = s.readLong();
            this._path = ((String)s.readObject()).intern();
            this._hashCode = this.calculateHashCode();
        }
    }

    private class NMS1Processor
    implements Callable<URN> {
        private final File file;

        NMS1Processor(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URN call() {
            URN nms1;
            block12: {
                Set<URN> urns;
                nms1 = null;
                UrnCache urnCache = UrnCache.this;
                synchronized (urnCache) {
                    urns = UrnCache.this.getUrns(this.file);
                }
                if (UrnSet.getNMS1(urns) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Hashing nmsa file: " + this.file);
                    }
                    if (AudioHashingUtils.canCreateNonMetaDataSHA1(this.file)) {
                        try {
                            nms1 = AudioHashingUtils.generateNonMetaDataSHA1FromFile(this.file);
                            if (nms1 == null) break block12;
                            UrnSet set = new UrnSet();
                            UrnCache urnCache2 = UrnCache.this;
                            synchronized (urnCache2) {
                                set.addAll((Collection<? extends URN>)UrnCache.this.getUrns(this.file));
                                set.add(nms1);
                                UrnCache.this.addUrns(this.file, set);
                            }
                        }
                        catch (InterruptedException ignored) {
                            LOG.warn("Unable to calculate NMS1", ignored);
                        }
                    }
                } else {
                    nms1 = UrnSet.getNMS1(urns);
                }
            }
            return nms1;
        }
    }

    private class SHA1Processor
    implements Callable<Set<URN>> {
        private final File file;

        SHA1Processor(File f) {
            this.file = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<URN> call() {
            UrnSet urns;
            if (UrnCache.this.broadcaster != null) {
                UrnCache.this.broadcaster.broadcast(new FileProcessingEvent(FileProcessingEvent.Type.PROCESSING, this.file));
            }
            UrnCache urnCache = UrnCache.this;
            synchronized (urnCache) {
                urns = UrnCache.this.getUrns(this.file);
            }
            if (UrnSet.getSha1(urns) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hashing sha1 file: " + this.file);
                }
                try {
                    UrnSet calculatedUrns = URN.generateUrnsFromFile(this.file);
                    UrnSet set = new UrnSet();
                    UrnCache urnCache2 = UrnCache.this;
                    synchronized (urnCache2) {
                        set.addAll((Collection<? extends URN>)UrnCache.this.getUrns(this.file));
                        set.addAll(calculatedUrns);
                        UrnCache.this.addUrns(this.file, set);
                    }
                    urns = set;
                }
                catch (IOException ignored) {
                    LOG.warn("Unable to calculate SHA1", ignored);
                }
                catch (InterruptedException ignored) {
                    LOG.warn("Unable to calculate SHA1", ignored);
                }
            }
            return urns;
        }
    }
}

