/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.LocalFileDetailsFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Set;

@Singleton
class LocalFileDetailsFactoryImpl
implements LocalFileDetailsFactory {
    private final CreationTimeCache creationTimeCache;

    @Inject
    public LocalFileDetailsFactoryImpl(CreationTimeCache creationTimeCache) {
        this.creationTimeCache = creationTimeCache;
    }

    @Override
    public FileDetails create(final FileDesc fd) {
        return new FileDetails(){

            @Override
            public String getFileName() {
                return fd.getFileName();
            }

            @Override
            public long getSize() {
                return fd.getFileSize();
            }

            @Override
            public URN getSHA1Urn() {
                return fd.getSHA1Urn();
            }

            @Override
            public Set<URN> getUrns() {
                return fd.getUrns();
            }

            @Override
            public LimeXMLDocument getXMLDocument() {
                return fd.getXMLDocument();
            }

            @Override
            public long getIndex() {
                return fd.getIndex();
            }

            @Override
            public long getCreationTime() {
                if (fd.getSHA1Urn() != null) {
                    return LocalFileDetailsFactoryImpl.this.creationTimeCache.getCreationTimeAsLong(fd.getSHA1Urn());
                }
                return -1L;
            }
        };
    }
}

