/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.LibraryImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.collection.IntSet;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

abstract class AbstractFileView
implements FileView {
    private final IntSet indexes = new IntSet();
    protected final LibraryImpl library;

    public AbstractFileView(LibraryImpl library) {
        this.library = library;
    }

    protected IntSet getInternalIndexes() {
        return this.indexes;
    }

    @Override
    public boolean contains(File file) {
        return this.getFileDesc(file) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(FileDesc fileDesc) {
        this.getReadLock().lock();
        try {
            boolean bl = this.indexes.contains(fileDesc.getIndex());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public FileDesc getFileDesc(URN urn) {
        List<FileDesc> descs = this.getFileDescsMatching(urn);
        if (descs.isEmpty()) {
            return null;
        }
        return descs.get(0);
    }

    @Override
    public FileDesc getFileDesc(File f) {
        FileDesc fd = this.library.getFileDesc(f);
        if (fd != null && this.contains(fd)) {
            return fd;
        }
        return null;
    }

    @Override
    public FileDesc getFileDescForIndex(int index) {
        FileDesc fd = this.library.getFileDescForIndex(index);
        if (fd != null && this.contains(fd)) {
            return fd;
        }
        return null;
    }

    @Override
    public List<FileDesc> getFileDescsMatching(URN urn) {
        ArrayList<FileDesc> fds = null;
        List<FileDesc> matching = this.library.getFileDescsMatching(urn);
        if (matching.size() == 1 && this.contains(matching.get(0))) {
            return matching;
        }
        for (FileDesc fd : matching) {
            if (!this.contains(fd)) continue;
            if (fds == null) {
                fds = new ArrayList<FileDesc>(matching.size());
            }
            fds.add(fd);
        }
        if (fds == null) {
            return Collections.emptyList();
        }
        return fds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.getReadLock().lock();
        try {
            int n = this.indexes.size();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileDesc> getFilesInDirectory(File directory) {
        try {
            directory = FileUtils.getCanonicalFile(Objects.nonNull(directory, "directory"));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<FileDesc> list = new ArrayList<FileDesc>();
        this.getReadLock().lock();
        try {
            for (FileDesc fd : this) {
                if (!directory.equals(fd.getFile().getParentFile())) continue;
                list.add(fd);
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return list;
    }
}

