/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.AbstractFileView;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.FileViewChangeFailedException;
import com.limegroup.gnutella.library.FileViewIterator;
import com.limegroup.gnutella.library.LibraryImpl;
import com.limegroup.gnutella.library.ThreadSafeFileViewIterator;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.ListeningFutureDelegator;
import org.limewire.concurrent.SimpleFuture;
import org.limewire.inspection.Inspectable;
import org.limewire.listener.EventListener;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

abstract class AbstractFileCollection
extends AbstractFileView
implements FileCollection,
Inspectable {
    private final SourcedEventMulticaster<FileViewChangeEvent, FileView> multicaster;
    private final EventListener<FileViewChangeEvent> libraryListener;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile long totalFileSize = 0L;

    public AbstractFileCollection(LibraryImpl library, SourcedEventMulticaster<FileViewChangeEvent, FileView> multicaster) {
        super(library);
        this.multicaster = multicaster;
        this.libraryListener = new LibrarySynchonizer();
    }

    protected void initialize() {
        this.library.addListener(this.libraryListener);
    }

    @Override
    public ListeningFuture<List<ListeningFuture<FileDesc>>> addFolder(File folder, FileFilter fileFilter) {
        return this.library.scanFolderAndAddToCollection(folder, fileFilter, this);
    }

    @Override
    public ListeningFuture<FileDesc> add(File file) {
        if (!this.isFileAllowed(file)) {
            return new SimpleFuture<FileDesc>(new FileViewChangeFailedException(file, FileViewChangeEvent.Type.FILE_ADD_FAILED, FileViewChangeFailedException.Reason.CANT_ADD_TO_LIST));
        }
        FileDesc fd = this.library.getFileDesc(file);
        if (fd == null) {
            this.saveChange(this.canonicalize(file), true);
            return this.wrapFuture(this.library.add(file));
        }
        this.add(fd);
        return this.futureFor(fd);
    }

    @Override
    public ListeningFuture<FileDesc> add(File file, List<? extends LimeXMLDocument> documents) {
        if (!this.isFileAllowed(file)) {
            return new SimpleFuture<FileDesc>(new FileViewChangeFailedException(file, FileViewChangeEvent.Type.FILE_ADD_FAILED, FileViewChangeFailedException.Reason.CANT_ADD_TO_LIST));
        }
        FileDesc fd = this.library.getFileDesc(file);
        if (fd == null) {
            this.saveChange(this.canonicalize(file), true);
            return this.wrapFuture(this.library.add(file, documents));
        }
        this.add(fd);
        return this.futureFor(fd);
    }

    @Override
    public boolean add(FileDesc fileDesc) {
        if (!this.isFileDescAllowed(fileDesc)) {
            return false;
        }
        if (this.addFileDescImpl(fileDesc)) {
            this.saveChange(fileDesc.getFile(), true);
            this.fireAddEvent(fileDesc);
            return true;
        }
        if (!this.contains(fileDesc)) {
            this.saveChange(fileDesc.getFile(), false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addFileDescImpl(FileDesc fileDesc) {
        Objects.nonNull(fileDesc, "fileDesc");
        this.rwLock.writeLock().lock();
        try {
            if (this.isFileDescAllowed(fileDesc) && this.getInternalIndexes().add(fileDesc.getIndex())) {
                this.totalFileSize += fileDesc.getFileSize();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(File file) {
        FileDesc fd = this.library.getFileDesc(file);
        if (fd != null) {
            return this.remove(fd);
        }
        this.saveChange(this.canonicalize(file), false);
        return false;
    }

    @Override
    public boolean remove(FileDesc fileDesc) {
        this.saveChange(fileDesc.getFile(), false);
        if (this.removeFileDescImpl(fileDesc)) {
            this.fireRemoveEvent(fileDesc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFileDescImpl(FileDesc fileDesc) {
        Objects.nonNull(fileDesc, "fileDesc");
        this.rwLock.writeLock().lock();
        try {
            if (this.getInternalIndexes().remove(fileDesc.getIndex())) {
                this.totalFileSize -= fileDesc.getFileSize();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public long getNumBytes() {
        return this.totalFileSize;
    }

    @Override
    public Iterator<FileDesc> iterator() {
        return new FileViewIterator(this, this.getInternalIndexes());
    }

    @Override
    public Iterable<FileDesc> pausableIterable() {
        return new Iterable<FileDesc>(){

            @Override
            public Iterator<FileDesc> iterator() {
                return new ThreadSafeFileViewIterator(AbstractFileCollection.this);
            }
        };
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(boolean fromLibrary) {
        boolean needsClearing;
        this.rwLock.writeLock().lock();
        try {
            needsClearing = this.clearImpl();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (needsClearing) {
            this.fireClearEvent(fromLibrary);
        }
    }

    protected boolean clearImpl() {
        boolean needsClearing = this.getInternalIndexes().size() > 0;
        this.getInternalIndexes().clear();
        this.totalFileSize = 0L;
        return needsClearing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object inspect() {
        this.rwLock.readLock().lock();
        try {
            HashMap<String, Number> inspections = new HashMap<String, Number>();
            inspections.put("num of files", this.size());
            inspections.put("size of all files", this.totalFileSize);
            HashMap<String, Number> hashMap = inspections;
            return hashMap;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public Lock getReadLock() {
        return this.rwLock.readLock();
    }

    @Override
    public void addListener(EventListener<FileViewChangeEvent> listener) {
        this.multicaster.addListener(this, listener);
    }

    @Override
    public boolean removeListener(EventListener<FileViewChangeEvent> listener) {
        return this.multicaster.removeListener(this, listener);
    }

    protected void fireAddEvent(FileDesc fileDesc) {
        this.multicaster.broadcast(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_ADDED, fileDesc));
    }

    protected void fireRemoveEvent(FileDesc fileDesc) {
        this.multicaster.broadcast(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_REMOVED, fileDesc));
    }

    protected void fireChangeEvent(FileDesc oldFileDesc, FileDesc newFileDesc) {
        this.multicaster.broadcast(new FileViewChangeEvent(this, FileViewChangeEvent.Type.FILE_CHANGED, oldFileDesc, newFileDesc));
    }

    protected void fireMetaChangeEvent(FileDesc fd) {
        this.multicaster.broadcast(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_META_CHANGED, fd));
    }

    protected void fireClearEvent(boolean fromLibrary) {
        this.multicaster.broadcast(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILES_CLEARED, fromLibrary));
    }

    protected void updateFileDescs(FileDesc oldFileDesc, FileDesc newFileDesc) {
        boolean failed = false;
        boolean success = false;
        if (this.removeFileDescImpl(oldFileDesc)) {
            if (this.addFileDescImpl(newFileDesc)) {
                this.saveChange(newFileDesc.getFile(), true);
                success = true;
            } else {
                failed = true;
            }
        }
        if (success) {
            this.fireChangeEvent(oldFileDesc, newFileDesc);
        } else if (failed) {
            this.fireRemoveEvent(oldFileDesc);
        }
    }

    protected void fileMetaChanged(FileDesc fd) {
        if (this.contains(fd)) {
            if (this.isFileDescAllowed(fd)) {
                this.fireMetaChangeEvent(fd);
            } else {
                this.remove(fd);
            }
        }
    }

    protected abstract boolean isFileDescAllowed(FileDesc var1);

    void dispose() {
        this.clear();
        this.library.removeListener(this.libraryListener);
        this.multicaster.removeListeners(this);
    }

    protected abstract boolean isPending(File var1, FileDesc var2);

    protected abstract void saveChange(File var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxIndex() {
        this.rwLock.readLock().lock();
        try {
            int n = this.getInternalIndexes().max();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMinIndex() {
        this.rwLock.readLock().lock();
        try {
            int n = this.getInternalIndexes().min();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private File canonicalize(File file) {
        try {
            return FileUtils.getCanonicalFile(file);
        }
        catch (IOException iox) {
            return file;
        }
    }

    private FileDesc throwExecutionExceptionIfNotContains(FileDesc fd) throws ExecutionException {
        if (this.contains(fd)) {
            return fd;
        }
        throw new ExecutionException(new FileViewChangeFailedException(fd.getFile(), FileViewChangeEvent.Type.FILE_ADD_FAILED, FileViewChangeFailedException.Reason.CANT_ADD_TO_LIST));
    }

    private ListeningFuture<FileDesc> wrapFuture(ListeningFuture<FileDesc> future) {
        return new ListeningFutureDelegator<FileDesc, FileDesc>(future){

            @Override
            protected FileDesc convertSource(FileDesc source) throws ExecutionException {
                return AbstractFileCollection.this.throwExecutionExceptionIfNotContains(source);
            }

            @Override
            protected FileDesc convertException(ExecutionException ee) throws ExecutionException {
                FileViewChangeFailedException fe;
                if (ee.getCause() instanceof FileViewChangeFailedException && (fe = (FileViewChangeFailedException)ee.getCause()).getType() == FileViewChangeEvent.Type.FILE_ADD_FAILED && AbstractFileCollection.this.contains(fe.getFile())) {
                    return AbstractFileCollection.this.getFileDesc(fe.getFile());
                }
                throw ee;
            }
        };
    }

    private ListeningFuture<FileDesc> futureFor(FileDesc fd) {
        try {
            return new SimpleFuture<FileDesc>(this.throwExecutionExceptionIfNotContains(fd));
        }
        catch (ExecutionException ee) {
            return new SimpleFuture<FileDesc>(ee);
        }
    }

    private class LibrarySynchonizer
    implements EventListener<FileViewChangeEvent> {
        private LibrarySynchonizer() {
        }

        @Override
        public void handleEvent(FileViewChangeEvent event) {
            switch (event.getType()) {
                case FILE_ADDED: {
                    if (!AbstractFileCollection.this.isPending(event.getFile(), event.getFileDesc())) break;
                    AbstractFileCollection.this.add(event.getFileDesc());
                    break;
                }
                case FILE_META_CHANGED: {
                    AbstractFileCollection.this.fileMetaChanged(event.getFileDesc());
                    break;
                }
                case FILE_CHANGED: {
                    AbstractFileCollection.this.updateFileDescs(event.getOldValue(), event.getFileDesc());
                    break;
                }
                case FILE_REMOVED: {
                    AbstractFileCollection.this.remove(event.getFileDesc());
                    break;
                }
                case FILES_CLEARED: {
                    AbstractFileCollection.this.clear(true);
                    break;
                }
                case FILE_CHANGE_FAILED: 
                case FILE_ADD_FAILED: {
                    FileDesc fd = AbstractFileCollection.this.library.getFileDesc(event.getFile());
                    if (fd == null) {
                        if (!AbstractFileCollection.this.isPending(event.getFile(), null) || AbstractFileCollection.this.contains(event.getFile())) break;
                        AbstractFileCollection.this.saveChange(event.getFile(), false);
                        break;
                    }
                    if (!AbstractFileCollection.this.isPending(event.getFile(), fd)) break;
                    AbstractFileCollection.this.add(fd);
                }
            }
        }
    }
}

