/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class FeaturesWriter {
    private final NetworkManager networkManager;

    @Inject
    public FeaturesWriter(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public Set<HTTPHeaderValue> getFeaturesValue() {
        HashSet<HTTPHeaderValue> features = new HashSet<HTTPHeaderValue>(4);
        features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        features.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
        if (!this.networkManager.acceptedIncomingConnection() && this.networkManager.canDoFWT()) {
            features.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
        }
        return features;
    }
}

