/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AbstractIPFilter;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.filters.SpamFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.FilterSettings;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;

@Singleton
public class HostileFilter
extends AbstractIPFilter {
    private static final Log LOG = LogFactory.getLog(HostileFilter.class);
    private volatile IPList hostileHosts = new IPList();
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HostileFilter(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void refreshHosts(SpamFilter.LoadCallback callback) {
        this.refreshHosts();
        callback.spamFilterLoaded();
    }

    @Override
    public void refreshHosts() {
        LOG.debug("Refreshing hostile IP filter");
        IPList newHostile = new IPList();
        if (!FilterSettings.USE_NETWORK_FILTER.getValue()) {
            this.hostileHosts = newHostile;
            return;
        }
        String[] allHosts = FilterSettings.HOSTILE_IPS.get();
        try {
            for (String ip : allHosts) {
                newHostile.add(new IP(ip));
            }
            if (newHostile.isValidFilter(false, this.networkInstanceUtils)) {
                LOG.debug("Filter was valid");
                this.hostileHosts = newHostile;
            } else {
                LOG.debug("Filter was invalid");
            }
        }
        catch (IllegalArgumentException badSimpp) {
            LOG.debug("SIMPP was invalid", badSimpp);
        }
    }

    @Override
    public boolean hasBlacklistedHosts() {
        return !this.hostileHosts.isEmpty();
    }

    @Override
    protected boolean allowImpl(IP ip) {
        return !this.hostileHosts.contains(ip);
    }
}

