/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.DualIterator;
import org.limewire.collection.MultiIterable;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.util.Visitor;

public class PingRanker
extends AbstractSourceRanker
implements MessageListener,
Cancellable {
    private static final Log LOG = LogFactory.getLog(PingRanker.class);
    private static final Comparator<RemoteFileDescContext> ALT_DEPRIORITIZER = new RFDAltDeprioritizer();
    private Set<RemoteFileDescContext> newHosts;
    private TreeMap<IpPort, RemoteFileDescContext> pingedHosts;
    private Set<RemoteFileDescContext> testedLocations;
    private TreeSet<RemoteFileDescContext> verifiedHosts;
    private URN sha1;
    private GUID myGUID;
    private boolean running;
    private long lastPingTime;
    private final NetworkManager networkManager;
    private final UDPPinger udpPinger;
    private final MessageRouter messageRouter;
    private final RemoteFileDescFactory remoteFileDescFactory;

    @Inject
    PingRanker(NetworkManager networkManager, UDPPinger udpPinger, MessageRouter messageRouter, RemoteFileDescFactory remoteFileDescFactory, Comparator<RemoteFileDescContext> rfdComparator) {
        this.networkManager = networkManager;
        this.udpPinger = udpPinger;
        this.messageRouter = messageRouter;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.pingedHosts = new TreeMap(IpPort.COMPARATOR);
        this.testedLocations = new HashSet<RemoteFileDescContext>();
        this.newHosts = new HashSet<RemoteFileDescContext>();
        this.verifiedHosts = new TreeSet<RemoteFileDescContext>(rfdComparator);
    }

    @Override
    public synchronized boolean addToPool(Collection<? extends RemoteFileDescContext> c) {
        ArrayList<? extends RemoteFileDescContext> l = c instanceof List ? (ArrayList<? extends RemoteFileDescContext>)c : new ArrayList<RemoteFileDescContext>(c);
        Collections.sort(l, ALT_DEPRIORITIZER);
        return this.addInternal(l);
    }

    private boolean addInternal(Collection<? extends RemoteFileDescContext> c) {
        boolean ret = false;
        for (RemoteFileDescContext remoteFileDescContext : c) {
            if (!this.addInternal(remoteFileDescContext)) continue;
            ret = true;
        }
        this.pingNewHosts();
        return ret;
    }

    @Override
    public synchronized boolean addToPool(RemoteFileDescContext host) {
        boolean ret = this.addInternal(host);
        this.pingNewHosts();
        return ret;
    }

    private boolean addInternal(RemoteFileDescContext host) {
        if (this.sha1 == null) {
            if (host.getSHA1Urn() != null) {
                this.sha1 = host.getSHA1Urn();
            } else {
                return this.testedLocations.add(host);
            }
        }
        if (this.running && this.knowsAboutHost(host)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding new host " + host + " " + host.getAddress());
        }
        boolean ret = false;
        ret = host.isReplyToMulticast() ? this.verifiedHosts.add(host) : this.newHosts.add(host);
        ret |= !this.running;
        if (this.myGUID == null && this.getMeshHandler() != null) {
            this.myGUID = new GUID();
            this.messageRouter.registerMessageListener(this.myGUID.bytes(), this);
        }
        return ret;
    }

    private boolean knowsAboutHost(RemoteFileDescContext host) {
        return this.newHosts.contains(host) || this.verifiedHosts.contains(host) || this.testedLocations.contains(host);
    }

    @Override
    public synchronized RemoteFileDescContext getBest() throws NoSuchElementException {
        RemoteFileDescContext ret;
        if (!this.hasMore()) {
            return null;
        }
        if (!this.verifiedHosts.isEmpty()) {
            LOG.debug("getting a verified host");
            ret = this.verifiedHosts.first();
            this.verifiedHosts.remove(ret);
        } else {
            LOG.debug("getting a non-verified host");
            DualIterator<RemoteFileDescContext> dual = new DualIterator<RemoteFileDescContext>(this.testedLocations.iterator(), this.newHosts.iterator());
            ret = LegacyRanker.getBest(dual, this.getRfdVisitor());
            if (ret == null) {
                return null;
            }
            this.newHosts.remove(ret);
            this.testedLocations.remove(ret);
            Address address = ret.getAddress();
            if (address instanceof PushEndpoint) {
                for (IpPort ipPort : ((PushEndpoint)address).getProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            } else {
                this.pingedHosts.remove(ret.getAddress());
            }
        }
        this.pingNewHosts();
        if (LOG.isDebugEnabled()) {
            int hosts = this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size() + 1;
            LOG.debug(hosts + " hosts, the best is " + ret.getAddress() + ", multicast " + ret.isReplyToMulticast() + ", queue length " + ret.getQueueStatus() + ", round-trip time " + ret.getRoundTripTime() + ", firewalled " + PingRanker.isFirewalled(ret) + ", partial source " + ret.isPartialSource());
        }
        return ret;
    }

    private void pingNewHosts() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.hasUsableHosts()) {
            return;
        }
        if (this.sha1 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastPingTime < (long)DownloadSettings.WORKER_INTERVAL.getValue()) {
            return;
        }
        HeadPing ping = new HeadPing(this.myGUID, this.sha1, this.getPingFlags());
        int batch = DownloadSettings.PING_BATCH.getValue();
        ArrayList<IpPort> toSend = new ArrayList<IpPort>(batch);
        int sent = 0;
        Iterator<RemoteFileDescContext> iter = this.newHosts.iterator();
        while (iter.hasNext() && sent < batch) {
            RemoteFileDescContext rfdContext = iter.next();
            RemoteFileDesc rfd = rfdContext.getRemoteFileDesc();
            if (rfdContext.isBusy(now)) continue;
            iter.remove();
            Address address = rfd.getAddress();
            if (address instanceof PushEndpoint) {
                PushEndpoint pushEndpoint = (PushEndpoint)address;
                if (!pushEndpoint.getProxies().isEmpty() && rfdContext.getSHA1Urn() != null) {
                    this.pingProxies(rfdContext, pushEndpoint);
                }
            } else {
                IpPort ipPort = (IpPort)((Object)address);
                this.pingedHosts.put(ipPort, rfdContext);
                toSend.add(ipPort);
            }
            this.testedLocations.add(rfdContext);
            rfdContext.recordPingTime(now);
            ++sent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nverified hosts " + this.verifiedHosts.size() + "\npingedHosts " + this.pingedHosts.values().size() + "\nnewHosts " + this.newHosts.size() + "\npinging hosts: " + sent);
        }
        this.udpPinger.rank(toSend, null, this, ping);
        this.lastPingTime = now;
    }

    private void pingProxies(RemoteFileDescContext rfdContext, PushEndpoint pushEndpoint) {
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT() && pushEndpoint.getFWTVersion() > 0) {
            HeadPing pushPing = new HeadPing(this.myGUID, rfdContext.getSHA1Urn(), new GUID(pushEndpoint.getClientGUID()), this.getPingFlags());
            for (IpPort ipPort : pushEndpoint.getProxies()) {
                this.pingedHosts.put(ipPort, rfdContext);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("pinging push location " + pushEndpoint);
            }
            this.udpPinger.rank(pushEndpoint.getProxies(), null, this, pushPing);
        }
    }

    private int getPingFlags() {
        int flags = 3;
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT()) {
            flags |= 4;
        }
        return flags;
    }

    @Override
    public synchronized boolean hasMore() {
        return !this.verifiedHosts.isEmpty() || !this.newHosts.isEmpty() || !this.testedLocations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(Message m, ReplyHandler handler) {
        MeshHandler mesh;
        RemoteFileDescContext rfd;
        Set<RemoteFileDesc> alts = null;
        PingRanker pingRanker = this;
        synchronized (pingRanker) {
            if (!this.running) {
                return;
            }
            if (!(m instanceof HeadPong)) {
                return;
            }
            HeadPong pong = (HeadPong)m;
            for (PushEndpoint pushEndpoint : pong.getPushLocs()) {
                pushEndpoint.updateProxies(true);
            }
            if (!this.pingedHosts.containsKey(handler)) {
                return;
            }
            rfd = this.pingedHosts.remove(handler);
            this.testedLocations.remove(rfd);
            rfd.recordPongTime(System.currentTimeMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("received a pong " + pong + " from " + handler + " for rfd " + rfd + " with address " + rfd.getAddress() + " and round-trip time " + rfd.getRoundTripTime());
            }
            if (!pong.hasFile() && pong.isRoutingBroken() && PingRanker.isFirewalled(rfd)) {
                return;
            }
            if (pong.isFirewalled() && rfd.getAddress() instanceof PushEndpoint) {
                for (IpPort ipPort : ((PushEndpoint)rfd.getAddress()).getProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            }
            mesh = this.getMeshHandler();
            if (pong.hasFile()) {
                PingRanker.updateContext(rfd, pong);
                if (rfd.isBusy()) {
                    this.newHosts.add(rfd);
                } else {
                    this.verifiedHosts.add(rfd);
                }
                alts = pong.getAllLocsRFD(rfd.getRemoteFileDesc(), this.remoteFileDescFactory);
            }
        }
        if (alts == null) {
            mesh.informMesh(rfd.getRemoteFileDesc(), false);
        } else {
            mesh.addPossibleSources(alts);
        }
    }

    public static void updateContext(RemoteFileDescContext rfdContext, HeadPong headPong) {
        if (headPong.isBusy()) {
            rfdContext.setRetryAfter(60);
        }
        rfdContext.setQueueStatus(headPong.getQueueStatus());
        rfdContext.setAvailableRanges(headPong.getRanges());
    }

    @Override
    public synchronized void registered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker registered with guid " + new GUID(guid).toHexString());
        }
        this.running = true;
    }

    @Override
    public synchronized void unregistered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker unregistered with guid " + new GUID(guid).toHexString());
        }
        this.running = false;
        this.newHosts.addAll(this.verifiedHosts);
        this.newHosts.addAll(this.testedLocations);
        this.verifiedHosts.clear();
        this.pingedHosts.clear();
        this.testedLocations.clear();
        this.lastPingTime = 0L;
    }

    @Override
    public synchronized boolean isCancelled() {
        return !this.running || this.verifiedHosts.size() >= DownloadSettings.MAX_VERIFIED_HOSTS.getValue();
    }

    @Override
    protected synchronized void clearState() {
        if (this.myGUID != null) {
            this.messageRouter.unregisterMessageListener(this.myGUID.bytes(), this);
            this.myGUID = null;
        }
    }

    @Override
    protected synchronized boolean visitSources(Visitor<RemoteFileDescContext> contextVisitor) {
        for (RemoteFileDescContext context : new MultiIterable<RemoteFileDescContext>((Iterable<RemoteFileDescContext>)this.verifiedHosts, (Iterable<RemoteFileDescContext>)this.newHosts, (Iterable<RemoteFileDescContext>)this.testedLocations)) {
            if (contextVisitor.visit(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Collection<RemoteFileDescContext> getShareableHosts() {
        ArrayList<RemoteFileDescContext> ret = new ArrayList<RemoteFileDescContext>(this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size());
        ret.addAll(this.verifiedHosts);
        ret.addAll(this.newHosts);
        ret.addAll(this.testedLocations);
        return ret;
    }

    private static boolean isFirewalled(RemoteFileDescContext rfdContext) {
        return rfdContext.getAddress() instanceof PushEndpoint;
    }

    private static final class RFDAltDeprioritizer
    implements Comparator<RemoteFileDescContext> {
        private RFDAltDeprioritizer() {
        }

        @Override
        public int compare(RemoteFileDescContext rfd1, RemoteFileDescContext rfd2) {
            if (rfd1.isFromAlternateLocation() != rfd2.isFromAlternateLocation()) {
                if (rfd1.isFromAlternateLocation()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

