/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.connection.UDPConnectionChecker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.Collection;
import org.limewire.collection.Cancellable;
import org.limewire.io.IpPort;

public class UDPConnectionCheckerImpl
implements UDPConnectionChecker {
    private final ConnectionServices connectionServices;
    private final Provider<UDPService> udpService;
    private final Provider<UniqueHostPinger> uniqueHostPinger;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public UDPConnectionCheckerImpl(ConnectionServices connectionServices, Provider<UDPService> udpService, Provider<UniqueHostPinger> uniqueHostPinger, PingRequestFactory pingRequestFactory) {
        this.connectionServices = connectionServices;
        this.udpService = udpService;
        this.uniqueHostPinger = uniqueHostPinger;
        this.pingRequestFactory = pingRequestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean udpIsDead() {
        PingRequest ping = this.pingRequestFactory.createUDPPing();
        Collection<IpPort> hosts = this.connectionServices.getPreferencedHosts(false, "en", 50);
        UDPChecker checker = new UDPChecker();
        this.uniqueHostPinger.get().rank(hosts, checker, checker, ping);
        long now = System.currentTimeMillis();
        UDPChecker uDPChecker = checker;
        synchronized (uDPChecker) {
            try {
                for (int i = 0; i < 5; ++i) {
                    checker.wait(1000L);
                    if (this.udpService.get().getLastReceivedTime() <= now) continue;
                    checker.received = true;
                    return false;
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        return !checker.received;
    }

    private static class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        private UDPChecker() {
        }

        @Override
        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processMessage(Message m, ReplyHandler handler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        @Override
        public void registered(byte[] guid) {
        }

        @Override
        public void unregistered(byte[] guid) {
        }
    }
}

