/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import java.util.Arrays;
import org.limewire.io.GUID;

public class PushAltLoc
extends AbstractAlternateLocation {
    private final PushEndpoint _pushAddress;
    private final ApplicationServices applicationServices;

    protected PushAltLoc(PushEndpoint address, URN sha1, ApplicationServices applicationServices) {
        super(sha1);
        if (address == null) {
            throw new NullPointerException("null address");
        }
        this._pushAddress = address;
        this.applicationServices = applicationServices;
    }

    @Override
    protected String generateHTTPString() {
        return this._pushAddress.httpStringValue();
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(long size, RemoteFileDescFactory remoteFileDescFactory) {
        UrnSet urnSet = new UrnSet(this.getSHA1Urn());
        int quality = 3;
        RemoteFileDesc ret = remoteFileDescFactory.createRemoteFileDesc(this._pushAddress, 0L, "/uri-res/N2R?" + this.SHA1_URN, size, this._pushAddress.getClientGUID(), 1000, quality, false, null, urnSet, false, "ALT", -1L);
        return ret;
    }

    @Override
    public synchronized AlternateLocation createClone() {
        PushAltLoc ret = new PushAltLoc(this._pushAddress.createClone(), this.SHA1_URN, this.applicationServices);
        ret._count = this._count;
        return ret;
    }

    @Override
    public boolean isMe() {
        return Arrays.equals(this._pushAddress.getClientGUID(), this.applicationServices.getMyGUID());
    }

    public void updateProxies(boolean isGood) {
        this._pushAddress.updateProxies(isGood);
    }

    public PushEndpoint getPushAddress() {
        return this._pushAddress;
    }

    public int supportsFWTVersion() {
        return this._pushAddress.getFWTVersion();
    }

    @Override
    void promote() {
    }

    @Override
    void demote() {
    }

    @Override
    public boolean isDemoted() {
        return this._pushAddress.getProxies().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof PushAltLoc)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PushAltLoc other = (PushAltLoc)o;
        return ((Object)this._pushAddress).equals(other._pushAddress);
    }

    @Override
    public int compareTo(AlternateLocation obj) {
        if (this == obj) {
            return 0;
        }
        int ret = super.compareTo(obj);
        if (ret != 0) {
            return ret;
        }
        if (!(obj instanceof PushAltLoc)) {
            return 1;
        }
        PushAltLoc pal = (PushAltLoc)obj;
        return GUID.GUID_BYTE_COMPARATOR.compare(this._pushAddress.getClientGUID(), pal.getPushAddress().getClientGUID());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = super.hashCode();
            this.hashCode = result = 37 * result + ((Object)this._pushAddress).hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._pushAddress + "," + this._count;
    }
}

