/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.http.HTTPConnectionData;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.NetworkUtils;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.net.ConnectBackRequest;
import org.limewire.net.ConnectBackRequestedEvent;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NBSocket;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.rudp.UDPSelectorProvider;
import org.limewire.util.StringUtils;

@EagerSingleton
public final class PushManager
implements EventListener<ConnectBackRequestedEvent> {
    private static final Log LOG = LogFactory.getLog(PushManager.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private final Provider<SocketsManager> socketsManager;
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final Provider<UDPSelectorProvider> udpSelectorProvider;
    private final Provider<NetworkManager> networkManager;

    @Inject
    public PushManager(Provider<SocketsManager> socketsManager, Provider<HTTPAcceptor> httpAcceptor, Provider<UDPSelectorProvider> udpSelectorProvider, Provider<NetworkManager> networkManager) {
        this.socketsManager = socketsManager;
        this.httpAcceptor = httpAcceptor;
        this.udpSelectorProvider = udpSelectorProvider;
        this.networkManager = networkManager;
    }

    @Inject
    void register(ListenerSupport<ConnectBackRequestedEvent> connectBackRequestedEventListenerSupport) {
        connectBackRequestedEventListenerSupport.addListener(this);
    }

    public void acceptPushUpload(Connectable address, GUID guid, boolean lan, boolean isFWTransfer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accepting Push Upload from host:" + address + " FW:" + isFWTransfer);
        }
        if (address == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidIpPort(address)) {
            throw new IllegalArgumentException("invalid  ip port: " + address);
        }
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        PushData data = new PushData(address, guid, lan);
        if (isFWTransfer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer FW-FW to host: " + address);
            }
            AbstractNBSocket socket = this.udpSelectorProvider.get().openAcceptorSocketChannel().socket();
            ((NBSocket)socket).connect(address.getInetSocketAddress(), 20000, new PushConnectObserver(data, true, this.httpAcceptor.get()));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer to host: " + address);
            }
            try {
                SocketsManager.ConnectType type = address.isTLSCapable() && this.networkManager.get().isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
                this.socketsManager.get().connect(address.getInetSocketAddress(), 10000, new PushConnectObserver(data, false, this.httpAcceptor.get()), type);
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleEvent(ConnectBackRequestedEvent event) {
        ConnectBackRequest request = (ConnectBackRequest)event.getData();
        this.acceptPushUpload(request.getAddress(), request.getClientGuid(), false, request.getSupportedFWTVersion() > 0);
    }

    private static class GivLineWriter
    implements ChannelWriter {
        private InterestWritableByteChannel channel;
        private final ByteBuffer buffer;
        private final Socket socket;
        private HTTPConnectionData data;
        private HTTPAcceptor httpAcceptor;

        public GivLineWriter(Socket socket, PushData data, boolean fwTransfer, HTTPAcceptor httpAcceptor) throws IOException {
            this.socket = socket;
            this.data = new HTTPConnectionData();
            this.data.setPush(true);
            this.data.setLocal(data.isLan());
            this.data.setFirewalled(fwTransfer);
            this.httpAcceptor = httpAcceptor;
            socket.setSoTimeout(30000);
            String giv = "GIV 0:" + data.getGuid() + "/file\n\n";
            this.buffer = ByteBuffer.wrap(StringUtils.toAsciiBytes(giv));
        }

        @Override
        public boolean handleWrite() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            while (this.buffer.hasRemaining()) {
                int written = this.channel.write(this.buffer);
                if (written != 0) continue;
                return true;
            }
            this.httpAcceptor.acceptConnection(this.socket, this.data);
            return false;
        }

        @Override
        public void handleIOException(IOException iox) {
            throw new RuntimeException();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public InterestWritableByteChannel getWriteChannel() {
            return this.channel;
        }

        @Override
        public void setWriteChannel(InterestWritableByteChannel newChannel) {
            this.channel = newChannel;
            if (newChannel != null) {
                newChannel.interestWrite(this, true);
            }
        }
    }

    private static class PushConnectObserver
    implements ConnectObserver {
        private final PushData data;
        private final boolean fwt;
        private final HTTPAcceptor httpAcceptor;

        PushConnectObserver(PushData data, boolean fwt, HTTPAcceptor httpAcceptor) {
            this.data = data;
            this.fwt = fwt;
            this.httpAcceptor = httpAcceptor;
        }

        @Override
        public void handleIOException(IOException iox) {
        }

        @Override
        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getAddress() + " failed");
            }
        }

        @Override
        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getAddress() + " succeeded");
            }
            ((NIOMultiplexor)((Object)socket)).setWriteObserver(new GivLineWriter(socket, this.data, this.fwt, this.httpAcceptor));
        }
    }

    private static class PushData {
        private final Connectable address;
        private final GUID guid;
        private final boolean lan;

        PushData(Connectable address, GUID guid, boolean lan) {
            this.address = address;
            this.guid = guid;
            this.lan = lan;
        }

        public boolean isLan() {
            return this.lan;
        }

        public GUID getGuid() {
            return this.guid;
        }

        public Connectable getAddress() {
            return this.address;
        }
    }
}

