/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionCheckerManager;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.GnutellaConnectionEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.RoutedConnectionFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationManager;
import org.limewire.core.api.connection.ConnectionLifecycleEventType;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.UltrapeerSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.StrictIpPortSet;
import org.limewire.util.SystemUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

@EagerSingleton
public class ConnectionManagerImpl
implements ConnectionManager,
Service {
    private static final Log LOG = LogFactory.getLog(ConnectionManagerImpl.class);
    private static final int MINIMUM_IDLE_TIME = 1800000;
    static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    @InspectionPoint(value="leaf connections")
    private final Inspectable LEAF = new LegacyConnectionStats(true);
    @InspectionPoint(value="ultrapeer connections")
    private final Inspectable UP = new LegacyConnectionStats(false);
    @InspectablePrimitive(value="last disconnect time")
    private volatile long _disconnectTime = -1L;
    @InspectablePrimitive(value="last connect time")
    private volatile long _connectTime = Long.MAX_VALUE;
    @InspectablePrimitive(value="last time preferred reached")
    private volatile long _lastFullConnectTime;
    @InspectablePrimitive(value="begin of automatic connect")
    private volatile long _automaticConnectTime = 0L;
    @InspectablePrimitive(value="automatically connecting")
    private volatile boolean _automaticallyConnecting;
    @InspectablePrimitive(value="last successful connection")
    private volatile long _lastSuccessfulConnect = 0L;
    @InspectablePrimitive(value="last internet check")
    private volatile long _lastConnectionCheck = 0L;
    @InspectablePrimitive(value="connection attempts")
    private volatile int _connectionAttempts;
    @InspectablePrimitive(value="preferred connections")
    private volatile int _preferredConnections = -1;
    @InspectablePrimitive(value="number tcp connectbacks")
    private volatile int numTCPConnectBacksLeft;
    @InspectablePrimitive(value="number udp connectbacks")
    private volatile int numUDPConnectBacksLeft;
    private final List<ConnectionFetcher> _fetchers = new ArrayList<ConnectionFetcher>();
    @InspectableForSize(value="number of skipped class C networks")
    private final Map<Integer, List<Endpoint>> classCNetworks = new HashMap<Integer, List<Endpoint>>();
    private final List<RoutedConnection> _initializingFetchedConnections = new ArrayList<RoutedConnection>();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private boolean _needPrefInterrupterScheduled = false;
    private volatile List<RoutedConnection> _connections = Collections.emptyList();
    private volatile List<RoutedConnection> _initializedConnections = Collections.emptyList();
    private volatile List<RoutedConnection> _initializedClientConnections = Collections.emptyList();
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    @InspectablePrimitive(value="leaf tries")
    private volatile int _leafTries;
    @InspectablePrimitive(value="demotion limit")
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;
    private final CopyOnWriteArrayList<ConnectionLifecycleListener> connectionLifeCycleListeners = new CopyOnWriteArrayList();
    private final Version lastGoodVersion;
    private final NetworkManager networkManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<SimppManager> simppManager;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final RoutedConnectionFactory managedConnectionFactory;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final SocketsManager socketsManager;
    private final ConnectionServices connectionServices;
    private final Provider<NodeAssigner> nodeAssigner;
    private final Provider<IPFilter> ipFilter;
    private final ConnectionCheckerManager connectionCheckerManager;
    private final PingRequestFactory pingRequestFactory;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final ActivationManager activationManager;

    @Inject
    public ConnectionManagerImpl(NetworkManager networkManager, Provider<HostCatcher> hostCatcher, @Named(value="global") Provider<ConnectionDispatcher> connectionDispatcher, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<SimppManager> simppManager, CapabilitiesVMFactory capabilitiesVMFactory, RoutedConnectionFactory managedConnectionFactory, Provider<QueryUnicaster> queryUnicaster, SocketsManager socketsManager, ConnectionServices connectionServices, Provider<NodeAssigner> nodeAssigner, Provider<IPFilter> ipFilter, ConnectionCheckerManager connectionCheckerManager, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils, ActivationManager activationManager) {
        this.networkManager = networkManager;
        this.hostCatcher = hostCatcher;
        this.connectionDispatcher = connectionDispatcher;
        this.backgroundExecutor = backgroundExecutor;
        this.simppManager = simppManager;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.managedConnectionFactory = managedConnectionFactory;
        this.queryUnicaster = queryUnicaster;
        this.socketsManager = socketsManager;
        this.connectionServices = connectionServices;
        this.nodeAssigner = nodeAssigner;
        this.ipFilter = ipFilter;
        this.connectionCheckerManager = connectionCheckerManager;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.activationManager = activationManager;
        Version v = null;
        try {
            v = new Version("4.16.6");
        }
        catch (VersionFormatException impossible) {
            // empty catch block
        }
        this.lastGoodVersion = v;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void start() {
        this.connectionDispatcher.get().addConnectionAcceptor(this, false, "GNUTELLA", "LIMEWIRE");
        if (SystemUtils.supportsIdleTime()) {
            this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ConnectionManagerImpl.this.setPreferredConnections();
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        this.simppManager.get().addListener(new SimppListener(){

            @Override
            public void simppUpdated() {
                ConnectionManagerImpl.this.capabilitiesVMFactory.updateCapabilities();
                ConnectionManagerImpl.this.sendUpdatedCapabilities();
            }
        });
        this.addEventListener(new ConnectionLifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
                if (evt.isConnectedEvent()) {
                    ArrayList filtered = new ArrayList();
                    ConnectionManagerImpl connectionManagerImpl = ConnectionManagerImpl.this;
                    synchronized (connectionManagerImpl) {
                        for (List l : ConnectionManagerImpl.this.classCNetworks.values()) {
                            filtered.addAll(l);
                            l.clear();
                        }
                    }
                    for (Endpoint e : filtered) {
                        ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).add(e, false);
                    }
                }
            }
        });
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Connection Management");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
        this.disconnect(false);
    }

    @Override
    public void createConnectionAsynchronously(String hostname, int portnum, SocketsManager.ConnectType type) {
        RoutedConnection mc = this.managedConnectionFactory.createRoutedConnection(hostname, portnum, type);
        try {
            this.initializeExternallyGeneratedConnection(mc, new IncomingGNetObserver(mc));
        }
        catch (IOException iox) {
            mc.close();
        }
    }

    @Override
    public void acceptConnection(String word, Socket socket) {
        if (word.equals("GNUTELLA") || ConnectionSettings.CONNECT_STRING.isDefault() && word.equals("LIMEWIRE")) {
            this.acceptConnection(socket);
        }
    }

    @Override
    public void acceptConnection(Socket socket) {
        RoutedConnection connection = this.managedConnectionFactory.createRoutedConnection(socket);
        IncomingGNetObserver listener = new IncomingGNetObserver(connection);
        try {
            this.initializeExternallyGeneratedConnection(connection, listener);
        }
        catch (IOException e) {
            connection.close();
            return;
        }
    }

    @Override
    public synchronized void remove(RoutedConnection mc) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(mc);
        this.adjustConnectionFetchers();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public boolean isSupernode() {
        return this.isActiveSupernode() || this.isSupernodeCapable();
    }

    @Override
    public boolean isSupernodeCapable() {
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue()) {
            return true;
        }
        if (UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue()) {
            return false;
        }
        return !this.networkInstanceUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !this.isBehindProxy() && this.minConnectTimePassed();
    }

    private boolean minConnectTimePassed() {
        if (!UltrapeerSettings.NEED_MIN_CONNECT_TIME.getValue()) {
            return true;
        }
        return Math.max(0L, System.currentTimeMillis() - this._connectTime) / 1000L >= (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue();
    }

    @Override
    public boolean isBehindProxy() {
        return ConnectionSettings.CONNECTION_METHOD.getValue() != 0;
    }

    @Override
    public boolean isActiveSupernode() {
        return !this.isShieldedLeaf() && (this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0);
    }

    @Override
    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    @Override
    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    @Override
    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    @Override
    public boolean isConnectedTo(String hostName) {
        for (RoutedConnection mc : this.getConnections()) {
            if (!mc.getAddress().equals(hostName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectingTo(IpPort host) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            for (ConnectionFetcher connectionFetcher : this._fetchers) {
                IpPort them = connectionFetcher.getIpPort();
                if (them == null || !host.getAddress().equals(them.getAddress()) || host.getPort() != them.getPort()) continue;
                return true;
            }
            for (RoutedConnection routedConnection : this._initializingFetchedConnections) {
                if (!host.getAddress().equals(routedConnection.getAddress()) || host.getPort() != routedConnection.getPort()) continue;
                return true;
            }
            return false;
        }
    }

    private boolean attemptClassC(Endpoint host) {
        if (!ConnectionSettings.FILTER_CLASS_C.getValue()) {
            return false;
        }
        List<Endpoint> l = this.classCNetworks.get(NetworkUtils.getClassC(host.getInetAddress()));
        if (l == null) {
            return false;
        }
        l.add(host);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumFetchingConnections() {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            return this._initializingFetchedConnections.size();
        }
    }

    @Override
    public int getNumConnections() {
        return this._connections.size();
    }

    @Override
    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    @Override
    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    @Override
    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    @Override
    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    @Override
    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    @Override
    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    @Override
    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    @Override
    public int getNumFreeNonLeafSlots() {
        return this._preferredConnections - this.getNumInitializedConnections();
    }

    @Override
    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections) - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    @Override
    public boolean isLocaleMatched() {
        return !ConnectionSettings.USE_LOCALE_PREF.getValue() || this._localeMatchingPeers != 0;
    }

    @Override
    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    @Override
    public boolean isFullyConnected() {
        return this._initializedConnections.size() >= this._preferredConnections;
    }

    @Override
    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        if (this._disconnectTime != 0L) {
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            return this._fetchers.size() != 0 || this._initializingFetchedConnections.size() != 0;
        }
    }

    @Override
    public void measureBandwidth() {
        float upstream = 0.0f;
        float downstream = 0.0f;
        for (RoutedConnection mc : this.getInitializedConnections()) {
            mc.measureBandwidth();
            upstream += mc.getMeasuredUpstreamBandwidth();
            downstream += mc.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = upstream;
        this._measuredDownstreamBandwidth = downstream;
    }

    @Override
    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    @Override
    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private HandshakeStatus allowConnection(RoutedConnection c) {
        if (!c.getConnectionCapabilities().receivedHeaders()) {
            return HandshakeStatus.NO_HEADERS;
        }
        return this.allowConnection(c.getConnectionCapabilities().getHeadersRead(), false);
    }

    @Override
    public HandshakeStatus allowConnectionAsLeaf(HandshakeResponse hr) {
        return this.allowConnection(hr, true);
    }

    @Override
    public HandshakeStatus allowConnection(HandshakeResponse hr) {
        return this.allowConnection(hr, !hr.isUltrapeer());
    }

    @Override
    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._preferredConnections || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    @Override
    public HandshakeStatus allowConnection(HandshakeResponse hr, boolean leaf) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return HandshakeStatus.OK;
        }
        if (!hr.isLeaf() && !hr.isUltrapeer()) {
            return HandshakeStatus.NO_X_ULTRAPEER;
        }
        int limeAttempts = ConnectionSettings.LIME_ATTEMPTS.getValue();
        if (this.isFakeLimeWire(hr)) {
            return hr.isUltrapeer() ? HandshakeStatus.TOO_MANY_UPS : HandshakeStatus.TOO_MANY_LEAF;
        }
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._preferredConnections <= 0) {
            return HandshakeStatus.DISCONNECTED;
        }
        if (this.isShieldedLeaf() || !this.isSupernode()) {
            if (!hr.isUltrapeer()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!hr.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (this._connectionAttempts < limeAttempts && !hr.isLimeWire()) {
                return HandshakeStatus.STARTING_LIMEWIRE;
            }
            if (this._shieldedConnections < this._preferredConnections) {
                if (this.checkLocale(hr.getLocalePref())) {
                    this._needPref = false;
                }
                if (this.isIdle()) {
                    if (hr.isLimeWire()) {
                        return HandshakeStatus.OK;
                    }
                    return HandshakeStatus.IDLE_LIMEWIRE;
                }
                return HandshakeStatus.OK;
            }
            if (this._needPref && this.checkLocale(hr.getLocalePref())) {
                this._needPref = false;
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_UPS;
        }
        if (hr.isLeaf() || leaf) {
            if (this.isShieldedLeaf() || !this.isSupernode()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!ConnectionManagerImpl.allowUltrapeer2LeafConnection(hr)) {
                return HandshakeStatus.NOT_ALLOWED_LEAF;
            }
            int leaves = this.getNumInitializedClientConnections();
            int nonLimeWireLeaves = this._nonLimeWireLeaves;
            if (!hr.isLimeWire() && leaves < UltrapeerSettings.MAX_LEAVES.getValue() && nonLimeWireLeaves < 2) {
                return HandshakeStatus.OK;
            }
            if (!hr.isGoodLeaf()) {
                return HandshakeStatus.NOT_GOOD_LEAF;
            }
            if (leaves + Math.max(0, 2 - nonLimeWireLeaves) < UltrapeerSettings.MAX_LEAVES.getValue()) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_LEAF;
        }
        if (hr.isUltrapeer()) {
            int peers = this.getNumInitializedConnections();
            int nonLimeWirePeers = this._nonLimeWirePeers;
            int locale_num = 0;
            if (!this.allowUltrapeer2UltrapeerConnection(hr)) {
                return HandshakeStatus.NOT_ALLOWED_UP;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(hr.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return HandshakeStatus.OK;
                }
                locale_num = this.getNumLimeWireLocalePrefSlots();
            }
            if (!hr.isLimeWire()) {
                double nonLimeRatio = (double)nonLimeWirePeers / (double)this._preferredConnections;
                if (nonLimeRatio < (double)ConnectionSettings.MIN_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                if (!hr.isGoodUltrapeer()) {
                    return HandshakeStatus.NOT_GOOD_UP;
                }
                if (nonLimeRatio < (double)ConnectionSettings.MAX_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                return HandshakeStatus.NON_LIME_RATIO;
            }
            int minNonLime = (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections);
            if (!hr.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (peers + Math.max(0, minNonLime - nonLimeWirePeers) + locale_num < this._preferredConnections) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.NO_LIME_SLOTS;
        }
        return HandshakeStatus.UNKNOWN;
    }

    boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse hr) {
        if (hr.isLimeWire()) {
            return hr.getLimeVersion() == null || hr.getLimeVersion().compareTo(this.lastGoodVersion) >= 0;
        }
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase(Locale.US);
        String[] bad = ConnectionSettings.EVIL_HOSTS.get();
        for (int i = 0; i < bad.length; ++i) {
            if (userAgent.indexOf(bad[i]) == -1) continue;
            return false;
        }
        return true;
    }

    static boolean allowUltrapeer2LeafConnection(HandshakeResponse hr) {
        if (hr.isLimeWire()) {
            return true;
        }
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase(Locale.US);
        String[] bad = ConnectionSettings.EVIL_HOSTS.get();
        for (int i = 0; i < bad.length; ++i) {
            if (userAgent.indexOf(bad[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private int ultrapeerToUltrapeerConnections() {
        int ret = 0;
        for (RoutedConnection mc : this._initializedConnections) {
            if (!mc.getConnectionCapabilities().isSupernodeSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int oldConnections() {
        int ret = 0;
        for (RoutedConnection mc : this._initializedConnections) {
            if (mc.getConnectionCapabilities().isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    @Override
    public List<RoutedConnection> getInitializedConnections() {
        return this._initializedConnections;
    }

    @Override
    public List<RoutedConnection> getInitializedConnectionsMatchLocale(String loc) {
        LinkedList<RoutedConnection> matches = new LinkedList<RoutedConnection>();
        for (RoutedConnection conn : this._initializedConnections) {
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnectionsMatchLocale(String loc) {
        LinkedList<RoutedConnection> matches = new LinkedList<RoutedConnection>();
        for (RoutedConnection conn : this._initializedClientConnections) {
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    @Override
    public List<RoutedConnection> getConnections() {
        return this._connections;
    }

    @Override
    public Set<Connectable> getPushProxies() {
        if (this.isShieldedLeaf()) {
            StrictIpPortSet<Connectable> proxies = new StrictIpPortSet<Connectable>();
            for (RoutedConnection currMC : this.getInitializedConnections()) {
                if (proxies.size() >= 4) break;
                if (!currMC.isMyPushProxy()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(currMC.getAddress() + " has version: " + currMC.getConnectionCapabilities().getUserAgent());
                }
                proxies.add(currMC);
            }
            return proxies;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean sendTCPConnectBackRequests() {
        int sent = 0;
        ArrayList<RoutedConnection> peers = new ArrayList<RoutedConnection>(this.getInitializedConnections());
        Collections.shuffle(peers);
        Iterator iter = peers.iterator();
        while (iter.hasNext()) {
            RoutedConnection currMC = (RoutedConnection)iter.next();
            if (currMC.getConnectionCapabilities().remoteHostSupportsTCPRedirect() >= 0) continue;
            iter.remove();
        }
        if (peers.size() == 1) {
            RoutedConnection myConn = (RoutedConnection)peers.get(0);
            for (int i = 0; i < 3; ++i) {
                TCPConnectBackVendorMessage cb = new TCPConnectBackVendorMessage(this.networkManager.getPort());
                myConn.send(cb);
                ++sent;
            }
        } else {
            TCPConnectBackVendorMessage cb = new TCPConnectBackVendorMessage(this.networkManager.getPort());
            for (RoutedConnection currMC : peers) {
                if (sent < 5) {
                    currMC.send(cb);
                    ++sent;
                    continue;
                }
                break;
            }
        }
        return sent > 0;
    }

    @Override
    public boolean sendUDPConnectBackRequests(GUID cbGuid) {
        int sent = 0;
        UDPConnectBackVendorMessage cb = new UDPConnectBackVendorMessage(this.networkManager.getPort(), cbGuid);
        ArrayList<RoutedConnection> peers = new ArrayList<RoutedConnection>(this.getInitializedConnections());
        Collections.shuffle(peers);
        for (RoutedConnection currMC : peers) {
            if (sent >= 5) break;
            if (currMC.getConnectionCapabilities().remoteHostSupportsUDPConnectBack() < 0) continue;
            currMC.send(cb);
            ++sent;
        }
        return sent > 0;
    }

    @Override
    public void updateQueryStatus(QueryStatusResponse stat) {
        if (this.isShieldedLeaf()) {
            for (RoutedConnection currMC : this.getInitializedConnections()) {
                if (currMC.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 0) continue;
                currMC.send(stat);
            }
        }
    }

    @Override
    public Endpoint getConnectedGUESSUltrapeer() {
        for (RoutedConnection connection : this._initializedConnections) {
            if (!connection.getConnectionCapabilities().isSupernodeConnection() || !connection.getConnectionCapabilities().isGUESSUltrapeer()) continue;
            return new Endpoint(connection.getInetAddress().getAddress(), connection.getPort());
        }
        return null;
    }

    @Override
    public List<RoutedConnection> getConnectedGUESSUltrapeers() {
        ArrayList<RoutedConnection> retList = new ArrayList<RoutedConnection>();
        for (RoutedConnection connection : this._initializedConnections) {
            if (!connection.getConnectionCapabilities().isSupernodeConnection() || !connection.getConnectionCapabilities().isGUESSUltrapeer()) continue;
            retList.add(connection);
        }
        return retList;
    }

    private void connectionInitializing(RoutedConnection c) {
        ArrayList<RoutedConnection> newConnections = new ArrayList<RoutedConnection>(this._connections);
        newConnections.add(c);
        this._connections = Collections.unmodifiableList(newConnections);
        try {
            int classC = NetworkUtils.getClassC(InetAddress.getByName(c.getAddress()));
            List<Endpoint> l = this.classCNetworks.get(classC);
            if (l == null) {
                this.classCNetworks.put(classC, new ArrayList());
            }
        }
        catch (UnknownHostException uhe) {
            LOG.info("Exception while initializing connection", uhe);
        }
    }

    @Override
    public void connectionInitializingIncoming(RoutedConnection c) {
        this.connectionInitializing(c);
    }

    @Override
    public boolean connectionInitialized(RoutedConnection c) {
        if (this._connections.contains(c)) {
            if (!this.allowInitializedConnection(c)) {
                this.removeInternal(c);
                return false;
            }
            if (!c.getConnectionCapabilities().isSupernodeClientConnection()) {
                ArrayList<RoutedConnection> newConnections = new ArrayList<RoutedConnection>(this._initializedConnections);
                newConnections.add(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.getConnectionCapabilities().isClientSupernodeConnection()) {
                    this.killPeerConnections();
                    ++this._shieldedConnections;
                }
                if (!c.getConnectionCapabilities().isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList<RoutedConnection> newConnections = new ArrayList<RoutedConnection>(this._initializedClientConnections);
                newConnections.add(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.getConnectionCapabilities().isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            c.sendPostInitializeMessages();
            this.sendInitialPingRequest(c);
            return true;
        }
        return false;
    }

    private boolean allowInitializedConnection(RoutedConnection c) {
        if (!(!this.isShieldedLeaf() && this.isSupernode() || c.getConnectionCapabilities().isClientSupernodeConnection())) {
            return false;
        }
        List<RoutedConnection> connections = this.getConnections();
        int listenPort = c.getListeningPort();
        String addr = c.getAddress();
        for (int i = 0; i < connections.size(); ++i) {
            RoutedConnection mc = connections.get(i);
            if (mc == c || ConnectionSettings.ALLOW_DUPLICATE.getValue() || !addr.equals(mc.getAddress())) continue;
            int mcLP = mc.getListeningPort();
            if (listenPort != -1 && listenPort != 0 && mcLP != -1 && mcLP != 0 && mcLP != listenPort) continue;
            return false;
        }
        return this.allowConnection(c.getConnectionCapabilities().getHeadersRead()).isAcceptable();
    }

    private void killPeerConnections() {
        List<RoutedConnection> conns = this._initializedConnections;
        for (RoutedConnection con : conns) {
            if (!con.getConnectionCapabilities().isSupernodeSupernodeConnection()) continue;
            this.removeInternal(con);
        }
    }

    @Override
    public void sendUpdatedCapabilities() {
        List<RoutedConnection> allConnections = this.getAllConnectionsShuffled();
        for (RoutedConnection connection : allConnections) {
            connection.sendUpdatedCapabilities();
        }
    }

    private List<RoutedConnection> getAllConnectionsShuffled() {
        List<RoutedConnection> peers = this.getInitializedConnections();
        List<RoutedConnection> leafs = this.getInitializedClientConnections();
        ArrayList<RoutedConnection> allConnections = new ArrayList<RoutedConnection>(peers.size() + leafs.size());
        allConnections.addAll(peers);
        allConnections.addAll(leafs);
        Collections.shuffle(allConnections);
        return allConnections;
    }

    @Override
    public synchronized void disconnect(boolean willTryToReconnect) {
        if (this._disconnectTime == 0L) {
            long averageUptime = this.getCurrentAverageUptime();
            int totalConnections = Math.max(1, ApplicationSettings.TOTAL_CONNECTIONS.getValue() + 1);
            long totalConnectTime = averageUptime * (long)totalConnections;
            ApplicationSettings.TOTAL_CONNECTION_TIME.setValue(totalConnectTime);
            ApplicationSettings.TOTAL_CONNECTIONS.setValue(totalConnections);
            ApplicationSettings.AVERAGE_CONNECTION_TIME.setValue(averageUptime);
        }
        this._disconnectTime = System.currentTimeMillis();
        this._connectTime = Long.MAX_VALUE;
        this._preferredConnections = 0;
        this.adjustConnectionFetchers();
        for (RoutedConnection c : this.getConnections()) {
            this.remove(c);
            if (!c.getConnectionCapabilities().isSupernodeConnection()) continue;
            ExtendedEndpoint ee = new ExtendedEndpoint(c.getInetAddress().getHostAddress(), c.getPort(), c.getLocalePref());
            ee.setTLSCapable(c.isTLSCapable());
            this.hostCatcher.get().add((Endpoint)ee, true);
        }
        if (!willTryToReconnect) {
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.DISCONNECTED, null));
        }
    }

    @Override
    public synchronized long getCurrentAverageUptime() {
        long currentAverage = 0L;
        long now = System.currentTimeMillis();
        long sessionTime = Math.max(0L, now - this._connectTime);
        int totalConnections = ApplicationSettings.TOTAL_CONNECTIONS.getValue();
        if (sessionTime != 0L) {
            ++totalConnections;
        }
        long totalConnectTime = Math.max(0L, ApplicationSettings.TOTAL_CONNECTION_TIME.getValue() + sessionTime);
        currentAverage = totalConnectTime / (long)Math.max(1, totalConnections);
        return currentAverage;
    }

    @Override
    public synchronized void connect() {
        this._disconnectTime = 0L;
        this._connectTime = System.currentTimeMillis();
        if (this.isConnected() || this.hostCatcher == null) {
            return;
        }
        this._connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        this.numTCPConnectBacksLeft = 10;
        this.numUDPConnectBacksLeft = 15;
        this.setPreferredConnections();
        this.hostCatcher.get().connect();
    }

    private void sendInitialPingRequest(RoutedConnection connection) {
        if (connection.getConnectionCapabilities().supportsPongCaching()) {
            return;
        }
        PingRequest pr = this.getNumInitializedConnections() >= this._preferredConnections ? this.pingRequestFactory.createPingRequest((byte)1) : this.pingRequestFactory.createPingRequest((byte)4);
        connection.send(pr);
    }

    private void removeInternal(RoutedConnection c) {
        ArrayList<Object> newConnections;
        int i;
        if (!c.getConnectionCapabilities().isSupernodeClientConnection()) {
            i = this._initializedConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList<RoutedConnection>();
                newConnections.addAll(this._initializedConnections);
                newConnections.remove(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.getConnectionCapabilities().isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!c.getConnectionCapabilities().isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            i = this._initializedClientConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedClientConnections);
                newConnections.remove(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.getConnectionCapabilities().isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        i = this._connections.indexOf(c);
        if (i != -1) {
            newConnections = new ArrayList<RoutedConnection>(this._connections);
            newConnections.remove(c);
            this._connections = Collections.unmodifiableList(newConnections);
        }
        try {
            List<Endpoint> l = this.classCNetworks.remove(NetworkUtils.getClassC(InetAddress.getByName(c.getAddress())));
            if (l != null) {
                for (Endpoint ip : l) {
                    this.hostCatcher.get().add(ip, false);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        c.close();
        this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTION_CLOSED, c));
        this.queryUnicaster.get().purgeQuery(c);
    }

    private synchronized void stabilizeConnections() {
        while (this.getNumInitializedConnections() > this._preferredConnections) {
            RoutedConnection newest = null;
            for (RoutedConnection c : this._initializedConnections) {
                if (!c.getConnectionCapabilities().isLimeWire()) {
                    newest = c;
                    break;
                }
                if (newest != null && c.getConnectionTime() <= newest.getConnectionTime()) continue;
                newest = c;
            }
            if (newest == null) continue;
            this.remove(newest);
        }
        this.adjustConnectionFetchers();
    }

    private void adjustConnectionFetchers() {
        int i;
        int multiple;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            this.startDedicatedLocaleFetcher();
        }
        int goodConnections = this.getNumInitializedConnections();
        int neededConnections = this._preferredConnections - goodConnections;
        if (!this.networkManager.acceptedIncomingConnection() && !this.isActiveSupernode()) {
            multiple = 3;
        } else if (!this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            multiple = 3;
        } else if (neededConnections > 10) {
            multiple = 2;
        } else {
            multiple = 1;
            neededConnections = (int)((float)neededConnections - (5.0f + ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections));
        }
        int need = Math.min(10, multiple * neededConnections) - this._fetchers.size() - this._initializingFetchedConnections.size();
        List fetchers = Collections.emptyList();
        if (need > 0) {
            fetchers = new ArrayList(need);
            for (need = Math.min(need, this.socketsManager.getNumAllowedSockets()); need > 0; --need) {
                ConnectionFetcher fetcher = new ConnectionFetcher();
                fetchers.add(fetcher);
            }
            this._fetchers.addAll(fetchers);
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTING, null));
        }
        int lastFetcherIndex = this._fetchers.size();
        ArrayList<Object> extras = new ArrayList<Object>();
        while (need < 0 && lastFetcherIndex > 0) {
            ConnectionFetcher fetcher = this._fetchers.remove(--lastFetcherIndex);
            ++need;
            extras.add(fetcher);
        }
        int lastInitializingConnectionIndex = this._initializingFetchedConnections.size();
        while (need < 0 && lastInitializingConnectionIndex > 0) {
            RoutedConnection connection = this._initializingFetchedConnections.remove(--lastInitializingConnectionIndex);
            ++need;
            extras.add(connection);
        }
        for (i = fetchers.size() - 1; i >= 0; --i) {
            ConnectionFetcher fetcher = (ConnectionFetcher)fetchers.remove(i);
            fetcher.connect();
        }
        for (i = extras.size() - 1; i >= 0; --i) {
            Object next = extras.remove(i);
            if (next instanceof ConnectionFetcher) {
                ((ConnectionFetcher)next).stopConnecting();
                continue;
            }
            this.removeInternal((RoutedConnection)next);
        }
    }

    private void startDedicatedLocaleFetcher() {
        if (this.connectionServices.isShieldedLeaf() && this._needPref && !this._needPrefInterrupterScheduled && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            this._dedicatedPrefFetcher.connect();
            Runnable interrupted = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ConnectionManagerImpl connectionManagerImpl = ConnectionManagerImpl.this;
                    synchronized (connectionManagerImpl) {
                        ConnectionManagerImpl.this._needPref = false;
                        if (ConnectionManagerImpl.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManagerImpl.this._dedicatedPrefFetcher.stopConnecting();
                        ConnectionManagerImpl.this._dedicatedPrefFetcher = null;
                    }
                }
            };
            this._needPrefInterrupterScheduled = true;
            this.backgroundExecutor.schedule(interrupted, 15000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(RoutedConnection mc, ConnectionFetcher fetcher) {
        block8: {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                if (fetcher.isPrematurelyStopped()) {
                    fetcher.finish();
                    return;
                }
                this._initializingFetchedConnections.add(mc);
                if (fetcher == this._dedicatedPrefFetcher) {
                    this._dedicatedPrefFetcher = null;
                } else {
                    this._fetchers.remove(fetcher);
                }
                this.connectionInitializing(mc);
            }
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTION_INITIALIZING, mc));
            try {
                mc.initialize(fetcher);
            }
            catch (IOException e) {
                this.cleanupBrokenFetchedConnection(mc);
                if (!LOG.isInfoEnabled()) break block8;
                LOG.info("Exception initializing connection to " + mc.getAddress() + ":" + mc.getPort(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrokenFetchedConnection(RoutedConnection mc) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            this._initializingFetchedConnections.remove(mc);
            this.removeInternal(mc);
            this.adjustConnectionFetchers();
        }
        this.processConnectionHeaders(mc);
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.getConnectionCapabilities().receivedHeaders()) {
            return;
        }
        Properties headers = connection.getConnectionCapabilities().getHeadersRead().props();
        if (headers == null) {
            return;
        }
        this.updateHostCache(connection.getConnectionCapabilities().getHeadersRead());
        String remoteAddress = headers.getProperty("Listen-IP");
        if (remoteAddress == null) {
            remoteAddress = headers.getProperty("X-My-Address");
        }
        if (remoteAddress != null && !connection.isOutgoing()) {
            int colonIndex = remoteAddress.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            if (++colonIndex > remoteAddress.length()) {
                return;
            }
            try {
                int port = Integer.parseInt(remoteAddress.substring(colonIndex).trim());
                if (NetworkUtils.isValidPort(port)) {
                    connection.setListeningPort(port);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean allowLeafDemotion() {
        ++this._leafTries;
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isActiveSupernode()) {
            return false;
        }
        return !this.nodeAssigner.get().isTooGoodUltrapeerToPassUp() || this._leafTries >= this._demotionLimit;
    }

    @Override
    public void tryToBecomeAnUltrapeer(int demotionLimit) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = demotionLimit;
        this._leafTries = 0;
        this.disconnect(true);
        this.connect();
    }

    private void updateHostCache(HandshakeResponse headers) {
        if (!headers.hasXTryUltrapeers()) {
            return;
        }
        String hostAddresses = headers.getXTryUltrapeers();
        StringTokenizer st = new StringTokenizer(hostAddresses, ",");
        ArrayList<Endpoint> hosts = new ArrayList<Endpoint>(st.countTokens());
        while (st.hasMoreTokens()) {
            String address = st.nextToken().trim();
            try {
                hosts.add(new Endpoint(address));
            }
            catch (IllegalArgumentException iae) {}
        }
        this.hostCatcher.get().add(ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(hosts) : hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(RoutedConnection c, GnetConnectObserver observer) throws IOException {
        if (c.isOutgoing()) {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                this.connectionInitializing(c);
                this.adjustConnectionFetchers();
            }
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTION_INITIALIZING, c));
        }
        try {
            c.initialize(observer);
        }
        catch (IOException e) {
            this.cleanupBrokenExternallyGeneratedConnection(c);
            if (LOG.isInfoEnabled()) {
                LOG.info("Exception initializing connection to " + c.getAddress() + ":" + c.getPort(), e);
            }
            throw e;
        }
    }

    private void cleanupBrokenExternallyGeneratedConnection(RoutedConnection c) {
        this.remove(c);
        this.processConnectionHeaders(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeInitializeExternallyGeneratedConnection(RoutedConnection c) throws IOException {
        this.processConnectionHeaders(c);
        if (!c.isOutgoing() && !this.allowConnection(c).isAcceptable()) {
            throw new IOException("No space for connection");
        }
        if (!c.isOutgoing()) {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                this.connectionInitializingIncoming(c);
                this.adjustConnectionFetchers();
            }
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTION_INITIALIZING, c));
        }
        return this.completeConnectionInitialization(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeConnectionInitialization(RoutedConnection mc, boolean fetched) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            boolean connectionOpen;
            if (fetched) {
                this._initializingFetchedConnections.remove(mc);
            }
            if (connectionOpen = this.connectionInitialized(mc)) {
                this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTION_INITIALIZED, mc));
                this.setPreferredConnections();
                if (this._initializedConnections.size() >= this.getPreferredConnectionCount()) {
                    this._lastFullConnectTime = System.currentTimeMillis();
                    this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.CONNECTED, mc));
                }
            }
            return connectionOpen;
        }
    }

    @Override
    public int getPreferredConnectionCount() {
        return this._preferredConnections;
    }

    @Override
    public boolean isConnectionIdle() {
        return this._preferredConnections == ConnectionSettings.IDLE_CONNECTIONS.getValue();
    }

    protected void setPreferredConnections() {
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._disconnectTime != 0L) {
            return;
        }
        if (this.isSupernode()) {
            this.setPreferredConnections(ConnectionSettings.NUM_CONNECTIONS.getValue());
        } else if (this.isIdle()) {
            this.setPreferredConnections(ConnectionSettings.IDLE_CONNECTIONS.getValue());
        } else {
            this.setPreferredConnections(this.activationManager.isActive(ActivationID.TURBO_CHARGED_DOWNLOADS_MODULE) ? 5 : 3);
        }
    }

    protected void setPreferredConnections(int connections) {
        int oldPreferred = this._preferredConnections;
        this._preferredConnections = connections;
        if (oldPreferred != connections) {
            this.stabilizeConnections();
        }
    }

    private boolean isIdle() {
        return SystemUtils.getIdleTime() >= 1800000L;
    }

    private void startConnection(RoutedConnection conn) throws IOException {
        if (conn.getConnectionCapabilities().isGUESSUltrapeer()) {
            this.queryUnicaster.get().addUnicastEndpoint(conn.getInetAddress(), conn.getPort());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looping for messages with conn: " + conn);
        }
        conn.startMessaging();
    }

    @Override
    public void noInternetConnection() {
        this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEventType.NO_INTERNET));
        if (this._automaticallyConnecting) {
            return;
        }
        this.disconnect(false);
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (ConnectionManagerImpl.this._automaticConnectTime < ConnectionManagerImpl.this._disconnectTime) {
                    return;
                }
                if (!ConnectionManagerImpl.this.connectionServices.isConnected()) {
                    ConnectionManagerImpl.this.connect();
                }
            }
        }, 10000L, 30000L, TimeUnit.MILLISECONDS);
        this._automaticConnectTime = System.currentTimeMillis();
        this._automaticallyConnecting = true;
        this.hostCatcher.get().noInternetConnection();
    }

    private boolean checkLocale(String loc) {
        if (loc == null) {
            loc = ApplicationSettings.DEFAULT_LOCALE.get();
        }
        return ApplicationSettings.LANGUAGE.get().equals(loc);
    }

    @Override
    public void addEventListener(ConnectionLifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException("ConnectionLifecycleListener is null");
        }
        if (!this.connectionLifeCycleListeners.addIfAbsent(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " already registered");
        }
    }

    @Override
    public void dispatchEvent(ConnectionLifecycleEvent event) {
        for (ConnectionLifecycleListener listener : this.connectionLifeCycleListeners) {
            listener.handleConnectionLifecycleEvent(event);
        }
    }

    @Override
    public void removeEventListener(ConnectionLifecycleListener listener) {
        this.connectionLifeCycleListeners.remove(listener);
    }

    @Override
    public int countConnectionsWithNMessages(int messageThreshold) {
        int count = 0;
        for (RoutedConnection c : this.getInitializedConnections()) {
            int msgs = c.getConnectionMessageStatistics().getNumMessagesSent();
            if ((msgs += c.getConnectionMessageStatistics().getNumMessagesReceived()) <= messageThreshold) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getActiveConnectionMessages() {
        int count = 0;
        for (RoutedConnection c : this.getInitializedConnections()) {
            count += c.getConnectionMessageStatistics().getNumMessagesSent();
            count += c.getConnectionMessageStatistics().getNumMessagesReceived();
        }
        return count;
    }

    @Override
    public boolean canSendConnectBack(Message.Network network) {
        if (network == Message.Network.TCP) {
            return this.numTCPConnectBacksLeft > 0;
        }
        if (network == Message.Network.UDP) {
            return this.numUDPConnectBacksLeft > 0;
        }
        return false;
    }

    @Override
    public void connectBackSent(Message.Network network) {
        if (network == Message.Network.TCP) {
            --this.numTCPConnectBacksLeft;
        } else if (network == Message.Network.UDP) {
            --this.numUDPConnectBacksLeft;
        } else {
            throw new IllegalArgumentException("which network?");
        }
    }

    @Override
    public void handleEvent(GnutellaConnectionEvent event) {
        Set<Connectable> pushProxies = this.getPushProxies();
        if (!pushProxies.isEmpty()) {
            this.networkManager.newPushProxies(pushProxies);
        }
    }

    private boolean isFakeLimeWire(HandshakeResponse hr) {
        Properties headers = hr.props();
        String agent = headers.getProperty("User-Agent");
        String requeries = headers.getProperty("X-Requeries");
        return agent != null && agent.startsWith("LimeWire") && requeries == null && Math.random() < 0.95;
    }

    private class LegacyConnectionStats
    implements Inspectable {
        private final boolean leaf;

        private LegacyConnectionStats(boolean leaf) {
            this.leaf = leaf;
        }

        @Override
        public Object inspect() {
            if (this.leaf && !ConnectionManagerImpl.this.isSupernode()) {
                return Collections.EMPTY_MAP;
            }
            List<RoutedConnection> conns = ConnectionManagerImpl.this.getConnections();
            HashMap<String, Object> ret = new HashMap<String, Object>(conns.size());
            for (RoutedConnection mc : conns) {
                if (ConnectionManagerImpl.this.isSupernode() && (this.leaf && mc.getConnectionCapabilities().isSupernodeConnection() || !this.leaf && mc.getConnectionCapabilities().isSupernodeClientConnection())) continue;
                ret.put(mc.getAddress() + ":" + mc.getPort(), ((Inspectable)((Object)mc)).inspect());
            }
            return ret;
        }
    }

    private class ConnectionFetcher
    implements GnetConnectObserver,
    HostCatcher.EndpointObserver {
        private final boolean _pref;
        private volatile RoutedConnection connection;
        private volatile Endpoint endpoint;
        private volatile boolean stoppedEarly = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean pref) {
            this._pref = pref;
        }

        IpPort getIpPort() {
            if (this.connection != null) {
                return this.connection;
            }
            if (this.endpoint != null) {
                return this.endpoint;
            }
            return null;
        }

        public void connect() {
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).getAnEndpoint(this);
        }

        public void stopConnecting() {
            this.stoppedEarly = true;
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).removeEndpointObserver(this);
        }

        public boolean isPrematurelyStopped() {
            return this.stoppedEarly;
        }

        public void finish() {
        }

        private boolean isConnectableHost(IpPort host) {
            return ((IPFilter)ConnectionManagerImpl.this.ipFilter.get()).allow(host.getAddress()) && !ConnectionManagerImpl.this.isConnectedTo(host.getAddress()) && !ConnectionManagerImpl.this.isConnectingTo(host);
        }

        @Override
        public void handleEndpoint(Endpoint incoming) {
            assert (incoming != null);
            while (!this.isConnectableHost(incoming) || ConnectionManagerImpl.this.attemptClassC(incoming)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Ignoring unconnectable host: " + incoming);
                }
                if ((incoming = ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).getAnEndpointImmediate(this)) != null) continue;
                LOG.info("No hosts available, waiting on a new one");
                return;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting fetch for connectable host: " + incoming);
            }
            this.endpoint = incoming;
            SocketsManager.ConnectType type = this.endpoint.isTLSCapable() && ConnectionManagerImpl.this.networkManager.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
            LOG.debugf("connecting to {0}, with connect type {1}", (Object)incoming, (Object)type);
            this.connection = ConnectionManagerImpl.this.managedConnectionFactory.createRoutedConnection(this.endpoint.getAddress(), this.endpoint.getPort(), type);
            this.connection.setLocalePreferencing(this._pref);
            this.doConnectionCheck();
            ConnectionManagerImpl.this._connectionAttempts++;
            ConnectionManagerImpl.this.initializeFetchedConnection(this.connection, this);
        }

        @Override
        public void handleConnect() {
            if (ConnectionManagerImpl.this.completeConnectionInitialization(this.connection, true)) {
                ConnectionManagerImpl.this.processConnectionHeaders(this.connection);
                ConnectionManagerImpl.this._lastSuccessfulConnect = System.currentTimeMillis();
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, true);
                if (this._pref) {
                    ConnectionManagerImpl.this._needPref = false;
                }
                try {
                    ConnectionManagerImpl.this.startConnection(this.connection);
                }
                catch (IOException iOException) {}
            } else {
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, false);
            }
        }

        @Override
        public void shutdown() {
            ConnectionManagerImpl.this.cleanupBrokenFetchedConnection(this.connection);
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, false);
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).expireHost(this.endpoint);
        }

        @Override
        public void handleBadHandshake() {
            this.shutdown();
        }

        @Override
        public void handleNoGnutellaOk(int code, String msg) {
            ConnectionManagerImpl.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManagerImpl.this._lastSuccessfulConnect = System.currentTimeMillis();
            if (code == 577) {
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).add(this.endpoint, true, this.connection.getLocalePref());
            } else {
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, false);
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).putHostOnProbation(this.endpoint);
            }
        }

        private void doConnectionCheck() {
            long curTime = System.currentTimeMillis();
            if (!ConnectionManagerImpl.this.isConnected() && ConnectionManagerImpl.this._connectionAttempts > 40 && curTime - ConnectionManagerImpl.this._lastSuccessfulConnect > 4000L && curTime - ConnectionManagerImpl.this._lastConnectionCheck > 3600000L) {
                ConnectionManagerImpl.this._connectionAttempts = 0;
                ConnectionManagerImpl.this._lastConnectionCheck = curTime;
                LOG.debug("checking for live connection");
                ConnectionManagerImpl.this.connectionCheckerManager.checkForLiveConnection();
            }
        }
    }

    private class IncomingGNetObserver
    implements GnetConnectObserver {
        private final RoutedConnection connection;

        IncomingGNetObserver(RoutedConnection connection) {
            this.connection = connection;
        }

        @Override
        public void handleConnect() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completing IncomingGNetObserver.handleConnect for: " + this.connection);
            }
            try {
                if (ConnectionManagerImpl.this.completeInitializeExternallyGeneratedConnection(this.connection)) {
                    ConnectionManagerImpl.this.startConnection(this.connection);
                }
            }
            catch (IOException ignored) {
                LOG.warn("Failed to complete initialization", ignored);
            }
        }

        @Override
        public void handleBadHandshake() {
            this.shutdown();
        }

        @Override
        public void handleNoGnutellaOk(int code, String msg) {
            this.shutdown();
        }

        @Override
        public void shutdown() {
            LOG.debug("Shutting down IncomingGNetobserver for: " + this.connection);
            ConnectionManagerImpl.this.cleanupBrokenExternallyGeneratedConnection(this.connection);
        }
    }
}

