/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.browser.ControlRequestAcceptor;
import com.limegroup.gnutella.browser.LocalHTTPAcceptor;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.lws.server.LWSManager;
import org.limewire.core.settings.LWSSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.net.ConnectionDispatcher;

@EagerSingleton
class ConnectionAcceptorGlue {
    private final ConnectionDispatcher externalDispatcher;
    private final ConnectionDispatcher localDispatcher;
    private final LocalHTTPAcceptor localHttpAcceptor;
    private final HTTPAcceptor externalHttpAcceptor;
    private final PushDownloadManager pushDownloadManager;
    private final ControlRequestAcceptor controlRequestAcceptor;
    private final LWSManager lwsManager;

    @Inject
    public ConnectionAcceptorGlue(@Named(value="global") ConnectionDispatcher externalDispatcher, @Named(value="local") ConnectionDispatcher localDispatcher, HTTPAcceptor externalHttpAcceptor, LocalHTTPAcceptor localHttpAcceptor, PushDownloadManager pushDownloadManager, ControlRequestAcceptor controlRequestAcceptor, LWSManager lwsManager) {
        this.externalDispatcher = externalDispatcher;
        this.localDispatcher = localDispatcher;
        this.externalHttpAcceptor = externalHttpAcceptor;
        this.pushDownloadManager = pushDownloadManager;
        this.localHttpAcceptor = localHttpAcceptor;
        this.controlRequestAcceptor = controlRequestAcceptor;
        this.lwsManager = lwsManager;
    }

    @Inject
    private void register(ServiceRegistry registry) {
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return I18nMarker.marktr("Connection Dispatching");
            }

            @Override
            public void initialize() {
            }

            @Override
            public void start() {
                ConnectionAcceptorGlue.this.externalDispatcher.addConnectionAcceptor(ConnectionAcceptorGlue.this.externalHttpAcceptor, false, ConnectionAcceptorGlue.this.externalHttpAcceptor.getHttpMethods());
                ConnectionAcceptorGlue.this.externalDispatcher.addConnectionAcceptor(ConnectionAcceptorGlue.this.pushDownloadManager, false, "GIV");
                ConnectionAcceptorGlue.this.localDispatcher.addConnectionAcceptor(ConnectionAcceptorGlue.this.localHttpAcceptor, true, ConnectionAcceptorGlue.this.localHttpAcceptor.getHttpMethods());
                ConnectionAcceptorGlue.this.localDispatcher.addConnectionAcceptor(ConnectionAcceptorGlue.this.controlRequestAcceptor, true, "MAGNET", "TORRENT");
                ConnectionAcceptorGlue.this.externalDispatcher.addConnectionAcceptor(ConnectionAcceptorGlue.this.controlRequestAcceptor, true, "MAGNET", "TORRENT");
                if (LWSSettings.LWS_IS_ENABLED.getValue()) {
                    ConnectionAcceptorGlue.this.localHttpAcceptor.registerHandler("/store:*", ConnectionAcceptorGlue.this.lwsManager.getHandler());
                }
            }

            @Override
            public void stop() {
            }
        }).in(ServiceStage.LATE);
    }
}

