/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.limegroup.bittorrent.BTTorrentFileDownloader;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.limewire.bittorrent.BTDataImpl;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.core.settings.SharingSettings;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

public class BTTorrentFileDownloaderImpl
extends AbstractCoreDownloader
implements BTTorrentFileDownloader,
EventListener<DownloadStateEvent> {
    private static Log LOG = LogFactory.getLog(BTTorrentFileDownloaderImpl.class);
    private static final int TIMEOUT = 5000;
    private final DownloadManager downloadManager;
    private final HttpExecutor httpExecutor;
    private final EventListenerList<DownloadStateEvent> eventListenerList;
    private Downloader.DownloadState downloadStatus = Downloader.DownloadState.QUEUED;
    private File torrentFile = null;
    private final File incompleteTorrentFile;
    private final VirusScanner virusScanner;
    private volatile Shutdownable aborter;
    private URI torrentURI;

    @Inject
    public BTTorrentFileDownloaderImpl(DownloadManager downloadManager, SaveLocationManager saveLocationManager, HttpExecutor httpExecutor, ActivityCallback activityCallback, CategoryManager categoryManager, VirusScanner virusScanner) {
        super(saveLocationManager, categoryManager);
        this.downloadManager = Objects.nonNull(downloadManager, "downloadManager");
        this.httpExecutor = Objects.nonNull(httpExecutor, "httpExecutor");
        this.virusScanner = virusScanner;
        this.eventListenerList = new EventListenerList();
        this.incompleteTorrentFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.get(), UUID.randomUUID().toString() + ".torrent");
        this.addListener(this);
    }

    private void fetch() {
        HttpGet get = new HttpGet(this.torrentURI);
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 5000);
        HttpClientParams.setRedirecting(params, true);
        this.aborter = this.httpExecutor.execute(get, params, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean requestComplete(HttpUriRequest method, HttpResponse response) {
        FileInputStream torrentInputStream;
        FileOutputStream torrentOutputStream;
        InputStream torrentDownloadStream;
        block15: {
            BTDataImpl btData;
            block14: {
                this.aborter = null;
                if (this.downloadStatus == Downloader.DownloadState.ABORTED) {
                    return false;
                }
                torrentDownloadStream = null;
                torrentOutputStream = null;
                torrentInputStream = null;
                int status = response.getStatusLine().getStatusCode();
                if (status < 200 || status >= 300) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Bad status code: " + status);
                    }
                    this.downloadStatus = Downloader.DownloadState.UNABLE_TO_CONNECT;
                    this.httpExecutor.releaseResources(response);
                    this.eventListenerList.broadcast(new DownloadStateEvent(this, this.downloadStatus));
                    return false;
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Invalid response: no entity");
                    }
                    this.downloadStatus = Downloader.DownloadState.INVALID;
                    this.httpExecutor.releaseResources(response);
                    this.eventListenerList.broadcast(new DownloadStateEvent(this, this.downloadStatus));
                    return false;
                }
                this.incompleteTorrentFile.getParentFile().mkdirs();
                torrentDownloadStream = response.getEntity().getContent();
                torrentOutputStream = new FileOutputStream(this.incompleteTorrentFile);
                FileUtils.write(torrentDownloadStream, torrentOutputStream);
                torrentInputStream = new FileInputStream(this.incompleteTorrentFile);
                torrentOutputStream.close();
                Map torrentFileMap = (Map)Token.parse(torrentInputStream.getChannel());
                btData = new BTDataImpl(torrentFileMap);
                if (!this.virusScanner.isEnabled() || !this.virusScanner.isInfected(this.incompleteTorrentFile)) break block14;
                this.downloadStatus = Downloader.DownloadState.THREAT_FOUND;
                boolean bl = false;
                IOUtils.close(torrentInputStream);
                IOUtils.close(torrentDownloadStream);
                IOUtils.close(torrentOutputStream);
                this.httpExecutor.releaseResources(response);
                this.deleteIncompleteFiles();
                return bl;
            }
            this.downloadStatus = Downloader.DownloadState.COMPLETE;
            {
                catch (VirusScanException e) {
                    this.setAttribute("scanner.failureHint", (Object)e.getDetail(), false);
                    this.downloadStatus = Downloader.DownloadState.SCAN_FAILED;
                    boolean bl = false;
                    IOUtils.close(torrentInputStream);
                    IOUtils.close(torrentDownloadStream);
                    IOUtils.close(torrentOutputStream);
                    this.httpExecutor.releaseResources(response);
                    this.deleteIncompleteFiles();
                    return bl;
                }
            }
            try {
                this.torrentFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.get(), btData.getName() + ".torrent");
                if (this.torrentFile.exists()) break block15;
                FileUtils.forceRename(this.incompleteTorrentFile, this.torrentFile);
            }
            catch (IOException iox) {
                block16: {
                    try {
                        this.downloadStatus = Downloader.DownloadState.INVALID;
                        if (!LOG.isErrorEnabled()) break block16;
                        LOG.error("Error downloading torrent: " + this.torrentURI, iox);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(torrentInputStream);
                        IOUtils.close(torrentDownloadStream);
                        IOUtils.close(torrentOutputStream);
                        this.httpExecutor.releaseResources(response);
                        this.deleteIncompleteFiles();
                        throw throwable;
                    }
                }
                IOUtils.close(torrentInputStream);
                IOUtils.close(torrentDownloadStream);
                IOUtils.close(torrentOutputStream);
                this.httpExecutor.releaseResources(response);
                this.deleteIncompleteFiles();
            }
        }
        IOUtils.close(torrentInputStream);
        IOUtils.close(torrentDownloadStream);
        IOUtils.close(torrentOutputStream);
        this.httpExecutor.releaseResources(response);
        this.deleteIncompleteFiles();
        this.eventListenerList.broadcast(new DownloadStateEvent(this, this.downloadStatus));
        return false;
    }

    @Override
    public boolean requestFailed(HttpUriRequest method, HttpResponse response, IOException exc) {
        this.downloadStatus = Downloader.DownloadState.UNABLE_TO_CONNECT;
        this.downloadManager.remove(this, true);
        this.eventListenerList.broadcast(new DownloadStateEvent(this, Downloader.DownloadState.UNABLE_TO_CONNECT));
        return false;
    }

    @Override
    public void discardUnscannedPreview(boolean delete) {
    }

    @Override
    public long getAmountLost() {
        return 0L;
    }

    @Override
    public int getAmountPending() {
        return 0;
    }

    @Override
    public long getAmountRead() {
        return 0L;
    }

    @Override
    public long getAmountVerified() {
        return 0L;
    }

    @Override
    public List<RemoteFileDesc> getRemoteFileDescs() {
        return Collections.emptyList();
    }

    @Override
    public int getChunkSize() {
        return 1;
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    @Override
    public File getDownloadFragment(Downloader.ScanListener listener) {
        return null;
    }

    @Override
    public File getFile() {
        return this.getSaveFile();
    }

    @Override
    public int getNumHosts() {
        return 0;
    }

    @Override
    public List<Address> getSourcesAsAddresses() {
        return Collections.emptyList();
    }

    @Override
    public List<SourceInfo> getSourcesDetails() {
        return Collections.emptyList();
    }

    @Override
    public int getQueuePosition() {
        return 0;
    }

    @Override
    public int getQueuedHostCount() {
        return 0;
    }

    @Override
    public int getRemainingStateTime() {
        return 0;
    }

    @Override
    public URN getSha1Urn() {
        return null;
    }

    @Override
    public File getSaveFile() {
        int slash;
        String uri = this.torrentURI.toString();
        String name = null;
        if (uri.endsWith(".torrent") && (slash = uri.lastIndexOf("/")) != -1) {
            name = uri.substring(slash);
        }
        if (name == null) {
            name = uri;
        }
        return new File(uri);
    }

    @Override
    public void setSaveFile(File saveDirectory, String fileName, boolean overwrite) throws DownloadException {
    }

    @Override
    public Downloader.DownloadState getState() {
        return this.downloadStatus;
    }

    @Override
    public boolean isCompleted() {
        return this.downloadStatus == Downloader.DownloadState.COMPLETE;
    }

    @Override
    public boolean isLaunchable() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public boolean isRelocatable() {
        return false;
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean resume() {
        return false;
    }

    @Override
    public void stop() {
        this.finish();
        this.downloadManager.remove(this, true);
    }

    @Override
    public float getAverageBandwidth() {
        return 0.0f;
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return 0.0f;
    }

    @Override
    public void measureBandwidth() {
    }

    @Override
    public void finish() {
        this.downloadStatus = Downloader.DownloadState.ABORTED;
        if (this.aborter != null) {
            this.aborter.shutdown();
            this.aborter = null;
        }
    }

    @Override
    public GUID getQueryGUID() {
        return null;
    }

    @Override
    public void handleInactivity() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public boolean isQueuable() {
        return false;
    }

    @Override
    public void setInactivePriority(int priority) {
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.isCompleted() || this.downloadStatus == Downloader.DownloadState.ABORTED || this.downloadStatus == Downloader.DownloadState.INVALID || this.downloadStatus == Downloader.DownloadState.UNABLE_TO_CONNECT;
    }

    @Override
    public boolean shouldBeRestarted() {
        return this.downloadStatus == Downloader.DownloadState.QUEUED;
    }

    @Override
    public void startDownload() {
        this.fetch();
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.TORRENTFETCHER;
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.eventListenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.eventListenerList.removeListener(listener);
    }

    @Override
    public boolean allowRequest(HttpUriRequest request) {
        return true;
    }

    @Override
    public boolean isMementoSupported() {
        return false;
    }

    @Override
    public void initDownloadInformation(URI torrentURI, boolean overwrite) {
        this.torrentURI = torrentURI;
    }

    @Override
    protected DownloadMemento createMemento() {
        return null;
    }

    @Override
    protected File getDefaultSaveFile() {
        return this.getSaveFile();
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... files) {
        return false;
    }

    @Override
    public boolean conflictsWithIncompleteFile(File incomplete) {
        return false;
    }

    @Override
    public void handleEvent(DownloadStateEvent event) {
        if (Downloader.DownloadState.COMPLETE == event.getType()) {
            this.downloadManager.remove(this, true);
        }
    }

    @Override
    public void deleteIncompleteFiles() {
        FileUtils.forceDelete(this.incompleteTorrentFile);
    }

    @Override
    public File getTorrentFile() {
        return this.torrentFile;
    }

    @Override
    public DownloadPiecesInfo getPieceInfo() {
        return null;
    }
}

