/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg.input;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;

public class TextInputHandler
extends InputHandler
implements CommandListener {
    private static final String OK = "OK";
    private final Display myDisplay;
    private SVGTextField myCurrentTextField = null;
    private Displayable myPreviousDisp = null;

    public TextInputHandler(Display display) {
        this.myDisplay = display;
    }

    public boolean handleKeyPress(SVGComponent comp, int keyCode) {
        if (keyCode == -5) {
            this.showTextBox(comp);
        }
        return false;
    }

    public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
        return false;
    }

    public void commandAction(Command cmd, Displayable disp) {
        TextBox lcduiText = (TextBox)disp;
        final String text = lcduiText.getString();
        final int pos = lcduiText.getCaretPosition();
        this.getDisplay().setCurrent(this.myPreviousDisp);
        this.myPreviousDisp = null;
        this.getDisplay().callSerially(new Runnable(){

            public void run() {
                TextInputHandler.this.myCurrentTextField.setText(text);
                TextInputHandler.this.myCurrentTextField.setCaretPosition(pos);
                TextInputHandler.this.myCurrentTextField = null;
            }
        });
    }

    protected Display getDisplay() {
        return this.myDisplay;
    }

    protected void showTextBox(SVGComponent comp) {
        SVGTextField svgField;
        if (!(comp instanceof SVGTextField)) {
            return;
        }
        this.myCurrentTextField = svgField = (SVGTextField)comp;
        TextBox lcduiText = new TextBox(svgField.getTitle(), svgField.getText(), 100, 0);
        lcduiText.addCommand(new Command(OK, 4, 0));
        lcduiText.setCommandListener((CommandListener)this);
        this.myPreviousDisp = this.getDisplay().getCurrent();
        this.getDisplay().setCurrent((Displayable)lcduiText);
    }

    public void handlePointerRelease(PointerEvent event) {
        if (event.getClickCount() > 1) {
            this.showTextBox(event.getComponent());
        }
        super.handlePointerRelease(event);
    }
}

