/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.Util;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UndoManager
extends FileChangeAdapter
implements DocumentListener,
PropertyChangeListener {
    private LinkedList<LinkedList<UndoItem>> undoList;
    private LinkedList<LinkedList<UndoItem>> redoList;
    private final Set<CloneableEditorSupport> allCES = new HashSet<CloneableEditorSupport>();
    private final Map<FileObject, CloneableEditorSupport> fileObjectToCES = new HashMap<FileObject, CloneableEditorSupport>();
    private final Map<Document, CloneableEditorSupport> documentToCES = new HashMap<Document, CloneableEditorSupport>();
    private final Map<InvalidationListener, Collection<? extends CloneableEditorSupport>> listenerToCES = new HashMap<InvalidationListener, Collection<? extends CloneableEditorSupport>>();
    private boolean listenersRegistered = false;
    public static final String PROP_STATE = "state";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private boolean dontDeleteUndo = false;
    private IdentityHashMap<LinkedList, String> descriptionMap;
    private String description;
    private ProgressListener progress;
    private static UndoManager instance;
    private Set<Project> projects;
    private static Field undoRedo;
    private int stepCounter = 0;

    public static UndoManager getDefault() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    private UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
        this.projects = new HashSet<Project>();
    }

    private UndoManager(ProgressListener progressListener) {
        this();
        this.progress = progressListener;
    }

    public void setUndoDescription(String string) {
        this.description = string;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.transactionStart = true;
        this.unregisterListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(boolean bl) {
        try {
            this.description = null;
            this.dontDeleteUndo = true;
            if (bl && !this.undoList.isEmpty()) {
                this.undoList.removeFirst();
            } else if (this.isUndoAvailable() && this.getUndoDescription() == null) {
                this.descriptionMap.remove(this.undoList.removeFirst());
                this.dontDeleteUndo = false;
            }
            this.invalidate(null);
            this.dontDeleteUndo = false;
        }
        catch (Throwable throwable) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.registerListeners();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            UndoManager.this.registerListeners();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
            }
            this.fireStateChange();
            throw throwable;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.registerListeners();
        } else {
            try {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.isUndoAvailable()) {
            boolean bl = true;
            try {
                this.transactionStarted();
                this.wasUndo = true;
                LinkedList<UndoItem> linkedList = this.undoList.getFirst();
                this.fireProgressListenerStart(0, linkedList.size());
                this.undoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.redoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.redoList.getFirst(), this.descriptionMap.remove(linkedList));
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.undo();
                    if (!(undoItem instanceof SessionUndoItem)) continue;
                    this.addItem(undoItem);
                }
                bl = false;
            }
            finally {
                try {
                    this.wasUndo = false;
                    this.transactionEnded(bl);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.isRedoAvailable()) {
            boolean bl = true;
            try {
                this.transactionStarted();
                this.wasRedo = true;
                LinkedList<UndoItem> linkedList = this.redoList.getFirst();
                this.fireProgressListenerStart(1, linkedList.size());
                this.redoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.description = this.descriptionMap.remove(linkedList);
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.redo();
                    if (!(undoItem instanceof SessionUndoItem)) continue;
                    this.addItem(undoItem);
                }
                bl = false;
            }
            finally {
                try {
                    this.wasRedo = false;
                    this.transactionEnded(bl);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        BackupFacility.getDefault().clear();
        this.fireStateChange();
    }

    public void addItem(RefactoringSession refactoringSession) {
        this.addItem(new SessionUndoItem(refactoringSession));
    }

    private void addItem(UndoItem undoItem) {
        if (this.wasUndo) {
            LinkedList<UndoItem> linkedList = this.redoList.getFirst();
            linkedList.addFirst(undoItem);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList<UndoItem> linkedList = this.undoList.getFirst();
            linkedList.addFirst(undoItem);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireStateChange() {
        this.pcs.firePropertyChange(PROP_STATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Collection<? extends CloneableEditorSupport> collection, InvalidationListener invalidationListener) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.registerListeners();
        }
        for (final CloneableEditorSupport cloneableEditorSupport : collection) {
            final StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            if (styledDocument != null) {
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Set set = UndoManager.this.allCES;
                        synchronized (set) {
                            if (UndoManager.this.allCES.add(cloneableEditorSupport)) {
                                cloneableEditorSupport.addPropertyChangeListener((PropertyChangeListener)UndoManager.this);
                                styledDocument.addDocumentListener(UndoManager.this);
                                UndoManager.this.documentToCES.put(styledDocument, cloneableEditorSupport);
                                Object object = styledDocument.getProperty("stream");
                                if (object instanceof DataObject) {
                                    FileObject fileObject = ((DataObject)object).getPrimaryFile();
                                    UndoManager.this.fileObjectToCES.put(fileObject, cloneableEditorSupport);
                                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                                    if (project != null) {
                                        UndoManager.this.projects.add(project);
                                    }
                                }
                            }
                        }
                    }
                });
                continue;
            }
            Set<CloneableEditorSupport> set2 = this.allCES;
            synchronized (set2) {
                if (this.allCES.add(cloneableEditorSupport)) {
                    cloneableEditorSupport.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
        set = this.allCES;
        synchronized (set) {
            if (invalidationListener != null) {
                this.listenerToCES.put(invalidationListener, collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(InvalidationListener invalidationListener) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.listenerToCES.remove(invalidationListener);
            this.clearIfPossible();
        }
    }

    private void discardAllEdits(InvalidationListener invalidationListener) {
        for (CloneableEditorSupport cloneableEditorSupport : this.listenerToCES == null || invalidationListener == null ? this.allCES : this.listenerToCES.get(invalidationListener)) {
            try {
                UndoRedo.Manager manager = (UndoRedo.Manager)undoRedo.get(cloneableEditorSupport);
                if (manager == null) continue;
                manager.discardAllEdits();
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
        }
    }

    private void registerListeners() {
        if (this.listenersRegistered) {
            return;
        }
        Util.addFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport object : this.allCES) {
            object.addPropertyChangeListener((PropertyChangeListener)this);
        }
        for (Document document : this.documentToCES.keySet()) {
            document.addDocumentListener(this);
        }
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.listenersRegistered = true;
    }

    private void unregisterListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        Util.removeFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport object : this.allCES) {
            object.removePropertyChangeListener((PropertyChangeListener)this);
        }
        for (Document document : this.documentToCES.keySet()) {
            document.removeDocumentListener(this);
        }
        this.listenersRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(CloneableEditorSupport cloneableEditorSupport) {
        LinkedList<LinkedList<UndoItem>> linkedList = this.undoList;
        synchronized (linkedList) {
            if (!(this.wasRedo || this.wasUndo || this.dontDeleteUndo)) {
                this.clear();
            }
            Set<CloneableEditorSupport> set = this.allCES;
            synchronized (set) {
                if (cloneableEditorSupport == null) {
                    for (InvalidationListener invalidationListener : this.listenerToCES.keySet()) {
                        invalidationListener.invalidateObject();
                        this.discardAllEdits(invalidationListener);
                    }
                    this.listenerToCES.clear();
                } else {
                    Iterator<Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>>> iterator = this.listenerToCES.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>> entry = iterator.next();
                        if (!entry.getValue().contains(cloneableEditorSupport)) continue;
                        entry.getKey().invalidateObject();
                        iterator.remove();
                    }
                }
                this.clearIfPossible();
            }
        }
    }

    private void clearIfPossible() {
        if (this.listenerToCES.isEmpty() && this.undoList.isEmpty() && this.redoList.isEmpty()) {
            this.unregisterListeners();
            this.allCES.clear();
            this.documentToCES.clear();
            this.fileObjectToCES.clear();
            this.projects.clear();
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        CloneableEditorSupport cloneableEditorSupport = this.fileObjectToCES.get(fileEvent.getFile());
        if (cloneableEditorSupport != null) {
            this.invalidate(cloneableEditorSupport);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.fileChanged(fileEvent);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.fileChanged((FileEvent)fileRenameEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate(this.documentToCES.get(documentEvent.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate(this.documentToCES.get(documentEvent.getDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentStateChanged(CloneableEditorSupport cloneableEditorSupport) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            Iterator<Map.Entry<Document, CloneableEditorSupport>> iterator = this.documentToCES.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Document, CloneableEditorSupport> entry = iterator.next();
                if (entry.getValue() != cloneableEditorSupport) continue;
                entry.getKey().removeDocumentListener(this);
                iterator.remove();
                break;
            }
            if (styledDocument != null) {
                this.documentToCES.put(styledDocument, cloneableEditorSupport);
                styledDocument.addDocumentListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.unregisterListeners();
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            set = this.allCES;
            synchronized (set) {
                this.registerListeners();
            }
        }
    }

    private void fireProgressListenerStart(int n, int n2) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, n, n2));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
            HashSet<Project> hashSet = new HashSet<Project>(this.projects);
            hashSet.removeAll(Arrays.asList((Project[])propertyChangeEvent.getNewValue()));
            if (!hashSet.isEmpty()) {
                this.invalidate(null);
            }
        } else if ("document".equals(propertyChangeEvent.getPropertyName())) {
            this.documentStateChanged((CloneableEditorSupport)propertyChangeEvent.getSource());
        }
    }

    static {
        try {
            undoRedo = CloneableEditorSupport.class.getDeclaredField("undoRedo");
            undoRedo.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Exceptions.printStackTrace((Throwable)noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
    }

    private final class SessionUndoItem
    implements UndoItem {
        private RefactoringSession change;

        public SessionUndoItem(RefactoringSession refactoringSession) {
            this.change = refactoringSession;
        }

        public void undo() {
            this.change.undoRefactoring(false);
        }

        public void redo() {
            this.change.doRefactoring(false);
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

