/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;

public final class LexerInput {
    public static final int EOF = -1;
    private LexerInputOperation<?> operation;
    private ReadText readText;
    private int eof;
    static final Logger LOG = Logger.getLogger(LexerInput.class.getName());
    private static boolean loggable;

    LexerInput(LexerInputOperation lexerInputOperation) {
        this.operation = lexerInputOperation;
        loggable = LOG.isLoggable(Level.FINE);
    }

    public int read() {
        int n = this.operation.read();
        if (n == -1) {
            this.eof = 1;
        }
        if (loggable) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("+LexerInput.read(");
            if (n == -1) {
                stringBuilder.append("EOF");
            } else {
                stringBuilder.append('\'');
                CharSequenceUtilities.debugChar((StringBuilder)stringBuilder, (char)((char)n));
                stringBuilder.append('\'');
            }
            stringBuilder.append(")\n");
            LOG.fine(stringBuilder.toString());
        }
        return n;
    }

    public void backup(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("count=" + n + " <0");
        }
        LexerUtilsConstants.checkValidBackup(n, this.readLengthEOF());
        if (this.eof != 0) {
            this.eof = 0;
            --n;
            if (loggable) {
                LOG.fine("-LexerInput.backup(EOF)\n");
            }
        }
        if (loggable && n > 0) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("-LexerInput.backup(").append(n);
            stringBuilder.append(")\n");
            LOG.fine(stringBuilder.toString());
        }
        this.operation.backup(n);
    }

    public int readLength() {
        return this.operation.readLength();
    }

    public int readLengthEOF() {
        return this.readLength() + this.eof;
    }

    public CharSequence readText(int n, int n2) {
        assert (n >= 0 && n2 >= n && n2 <= this.readLength()) : "start=" + n + ", end=" + n2 + ", readLength()=" + this.readLength();
        if (this.readText == null) {
            this.readText = new ReadText();
        }
        this.readText.reinit(n, n2);
        return this.readText;
    }

    public CharSequence readText() {
        return this.readText(0, this.readLength());
    }

    public boolean consumeNewline() {
        if (this.read() == 10) {
            return true;
        }
        this.backup(1);
        return false;
    }

    private final class ReadText
    extends AbstractCharSequence.StringLike {
        private int start;
        private int length;

        private ReadText() {
        }

        private void reinit(int n, int n2) {
            this.start = n;
            this.length = n2 - n;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int n) {
            if (n < 0 || n >= this.length) {
                throw new IndexOutOfBoundsException("index=" + n + ", length=" + this.length);
            }
            return LexerInput.this.operation.readExistingAtIndex(n);
        }
    }
}

