/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItem;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;

public final class VMTelemetryModels {
    private final VMTelemetryDataManager dataManager;
    private final Timeline timeline;
    private final SynchronousXYItemsModel memoryItemsModel;
    private final SynchronousXYItemsModel generationsItemsModel;
    private final SynchronousXYItemsModel threadsItemsModel;

    public VMTelemetryModels(VMTelemetryDataManager vMTelemetryDataManager) {
        this.dataManager = vMTelemetryDataManager;
        this.timeline = this.createTimeline();
        this.memoryItemsModel = this.createMemoryItemsModel(this.timeline);
        this.generationsItemsModel = this.createGenerationsItemsModel(this.timeline);
        this.threadsItemsModel = this.createThreadsItemsModel(this.timeline);
        vMTelemetryDataManager.addDataListener(new DataManagerListener(){

            public void dataChanged() {
                VMTelemetryModels.this.dataChangedImpl();
            }

            public void dataReset() {
                VMTelemetryModels.this.dataResetImpl();
            }
        });
    }

    public VMTelemetryDataManager getDataManager() {
        return this.dataManager;
    }

    public SynchronousXYItemsModel memoryItemsModel() {
        return this.memoryItemsModel;
    }

    public SynchronousXYItemsModel generationsItemsModel() {
        return this.generationsItemsModel;
    }

    public SynchronousXYItemsModel threadsItemsModel() {
        return this.threadsItemsModel;
    }

    private void dataChangedImpl() {
        this.memoryItemsModel.valuesAdded();
        this.generationsItemsModel.valuesAdded();
        this.threadsItemsModel.valuesAdded();
    }

    private void dataResetImpl() {
        this.memoryItemsModel.valuesReset();
        this.generationsItemsModel.valuesReset();
        this.threadsItemsModel.valuesReset();
    }

    private Timeline createTimeline() {
        return new Timeline(){

            public int getTimestampsCount() {
                return VMTelemetryModels.this.dataManager.getItemCount();
            }

            public long getTimestamp(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.timeStamps[n];
            }
        };
    }

    private SynchronousXYItemsModel createMemoryItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.HEAP_SIZE_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.totalMemory[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 0x4F0000L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.USED_HEAP_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.usedMemory[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 0x100000L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createGenerationsItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.SURVGEN_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nSurvivingGenerations[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 2L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.GC_TIME_NAME, 0L, 1000L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.relativeGCTimeInPerMil[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 1000L));
        ProfilerGCXYItem profilerGCXYItem = new ProfilerGCXYItem(""){

            public long[] getGCStarts(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcStarts[n];
            }

            public long[] getGCEnds(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcFinishs[n];
            }
        };
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{profilerGCXYItem, synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createThreadsItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.THREADS_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nTotalThreads[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 3L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.LOADED_CLASSES_NAME, 0L){

            public long getYValue(int n) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.loadedClassesCount[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 732L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }
}

