/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.image.BufferedImage;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;

public class SnapshotFlatProfilePanel
extends FlatProfilePanel
implements ScreenshotProvider {
    private CPUResultsSnapshot snapshot;

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler) {
        this(cPUResUserActionsHandler, null);
    }

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler) {
        super(cPUResUserActionsHandler, cPUSelectionHandler);
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, boolean bl, String string) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper, bl);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper, bl);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, bl, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, bl, string);
            }
        }
        this.percentFormat.setMinimumFractionDigits(0);
        this.percentFormat.setMaximumFractionDigits(1);
    }

    private void exportHTML(ExportDataDumper exportDataDumper, boolean bl, String string) {
        int n;
        StringBuffer stringBuffer = !bl ? new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><TABLE border=\"1\"><tr>") : new StringBuffer("<br><br><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append("<th>" + this.columnNames[n] + "</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">" + this.replaceHTMLCharacters(this.flatProfileContainer.getMethodNameAtRow(n)) + "</pre></td>");
            stringBuffer.append("<td class=\"right\">" + this.percentFormat.format((double)this.flatProfileContainer.getPercentAtRow(n) / 100.0) + "</td>");
            stringBuffer.append("<td class=\"right\">" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0 + " ms</td>");
            stringBuffer.append("<td class=\"right\">" + this.flatProfileContainer.getNInvocationsAtRow(n) + "</td></tr>");
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, boolean bl, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = !bl ? new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"table\">" + string2 + " <TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + string2 + "  <TableHeader>") : new StringBuffer(string2 + "<TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + string2 + "  <TableHeader>");
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append("   <TableColumn><![CDATA[" + this.columnNames[n] + "]]></TableColumn>" + string2);
        }
        stringBuffer.append("  </TableHeader>" + string2 + "  <TableBody>" + string2);
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer("   <TableRow>" + string2 + "    <TableColumn><![CDATA[" + this.flatProfileContainer.getMethodNameAtRow(n) + "]]></TableColumn>" + string2);
            stringBuffer.append("    <TableColumn><![CDATA[" + this.percentFormat.format((double)this.flatProfileContainer.getPercentAtRow(n) / 100.0) + "]]></TableColumn>" + string2);
            stringBuffer.append("    <TableColumn><![CDATA[" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0 + " ms]]></TableColumn>" + string2);
            stringBuffer.append("    <TableColumn><![CDATA[" + this.flatProfileContainer.getNInvocationsAtRow(n) + "]]></TableColumn>" + string2 + "  </TableRow>" + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer("  </TableBody> </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        if (bl) {
            stringBuffer.append(string3 + string3 + string + string3 + string3 + string + string3 + string3 + string + string3 + string3 + string2);
        }
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append(string3 + this.columnNames[n] + string3 + string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3 + this.flatProfileContainer.getMethodNameAtRow(n) + string3 + string);
            stringBuffer.append(string3 + this.flatProfileContainer.getPercentAtRow(n) + string3 + string);
            stringBuffer.append(string3 + (double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0 + " ms" + string3 + string);
            stringBuffer.append(string3 + this.flatProfileContainer.getNInvocationsAtRow(n) + string3 + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.resTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2) {
        this.snapshot = cPUResultsSnapshot;
        this.currentView = n2;
        this.threadId = n;
        this.flatProfileContainer = null;
        this.collectingTwoTimeStamps = cPUResultsSnapshot.isCollectingTwoTimeStamps();
    }

    public String getDefaultViewName() {
        return "cpu-hotspots";
    }

    public CPUResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    protected String[] getMethodClassNameAndSig(int n, int n2) {
        return this.snapshot.getMethodClassNameAndSig(n, n2);
    }

    protected void obtainResults() {
        if (this.snapshot != null) {
            this.flatProfileContainer = this.snapshot.getFlatProfile(this.threadId, this.currentView);
        }
        if (this.snapshot == null || !this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.setResultsAvailable(true);
    }

    protected void showReverseCallGraph(int n, int n2, int n3, int n4, boolean bl) {
        this.actionsHandler.showReverseCallGraph(this.snapshot, n, n2, n3, n4, bl);
    }

    protected boolean supportsReverseCallGraph() {
        return true;
    }

    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    protected void updateResults() {
        int n;
        if (this.threadId < -1) {
            return;
        }
        int n2 = n = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != n) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }
}

