/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.options.BugzillaOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class BugzillaOptionsController
extends OptionsPanelController
implements DocumentListener {
    private final BugzillaOptionsPanel panel;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean valid = false;

    public BugzillaOptionsController() {
        this.panel = new BugzillaOptionsPanel();
    }

    public void update() {
        this.panel.issuesTextField.getDocument().removeDocumentListener(this);
        this.panel.queriesTextField.getDocument().removeDocumentListener(this);
        this.panel.issuesTextField.setText(BugzillaConfig.getInstance().getIssueRefreshInterval() + "");
        this.panel.queriesTextField.setText(BugzillaConfig.getInstance().getQueryRefreshInterval() + "");
        this.panel.issuesTextField.getDocument().addDocumentListener(this);
        this.panel.queriesTextField.getDocument().addDocumentListener(this);
    }

    public void applyChanges() {
        String string = this.panel.queriesTextField.getText().trim();
        int n = string.equals("") ? 0 : Integer.parseInt(string);
        BugzillaConfig.getInstance().setQueryRefreshInterval(n);
        String string2 = this.panel.issuesTextField.getText().trim();
        n = string2.equals("") ? 0 : Integer.parseInt(string2);
        BugzillaConfig.getInstance().setIssueRefreshInterval(n);
    }

    public void cancel() {
        this.update();
    }

    public boolean isValid() {
        this.validate(false);
        return this.valid;
    }

    private boolean isValidRefreshValue(String string) {
        if (!string.equals("")) {
            try {
                int n = Integer.parseInt(string);
                if (n < 5) {
                    this.panel.errorLabel.setText(NbBundle.getMessage(BugzillaOptionsController.class, (String)"MSG_MUST_BE_GREATER_THEN_5"));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.panel.errorLabel.setText(NbBundle.getMessage(BugzillaOptionsController.class, (String)"MSG_INVALID_VALUE"));
                return false;
            }
        }
        return true;
    }

    public boolean isChanged() {
        return !this.panel.issuesTextField.getText().trim().equals(BugzillaConfig.getInstance().getIssueRefreshInterval() + "") || !this.panel.queriesTextField.getText().trim().equals(BugzillaConfig.getInstance().getQueryRefreshInterval() + "");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public JComponent getComponent(Lookup lookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validate(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validate(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validate(true);
    }

    private void validate(boolean bl) {
        boolean bl2 = this.valid;
        this.panel.errorLabel.setVisible(false);
        this.panel.errorLabel.setText("");
        String string = this.panel.queriesTextField.getText().trim();
        String string2 = this.panel.issuesTextField.getText().trim();
        this.valid = this.isValidRefreshValue(string) && this.isValidRefreshValue(string2);
        this.panel.errorLabel.setVisible(!this.valid);
        if (bl && bl2 != this.valid) {
            this.support.firePropertyChange(new PropertyChangeEvent(this, "valid", bl2, this.valid));
        }
    }
}

