/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class PerformQueryCommand
extends BugzillaCommand {
    private final BugzillaRepository repository;
    private final String queryUrl;
    private final TaskDataCollector collector;
    private IStatus status;

    public PerformQueryCommand(BugzillaRepository bugzillaRepository, String string, TaskDataCollector taskDataCollector) {
        this.repository = bugzillaRepository;
        this.queryUrl = string;
        this.collector = taskDataCollector;
    }

    public void execute() throws CoreException {
        TaskRepository taskRepository = this.repository.getTaskRepository();
        RepositoryQuery repositoryQuery = new RepositoryQuery(taskRepository.getConnectorKind(), "");
        repositoryQuery.setUrl(this.queryUrl);
        BugzillaRepositoryConnector bugzillaRepositoryConnector = Bugzilla.getInstance().getRepositoryConnector();
        Bugzilla.LOG.log(Level.FINE, "executing query on repository {0} with parameters \n\t{1}", new Object[]{this.repository.getUrl(), this.queryUrl});
        this.status = bugzillaRepositoryConnector.performQuery(taskRepository, (IRepositoryQuery)repositoryQuery, this.collector, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PerformQueryCommand [");
        stringBuffer.append(this.queryUrl);
        stringBuffer.append("]");
        return super.toString();
    }
}

