/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    static Node getRootNode(final FileObject fileObject) throws IOException {
        final Node[] nodeArray = new Node[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Node node = null;
                if (fileObject != null) {
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject.lock();
                        node = XMLUtil.getXMLDocument(fileObject.getInputStream());
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
                nodeArray[0] = node != null ? node.getFirstChild() : null;
            }
        });
        return nodeArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getXMLDocument(InputStream inputStream) throws IOException {
        Document document = null;
        try {
            document = org.openide.xml.XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) {
                    Debug.warning((Object[])new Object[]{sAXParseException});
                }
            }, null);
        }
        catch (SAXException sAXException) {
            try {
                throw Debug.error((Object[])new Object[]{sAXException});
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw Debug.error((Object[])new Object[]{iOException});
                }
            }
        }
        try {
            inputStream.close();
            return document;
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
    }

    static Node[] getChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node[] nodeArray = new Node[nodeList != null ? nodeList.getLength() : 0];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }

    static List<Node> getChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    static Node getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return node2;
        }
        return null;
    }

    static String getAttributeValue(Node node, String string) {
        try {
            NamedNodeMap namedNodeMap;
            if (node != null && (namedNodeMap = node.getAttributes()) != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            Debug.warning((Object[])new Object[]{dOMException});
        }
        return null;
    }
}

