/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.cookies.SectionFocusCookie;
import org.netbeans.modules.xml.multiview.ui.ContainerPanel;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.Node;

public class SectionView
extends PanelView
implements SectionFocusCookie,
ContainerPanel {
    private JPanel scrollPanel;
    private JPanel filler;
    JScrollPane scrollPane;
    private Hashtable map;
    private int sectionCount = 0;
    private NodeSectionPanel activePanel;
    private InnerPanelFactory factory = null;
    boolean sectionSelected;

    public SectionView(InnerPanelFactory innerPanelFactory) {
        this.factory = innerPanelFactory;
    }

    public SectionView() {
    }

    public void initComponents() {
        super.initComponents();
        this.map = new Hashtable();
        this.setLayout(new BorderLayout());
        this.scrollPanel = new JPanel();
        this.scrollPanel.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.scrollPanel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.filler = new JPanel();
        this.filler.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.add((Component)this.scrollPane, "Center");
    }

    public boolean focusSection(NodeSectionPanel nodeSectionPanel) {
        nodeSectionPanel.open();
        this.openParents((JPanel)((Object)nodeSectionPanel));
        nodeSectionPanel.scroll();
        this.setActivePanel(nodeSectionPanel);
        nodeSectionPanel.setActive(true);
        return true;
    }

    protected void openSection(Node node) {
        NodeSectionPanel nodeSectionPanel = (NodeSectionPanel)this.map.get(node);
        if (nodeSectionPanel != null) {
            this.focusSection(nodeSectionPanel);
        }
    }

    private void openParents(JPanel jPanel) {
        JScrollPane jScrollPane = null;
        NodeSectionPanel nodeSectionPanel = null;
        for (Container container = jPanel.getParent(); container != null && jScrollPane == null; container = container.getParent()) {
            if (container instanceof JScrollPane) {
                jScrollPane = (JScrollPane)container;
            }
            if (!(container instanceof NodeSectionPanel)) continue;
            nodeSectionPanel = (NodeSectionPanel)((Object)container);
            nodeSectionPanel.open();
        }
    }

    void mapSection(Node node, NodeSectionPanel nodeSectionPanel) {
        this.map.put(node, nodeSectionPanel);
    }

    void deleteSection(Node node) {
        this.map.remove(node);
    }

    public NodeSectionPanel getSection(Node node) {
        return (NodeSectionPanel)this.map.get(node);
    }

    public void addSection(NodeSectionPanel nodeSectionPanel, boolean bl) {
        this.addSection(nodeSectionPanel);
        if (bl) {
            nodeSectionPanel.open();
            nodeSectionPanel.scroll();
            nodeSectionPanel.setActive(true);
        }
    }

    public void addSection(NodeSectionPanel nodeSectionPanel) {
        this.scrollPanel.remove(this.filler);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.sectionCount;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.scrollPanel.add((Component)((JPanel)((Object)nodeSectionPanel)), gridBagConstraints);
        nodeSectionPanel.setIndex(this.sectionCount);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.sectionCount + 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.scrollPanel.add((Component)this.filler, gridBagConstraints);
        this.mapSection(nodeSectionPanel.getNode(), nodeSectionPanel);
        ++this.sectionCount;
    }

    public void removeSection(Node node) {
        NodeSectionPanel nodeSectionPanel = this.getSection(node);
        if (nodeSectionPanel != null) {
            Container container;
            for (container = ((Component)((Object)nodeSectionPanel)).getParent(); container != null && !(container instanceof ContainerPanel); container = container.getParent()) {
            }
            if (container != null) {
                Object object;
                ContainerPanel containerPanel = (ContainerPanel)((Object)container);
                if (nodeSectionPanel instanceof SectionPanel && (object = ((SectionPanel)nodeSectionPanel).getKey()) != null && object == this.getLastActive()) {
                    this.setLastActive(null);
                }
                containerPanel.removeSection(nodeSectionPanel);
                containerPanel.getRoot().getChildren().remove(new Node[]{node});
            }
        }
    }

    public void removeSection(NodeSectionPanel nodeSectionPanel) {
        NodeSectionPanel nodeSectionPanel2;
        int n;
        int n2 = nodeSectionPanel.getIndex();
        this.scrollPanel.remove((JPanel)((Object)nodeSectionPanel));
        Component[] componentArray = this.scrollPanel.getComponents();
        ArrayList<NodeSectionPanel> arrayList = new ArrayList<NodeSectionPanel>();
        for (n = 0; n < componentArray.length; ++n) {
            int n3;
            if (!(componentArray[n] instanceof NodeSectionPanel) || (n3 = (nodeSectionPanel2 = (NodeSectionPanel)((Object)componentArray[n])).getIndex()) <= n2) continue;
            this.scrollPanel.remove((JPanel)((Object)nodeSectionPanel2));
            nodeSectionPanel2.setIndex(n3 - 1);
            ((AbstractList)arrayList).add(nodeSectionPanel2);
        }
        for (n = 0; n < ((AbstractCollection)arrayList).size(); ++n) {
            nodeSectionPanel2 = (NodeSectionPanel)((AbstractList)arrayList).get(n);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = nodeSectionPanel2.getIndex();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.scrollPanel.add((Component)((JPanel)((Object)nodeSectionPanel2)), gridBagConstraints);
        }
        this.deleteSection(nodeSectionPanel.getNode());
        --this.sectionCount;
    }

    public void setActivePanel(NodeSectionPanel nodeSectionPanel) {
        if (this.activePanel != null && this.activePanel != nodeSectionPanel) {
            this.activePanel.setActive(false);
        }
        this.activePanel = nodeSectionPanel;
        if (nodeSectionPanel instanceof SectionPanel) {
            this.setLastActive(((SectionPanel)nodeSectionPanel).getKey());
        }
    }

    public NodeSectionPanel getActivePanel() {
        return this.activePanel;
    }

    public void selectNode(Node node) {
        this.setManagerSelection(new Node[]{node});
    }

    public void showSelection(Node[] nodeArray) {
        if (this.sectionSelected) {
            this.sectionSelected = false;
            return;
        }
        if (nodeArray != null && nodeArray.length > 0) {
            this.openSection(nodeArray[0]);
        }
    }

    void sectionSelected(boolean bl) {
        this.sectionSelected = bl;
    }

    protected Error validateView() {
        return null;
    }

    public SectionPanel findSectionPanel(Object object) {
        Enumeration enumeration = this.map.keys();
        while (enumeration.hasMoreElements()) {
            SectionPanel sectionPanel;
            NodeSectionPanel nodeSectionPanel = (NodeSectionPanel)this.map.get(enumeration.nextElement());
            if (!(nodeSectionPanel instanceof SectionPanel) || object != (sectionPanel = (SectionPanel)nodeSectionPanel).getKey()) continue;
            return sectionPanel;
        }
        return null;
    }

    InnerPanelFactory getInnerPanelFactory() {
        return this.factory;
    }

    public void setInnerPanelFactory(InnerPanelFactory innerPanelFactory) {
        this.factory = innerPanelFactory;
    }

    public void openPanel(Object object) {
        SectionPanel sectionPanel;
        if (object != null && (sectionPanel = this.findSectionPanel(object)) != null) {
            if (sectionPanel.getInnerPanel() == null) {
                sectionPanel.open();
            }
            this.openParents(sectionPanel);
            sectionPanel.scroll();
            sectionPanel.setActive(true);
        }
    }

    private Object getLastActive() {
        ToolBarDesignEditor toolBarDesignEditor = this.getToolBarDesignEditor();
        return toolBarDesignEditor == null ? null : toolBarDesignEditor.getLastActive();
    }

    private void setLastActive(Object object) {
        ToolBarDesignEditor toolBarDesignEditor = this.getToolBarDesignEditor();
        if (toolBarDesignEditor != null) {
            toolBarDesignEditor.setLastActive(object);
        }
    }

    protected ToolBarDesignEditor getToolBarDesignEditor() {
        Container container = this.getParent();
        return container == null ? null : (ToolBarDesignEditor)((Object)container.getParent());
    }
}

