/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.util.HashMap;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public abstract class SectionNodeView
extends SectionView {
    private final XmlMultiViewDataObject dataObject;
    private SectionNode rootNode = null;
    private HashMap nodes = new HashMap();
    private final RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            SectionNodeView.this.getRootNode().refreshSubtree();
        }
    });
    private static final int REFRESH_DELAY = 20;

    public SectionNodeView(XmlMultiViewDataObject xmlMultiViewDataObject) {
        this.dataObject = xmlMultiViewDataObject;
    }

    public void setRootNode(SectionNode sectionNode) {
        this.rootNode = sectionNode;
        Children.Array array = new Children.Array();
        array.add(new Node[]{sectionNode});
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setDisplayName(sectionNode.getDisplayName());
        abstractNode.setIconBaseWithExtension(sectionNode.getIconBase() + ".gif");
        this.setRoot((Node)abstractNode);
        this.addSection(sectionNode.getSectionNodePanel());
    }

    public XmlMultiViewDataObject getDataObject() {
        return this.dataObject;
    }

    public void openSection(Node node) {
        this.openPanel(node);
    }

    public void openPanel(Object object) {
        SectionNode sectionNode = this.retrieveSectionNode((SectionNode)((Object)object));
        SectionNodePanel sectionNodePanel = sectionNode.getSectionNodePanel();
        sectionNodePanel.open();
        this.setActivePanel(sectionNodePanel);
        sectionNodePanel.setActive(true);
        this.selectNode(sectionNodePanel.getNode());
        Utils.scrollToVisible(sectionNodePanel);
    }

    public SectionNode getRootNode() {
        return this.rootNode;
    }

    public void registerNode(SectionNode sectionNode) {
        this.nodes.put(sectionNode, sectionNode);
    }

    public SectionNode retrieveSectionNode(SectionNode sectionNode) {
        SectionNode sectionNode2 = (SectionNode)((Object)this.nodes.get((Object)sectionNode));
        return sectionNode2 == null ? this.rootNode : sectionNode2;
    }

    public void refreshView() {
        this.rootNode.refreshSubtree();
    }

    public void scheduleRefreshView() {
        this.refreshTask.schedule(20);
    }

    public void dataModelPropertyChange(Object object, String string, Object object2, Object object3) {
        this.rootNode.dataModelPropertyChange(object, string, object2, object3);
    }

    public abstract XmlMultiViewDataSynchronizer getModelSynchronizer();
}

