/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.editor.util.PriorityListenerList;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PriorityDocumentListenerList
extends PriorityListenerList<DocumentListener>
implements DocumentListener {
    private static final Logger LOG = Logger.getLogger(PriorityDocumentListenerList.class.getName());

    PriorityDocumentListenerList() {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        PriorityDocumentListenerList.logEvent(documentEvent, "insertUpdate");
        EventListener[][] eventListenerArray = this.getListenersArray();
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            PriorityDocumentListenerList.logPriority(i);
            EventListener[] eventListenerArray2 = eventListenerArray[i];
            for (int j = eventListenerArray2.length - 1; j >= 0; --j) {
                DocumentListener documentListener = (DocumentListener)eventListenerArray2[j];
                PriorityDocumentListenerList.logListener(documentListener);
                documentListener.insertUpdate(documentEvent);
            }
        }
        PriorityDocumentListenerList.logEventEnd("insertUpdate");
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        PriorityDocumentListenerList.logEvent(documentEvent, "removeUpdate");
        EventListener[][] eventListenerArray = this.getListenersArray();
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            PriorityDocumentListenerList.logPriority(i);
            EventListener[] eventListenerArray2 = eventListenerArray[i];
            for (int j = eventListenerArray2.length - 1; j >= 0; --j) {
                DocumentListener documentListener = (DocumentListener)eventListenerArray2[j];
                PriorityDocumentListenerList.logListener(documentListener);
                documentListener.removeUpdate(documentEvent);
            }
        }
        PriorityDocumentListenerList.logEventEnd("removeUpdate");
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        PriorityDocumentListenerList.logEvent(documentEvent, "changedUpdate");
        EventListener[][] eventListenerArray = this.getListenersArray();
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            PriorityDocumentListenerList.logPriority(i);
            EventListener[] eventListenerArray2 = eventListenerArray[i];
            for (int j = eventListenerArray2.length - 1; j >= 0; --j) {
                DocumentListener documentListener = (DocumentListener)eventListenerArray2[j];
                PriorityDocumentListenerList.logListener(documentListener);
                documentListener.changedUpdate(documentEvent);
            }
        }
        PriorityDocumentListenerList.logEventEnd("changedUpdate");
    }

    private static void logEvent(DocumentEvent documentEvent, String string) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("FIRING PriorityDocumentListenerList." + string + "() evt: type=" + documentEvent.getType() + ", off=" + documentEvent.getOffset() + ", len=" + documentEvent.getLength() + "-----------------\n" + "doc: " + documentEvent.getDocument());
        }
    }

    private static void logPriority(int n) {
        if (LOG.isLoggable(Level.FINE)) {
            String string = n < DocumentListenerPriority.PRIORITIES.length ? DocumentListenerPriority.PRIORITIES[n].getDescription() : String.valueOf(n);
            LOG.fine("  " + string + ":\n");
        }
    }

    private static void logEventEnd(String string) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("END-FIRING of " + string + "() ------------------------------------------------\n");
        }
    }

    private static void logListener(DocumentListener documentListener) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("    " + documentListener.getClass() + '\n');
        }
    }
}

