/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlAutoCompletion;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        return HtmlAutoCompletion.beforeCharInserted((BaseDocument)document, n, jTextComponent.getCaret(), c);
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        HtmlAutoCompletion.charInserted((BaseDocument)document, n, jTextComponent.getCaret(), c);
        return false;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        TokenSequence tokenSequence = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)document), (int)n, (Language)HTMLTokenId.language());
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        String string = null;
        int n2 = -1;
        if (tokenSequence.moveNext() && tokenSequence.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)tokenSequence.token().text()).toString().equals("</") && tokenSequence.moveNext() && tokenSequence.token().id() == HTMLTokenId.TAG_CLOSE) {
            string = ((Object)tokenSequence.token().text()).toString();
            n2 = tokenSequence.offset() + tokenSequence.token().text().length();
            tokenSequence.movePrevious();
            tokenSequence.movePrevious();
        }
        if (string == null) {
            return -1;
        }
        boolean bl = false;
        if (tokenSequence.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)tokenSequence.token().text()).toString().equals(">")) {
            while (tokenSequence.movePrevious()) {
                if (tokenSequence.token().id() != HTMLTokenId.TAG_OPEN) continue;
                if (!((Object)tokenSequence.token().text()).toString().equals(string)) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            Indent indent = Indent.get((Document)document);
            document.insertString(n, "\n", null);
            jTextComponent.getCaret().setDot(n);
            indent.reindent(n + 1, n2);
        }
        return -1;
    }

    public OffsetRange findMatching(Document document, int n) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult parserResult, int n) {
        AstNode astNode;
        int n2;
        Object object;
        Token token;
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>(2);
        Document document = parserResult.getSnapshot().getSource().getDocument(true);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<HTMLTokenId> tokenSequence = Utils.getJoinedHtmlSequence(document, n);
        if (tokenSequence == null) {
            return Collections.emptyList();
        }
        tokenSequence.move(n);
        if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && (token = tokenSequence.token()).id() == HTMLTokenId.TEXT && (object = token.text()).toString().trim().length() > 0) {
            int n3;
            int n4;
            int n5 = tokenSequence.offset();
            int n6 = n5 + token.text().length();
            List list = token.joinedParts();
            if (list != null) {
                Token token2 = (Token)list.get(list.size() - 1);
                n6 = token2.offset(tokenHierarchy) + token2.length();
            }
            n2 = n5;
            for (n4 = 0; n4 < object.length(); ++n4) {
                n3 = object.charAt(n4);
                if (Character.isWhitespace((char)n3)) continue;
                n2 += n4;
                break;
            }
            n4 = n6;
            for (n3 = object.length() - 1; n3 >= 0; --n3) {
                char c = object.charAt(n3);
                if (Character.isWhitespace(c)) continue;
                n4 = n6 - (object.length() - 1 - n3);
                break;
            }
            if (n2 != n5 || n4 != n6) {
                arrayList.add(new OffsetRange(n2, n4));
            }
            arrayList.add(new OffsetRange(n5, n6));
        }
        token = htmlParserResult.root();
        object = htmlParserResult.getSnapshot();
        if (token != null && (astNode = AstNodeUtils.findDescendant((AstNode)token, (int)object.getEmbeddedOffset(n))) != null) {
            do {
                OffsetRange offsetRange;
                int[] nArray = astNode.getLogicalRange();
                int n7 = object.getOriginalOffset(nArray[0]);
                n2 = object.getOriginalOffset(nArray[1]);
                if (n7 == -1 || n2 == -1 || n7 == n2) continue;
                OffsetRange offsetRange2 = offsetRange = arrayList.isEmpty() ? null : arrayList.get(arrayList.size() - 1);
                if (offsetRange != null && offsetRange.getStart() == n7 && offsetRange.getEnd() == n2) continue;
                arrayList.add(new OffsetRange(n7, n2));
            } while ((astNode = astNode.parent()) != null);
        }
        return arrayList;
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        return -1;
    }
}

