/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCompletionQuery
extends UserTask {
    private static final String SCRIPT_TAG_NAME = "script";
    private static final String STYLE_TAG_NAME = "style";
    private static boolean lowerCase;
    private static boolean isXHtml;
    private Document document;
    private int offset;
    private CompletionResult completionResult;

    public HtmlCompletionQuery(Document document, int n) {
        this.document = document;
        this.offset = n;
    }

    public CompletionResult query() throws ParseException {
        Source source = Source.create((Document)this.document);
        ParserManager.parse(Collections.singleton(source), (UserTask)this);
        return this.completionResult;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        Parser.Result result = resultIterator.getParserResult(this.offset);
        if (result == null) {
            return;
        }
        Snapshot snapshot = result.getSnapshot();
        int n = snapshot.getEmbeddedOffset(this.offset);
        String string = result.getSnapshot().getMimeType();
        if (string.equals("text/html")) {
            this.completionResult = this.query((HtmlParserResult)result);
        } else if (string.equals("text/javascript")) {
            this.completionResult = this.queryHtmlEndTagInEmbeddedCode(snapshot, n, SCRIPT_TAG_NAME);
        } else if (string.equals("text/x-css")) {
            this.completionResult = this.queryHtmlEndTagInEmbeddedCode(snapshot, n, STYLE_TAG_NAME);
        }
    }

    private CompletionResult queryHtmlEndTagInEmbeddedCode(Snapshot snapshot, int n, String string) {
        int n2;
        String string2 = "</" + string;
        int n3 = Math.max(n, n - string2.length());
        CharSequence charSequence = snapshot.getText().subSequence(n - n3, n);
        int n4 = CharSequenceUtilities.lastIndexOf((CharSequence)charSequence, (int)60);
        if (n4 == -1) {
            return null;
        }
        boolean bl = true;
        for (n2 = n4; n2 < charSequence.length(); ++n2) {
            if (charSequence.charAt(n2) == string2.charAt(n2 - n4)) continue;
            bl = false;
            break;
        }
        if (bl) {
            n2 = n - n3 + n4;
            int n5 = snapshot.getOriginalOffset(n2);
            List<HtmlCompletionItem> list = Collections.singletonList(HtmlCompletionItem.createEndTag(string, n5, null, -1, HtmlCompletionItem.EndTag.Type.DEFAULT));
            return new CompletionResult(list, this.offset);
        }
        return null;
    }

    private CompletionResult query(HtmlParserResult htmlParserResult) {
        return this.query(htmlParserResult, htmlParserResult.dtd());
    }

    CompletionResult query(HtmlParserResult htmlParserResult, DTD dTD) {
        List<CompletionItem> list;
        int n;
        block51: {
            boolean bl;
            AstNode astNode;
            AstNode astNode2;
            int n2;
            TokenId tokenId;
            String string;
            String string2;
            int n3;
            int n4;
            Token token;
            TokenSequence tokenSequence;
            TokenHierarchy tokenHierarchy;
            int n5;
            String string3;
            block52: {
                boolean bl2;
                block50: {
                    Snapshot snapshot = htmlParserResult.getSnapshot();
                    string3 = snapshot.getSource().getMimeType();
                    n5 = snapshot.getEmbeddedOffset(this.offset);
                    lowerCase = this.usesLowerCase(htmlParserResult, n5);
                    isXHtml = htmlParserResult.getHtmlVersion().isXhtml();
                    tokenHierarchy = snapshot.getTokenHierarchy();
                    tokenSequence = tokenHierarchy.tokenSequence(HTMLTokenId.language());
                    assert (tokenSequence != null);
                    int n6 = tokenSequence.move(n5);
                    boolean bl3 = false;
                    if (tokenSequence.moveNext()) {
                        if (n6 == 0 && (tokenSequence.token().id() == HTMLTokenId.TEXT || tokenSequence.token().id() == HTMLTokenId.WS || tokenSequence.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL || tokenSequence.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL)) {
                            bl3 = true;
                            if (!tokenSequence.movePrevious()) {
                                return null;
                            }
                        }
                    } else if (!tokenSequence.movePrevious()) {
                        return null;
                    }
                    n = -1;
                    token = tokenSequence.token();
                    n4 = token.offset(tokenHierarchy);
                    n3 = snapshot.getOriginalOffset(n4);
                    string = string2 = ((Object)token.text()).toString();
                    if (n6 < string2.length()) {
                        string2 = string2.substring(0, n5 - n4);
                    }
                    tokenId = token.id();
                    bl2 = tokenSequence.offset() < n5;
                    list = null;
                    n2 = 1;
                    int n7 = n5 == snapshot.getText().length() ? n5 - 1 : n5;
                    astNode2 = htmlParserResult.findLeaf(n7, bl3);
                    if (astNode2 == null) {
                        return null;
                    }
                    astNode = astNode2.getRootNode();
                    String string4 = (String)astNode.getProperty("namespace");
                    bl = string4 == null || string4.equals(htmlParserResult.getHtmlVersion().getDefaultNamespace());
                    int n8 = string2.lastIndexOf(38);
                    if (tokenId != HTMLTokenId.TEXT && tokenId != HTMLTokenId.VALUE || n8 <= -1) break block50;
                    String string5 = string2.substring(n8 + 1);
                    n = this.offset;
                    list = this.translateCharRefs(this.offset - n2, dTD.getCharRefList(string5));
                    break block51;
                }
                if (tokenId != HTMLTokenId.CHARACTER) break block52;
                if (!bl2 && string2.endsWith(";")) break block51;
                n = n3 + 1;
                list = this.translateCharRefs(n3, dTD.getCharRefList(string2.length() > 0 ? string2.substring(1) : ""));
                break block51;
            }
            if (tokenId == HTMLTokenId.TAG_OPEN) {
                Object object;
                n = n3;
                n5 -= string2.length() + 1;
                list = new ArrayList<CompletionItem>();
                if (bl) {
                    object = AstNodeUtils.getPossibleOpenTagElements((AstNode)astNode, (int)n5);
                    list.addAll(this.translateTags(n3 - 1, this.filterElements((Collection<DTD.Element>)object, string2), this.filterElements(dTD.getElementList(null), string2)));
                }
                object = new HtmlExtension.CompletionContext(htmlParserResult, n4, n5, n3 - 1, string2, string);
                for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(string3)) {
                    list.addAll(htmlExtension.completeOpenTags((HtmlExtension.CompletionContext)object));
                }
            } else if (tokenId != HTMLTokenId.BLOCK_COMMENT && string2.endsWith("<") || tokenId == HTMLTokenId.TAG_OPEN_SYMBOL && "<".equals(((Object)token.text()).toString())) {
                Object object;
                n = this.offset;
                list = new ArrayList<CompletionItem>();
                if (bl) {
                    object = AstNodeUtils.getPossibleOpenTagElements((AstNode)astNode, (int)n5);
                    list.addAll(this.translateTags(this.offset - 1, (Collection<DTD.Element>)object, dTD.getElementList(null)));
                }
                object = new HtmlExtension.CompletionContext(htmlParserResult, n4, n5, this.offset - 1, "", "");
                for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(string3)) {
                    List<CompletionItem> list2 = htmlExtension.completeOpenTags((HtmlExtension.CompletionContext)object);
                    list.addAll(list2);
                }
            } else if (tokenId == HTMLTokenId.TEXT && string2.endsWith("</") || tokenId == HTMLTokenId.TAG_OPEN_SYMBOL && string2.endsWith("</")) {
                n = this.offset;
                list = this.getPossibleEndTags(astNode2, this.offset, "");
            } else if (tokenId == HTMLTokenId.TAG_CLOSE) {
                n = n3;
                list = this.getPossibleEndTags(astNode2, this.offset, string2);
            } else if (tokenId == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                n = this.offset;
                list = this.getAutocompletedEndTag(astNode2, n5, this.offset);
            } else if (tokenId == HTMLTokenId.WS || tokenId == HTMLTokenId.ARGUMENT) {
                String string6 = tokenId == HTMLTokenId.ARGUMENT ? string2 : "";
                n2 = string6.length();
                n = this.offset - n2;
                if (!bl) {
                    ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
                    HtmlExtension.CompletionContext completionContext = new HtmlExtension.CompletionContext(htmlParserResult, n4, n5, n, string6, string, astNode2);
                    for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(string3)) {
                        arrayList.addAll(htmlExtension.completeAttributes(completionContext));
                    }
                    list = arrayList;
                } else {
                    String string7;
                    if (astNode2.type() == AstNode.NodeType.UNKNOWN_TAG || astNode2.type() == AstNode.NodeType.DECLARATION || astNode2.type() == AstNode.NodeType.ROOT) {
                        return null;
                    }
                    assert (astNode2.type() == AstNode.NodeType.OPEN_TAG) : "Unexpecet node type " + astNode2.type();
                    DTD.Element element = astNode2.getDTDElement();
                    List list3 = element.getAttributeList(string6);
                    Collection collection = astNode2.getAttributeKeys();
                    String string8 = string7 = token == null ? null : ((Object)token.text()).toString();
                    if (string7 == null) {
                        string7 = "";
                    }
                    ArrayList<DTD.Attribute> arrayList = new ArrayList<DTD.Attribute>();
                    for (DTD.Attribute attribute : list3) {
                        String string9 = attribute.getName();
                        if (!string9.equals(string6) && (collection.contains(isXHtml ? string9 : string9.toUpperCase(Locale.ENGLISH)) || collection.contains(isXHtml ? string9 : string9.toLowerCase(Locale.ENGLISH))) && (!string7.equals(string9) || string6.length() <= 0)) continue;
                        arrayList.add(attribute);
                    }
                    list = this.translateAttribs(n, arrayList, element);
                }
            } else if (tokenId == HTMLTokenId.VALUE || tokenId == HTMLTokenId.OPERATOR || tokenId == HTMLTokenId.WS) {
                DTD.Element element;
                if (tokenId == HTMLTokenId.WS) {
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.movePrevious();
                    element = tokenSequence.token();
                    if (element.id() != HTMLTokenId.OPERATOR) {
                        return null;
                    }
                }
                if (astNode2.type() == AstNode.NodeType.OPEN_TAG) {
                    element = astNode2.getDTDElement();
                    if (element == null) {
                        return null;
                    }
                    tokenSequence.move(token.offset(tokenHierarchy));
                    tokenSequence.moveNext();
                    Token token2 = tokenSequence.token();
                    while (token2.id() != HTMLTokenId.ARGUMENT && tokenSequence.movePrevious()) {
                        token2 = tokenSequence.token();
                    }
                    if (token2.id() != HTMLTokenId.ARGUMENT) {
                        return null;
                    }
                    String string10 = ((Object)token2.text()).toString();
                    if (!isXHtml) {
                        string10 = string10.toLowerCase(Locale.ENGLISH);
                    }
                    DTD.Attribute attribute = element.getAttribute(string10);
                    list = new ArrayList<CompletionItem>();
                    if (tokenId != HTMLTokenId.VALUE) {
                        Object object;
                        n = this.offset;
                        if (attribute != null) {
                            list.addAll(this.translateValues(n, attribute.getValueList("")));
                            object = AttrValuesCompletion.getSupport(astNode2.name(), string10);
                            if (object != null) {
                                list.addAll(((AttrValuesCompletion)object).getValueCompletionItems(this.document, this.offset, ""));
                            }
                        }
                        object = new HtmlExtension.CompletionContext(htmlParserResult, n4, n5, n, "", string, astNode2, string10, false);
                        for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(string3)) {
                            list.addAll(htmlExtension.completeAttributeValue((HtmlExtension.CompletionContext)object));
                        }
                    } else {
                        Object object;
                        String string11 = null;
                        if (string2 != null && string2.length() > 0) {
                            if (string2.substring(0, 1).equals("'")) {
                                string11 = "'";
                            }
                            if (string2.substring(0, 1).equals("\"")) {
                                string11 = "\"";
                            }
                        }
                        String string12 = string11 == null ? string2 : string2.substring(1);
                        n = n3 + (string11 != null ? 1 : 0);
                        if (attribute != null) {
                            list.addAll(this.translateValues(n3, attribute.getValueList(string12), string11));
                            object = AttrValuesCompletion.getSupport(astNode2.name(), string10);
                            if (object != null) {
                                list.addAll(((AttrValuesCompletion)object).getValueCompletionItems(this.document, this.offset, string12));
                            }
                        }
                        object = new HtmlExtension.CompletionContext(htmlParserResult, n4, n5, n, string12, string, astNode2, string10, string11 != null);
                        for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(string3)) {
                            list.addAll(htmlExtension.completeAttributeValue((HtmlExtension.CompletionContext)object));
                        }
                    }
                }
            }
        }
        return list == null ? null : new CompletionResult(list, n);
    }

    private boolean usesLowerCase(HtmlParserResult htmlParserResult, int n) {
        AstNode astNode = AstNodeUtils.getTagNode((AstNode)htmlParserResult.root(), (int)n);
        return astNode != null ? Character.isLowerCase(astNode.name().charAt(0)) : true;
    }

    public List<CompletionItem> getAutocompletedEndTag(AstNode astNode, int n, int n2) {
        if (astNode.type() == AstNode.NodeType.OPEN_TAG && astNode.endOffset() == n && !astNode.isEmpty() && !AstNodeUtils.hasForbiddenEndTag((AstNode)astNode)) {
            return Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(astNode.name(), n2));
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> translateCharRefs(int n, List list) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        for (DTD.CharRef charRef : list) {
            String string = charRef.getName();
            arrayList.add(HtmlCompletionItem.createCharacterReference(string, charRef.getValue(), n, string));
        }
        return arrayList;
    }

    private List<CompletionItem> getPossibleEndTags(AstNode astNode, int n, String string) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        int n2 = 0;
        while (astNode.type() != AstNode.NodeType.ROOT) {
            if (!(astNode.getDTDElement() != null && AstNodeUtils.hasForbiddenEndTag((AstNode)astNode) || astNode.type() != AstNode.NodeType.OPEN_TAG)) {
                String string2 = astNode.name();
                if (string2.startsWith(string.toLowerCase(Locale.ENGLISH))) {
                    arrayList.add(HtmlCompletionItem.createEndTag(string2, n - 2 - string.length(), string2, n2++, this.getEndTagType(astNode)));
                }
                if (astNode.needsToHaveMatchingTag() && astNode.getMatchingTag() == null) break;
            }
            astNode = astNode.parent();
            assert (astNode != null);
        }
        return arrayList;
    }

    private HtmlCompletionItem.EndTag.Type getEndTagType(AstNode astNode) {
        if (astNode.getMatchingTag() != null) {
            return astNode.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING : HtmlCompletionItem.EndTag.Type.OPTIONAL_EXISTING;
        }
        return astNode.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_MISSING : HtmlCompletionItem.EndTag.Type.OPTIONAL_MISSING;
    }

    private Collection<DTD.Element> filterElements(Collection<DTD.Element> collection, String string) {
        ArrayList<DTD.Element> arrayList = new ArrayList<DTD.Element>();
        string = string.toLowerCase(Locale.ENGLISH);
        for (DTD.Element element : collection) {
            if (!element.getName().toLowerCase(Locale.ENGLISH).startsWith(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    List<CompletionItem> translateTags(int n, Collection<DTD.Element> collection, Collection<DTD.Element> collection2) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(collection2.size());
        collection2.removeAll(collection);
        for (DTD.Element element : collection) {
            arrayList.add(this.item4Element(element, n, true));
        }
        for (DTD.Element element : collection2) {
            arrayList.add(this.item4Element(element, n, false));
        }
        return arrayList;
    }

    private HtmlCompletionItem item4Element(DTD.Element element, int n, boolean bl) {
        String string = element.getName();
        string = isXHtml ? string : (lowerCase ? string.toLowerCase(Locale.ENGLISH) : string.toUpperCase(Locale.ENGLISH));
        return HtmlCompletionItem.createTag(string, n, string, bl);
    }

    List<CompletionItem> translateAttribs(int n, List<DTD.Attribute> list, DTD.Element element) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        String string = element.getName() + "#";
        for (DTD.Attribute attribute : list) {
            String string2 = attribute.getName();
            switch (attribute.getType()) {
                case 0: {
                    arrayList.add(HtmlCompletionItem.createBooleanAttribute(string2, n, attribute.isRequired(), string + string2));
                    break;
                }
                case 1: 
                case 2: {
                    arrayList.add(HtmlCompletionItem.createAttribute(string2, n, attribute.isRequired(), string + string2));
                }
            }
        }
        return arrayList;
    }

    List<HtmlCompletionItem> translateValues(int n, List list) {
        return this.translateValues(n, list, null);
    }

    List<HtmlCompletionItem> translateValues(int n, List list, String string) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<HtmlCompletionItem> arrayList = new ArrayList<HtmlCompletionItem>(list.size());
        if (string != null) {
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(HtmlCompletionItem.createAttributeValue(((DTD.Value)iterator.next()).getName(), n));
        }
        return arrayList;
    }

    static {
        isXHtml = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompletionResult {
        private Collection<? extends CompletionItem> items;
        int anchor;

        CompletionResult(Collection<? extends CompletionItem> collection, int n) {
            this.items = collection;
            this.anchor = n;
        }

        public int getAnchor() {
            return this.anchor;
        }

        public Collection<? extends CompletionItem> getItems() {
            return this.items;
        }
    }
}

