/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import java.io.Serializable;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.Node;

public abstract class StaticScope
implements Serializable {
    private static final long serialVersionUID = 4843861446986961013L;
    protected final StaticScope enclosingScope;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private boolean[] variableCaptured;
    private boolean isArgumentScope = false;

    protected StaticScope(StaticScope enclosingScope, String[] names) {
        assert (names != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names));
        this.enclosingScope = enclosingScope;
        this.variableNames = names;
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    private static boolean namesAreInterned(String[] names) {
        for (String name : names) {
            if (name == name.intern()) continue;
            return false;
        }
        return true;
    }

    public int addVariable(String name) {
        int slot = this.isDefined(name);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name);
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames.length;
    }

    public void setVariables(String[] names) {
        assert (names != null) : "names is not null";
        this.variableNames = new String[names.length];
        System.arraycopy(names, 0, this.variableNames, 0, names.length);
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name) {
        return this.findVariableName(name);
    }

    private int findVariableName(String name) {
        for (int i = 0; i < this.variableNames.length; ++i) {
            if (name != this.variableNames[i]) continue;
            return i;
        }
        return -1;
    }

    public int isDefined(String name) {
        return this.isDefined(name, 0);
    }

    public AssignableNode assign(SourcePosition position, String name, Node value) {
        return this.assign(position, name, value, this, 0);
    }

    public abstract String[] getAllNamesInScope();

    protected abstract int isDefined(String var1, int var2);

    protected abstract AssignableNode assign(SourcePosition var1, String var2, Node var3, StaticScope var4, int var5);

    protected abstract Node declare(SourcePosition var1, String var2, int var3);

    public Node declare(SourcePosition position, String name) {
        return this.declare(position, name, 0);
    }

    public void capture(int index) {
        this.variableCaptured[index] = true;
    }

    public boolean isCaptured(int index) {
        return this.variableCaptured[index];
    }

    public abstract StaticScope getLocalScope();

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void setArgumentScope(boolean isArgumentScope) {
        this.isArgumentScope = isArgumentScope;
    }

    private void growVariableNames(String name) {
        String[] newVariableNames = new String[this.variableNames.length + 1];
        System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
        this.variableNames = newVariableNames;
        this.variableNames[this.variableNames.length - 1] = name;
        boolean[] newVariableCaptured = new boolean[this.variableCaptured.length + 1];
        System.arraycopy(this.variableCaptured, 0, newVariableCaptured, 0, this.variableCaptured.length);
        this.variableCaptured = newVariableCaptured;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < this.variableNames.length - 1; ++i) {
            buf.append(this.variableNames[i]).append(", ");
        }
        if (this.variableNames.length > 0) {
            buf.append(this.variableNames[this.variableNames.length - 1]);
        }
        buf.append("]");
        return buf.toString();
    }
}

