/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MavenJDOMWriter {
    private DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private String lineSeparator = "\n";

    protected Element findAndReplaceProperties(Counter counter, Element element, String string, Map map) {
        boolean bl = map != null && !map.isEmpty();
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Object object;
            Iterator<Object> iterator = map.keySet().iterator();
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.findAndReplaceSimpleElement(counter2, element2, (String)object, (String)map.get(object), null);
            }
            object = new ArrayList(map.keySet());
            iterator = element2.getChildren().iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string2 = element3.getName();
                if (((ArrayList)object).contains(string2)) continue;
                iterator.remove();
            }
        }
        return element2;
    }

    protected Element findAndReplaceSimpleElement(Counter counter, Element element, String string, String string2, String string3) {
        Element element2;
        if (string3 != null && string2 != null && string3.equals(string2) && ((element2 = element.getChild(string, element.getNamespace())) != null && string3.equals(element2.getText()) || element2 == null)) {
            return element2;
        }
        boolean bl = string2 != null && string2.trim().length() > 0;
        Element element3 = this.updateElement(counter, element, string, bl);
        if (bl) {
            element3.setText(string2);
        }
        return element3;
    }

    protected Element findAndReplaceSimpleLists(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                String string3 = (String)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                element3.setText(string3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
        return element2;
    }

    protected Element findAndReplaceXpp3DOM(Counter counter, Element element, String string, Xpp3Dom xpp3Dom) {
        boolean bl = xpp3Dom != null && (xpp3Dom.getChildCount() > 0 || xpp3Dom.getValue() != null);
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            this.replaceXpp3DOM(element2, xpp3Dom, new Counter(counter.getDepth() + 1));
        }
        return element2;
    }

    protected void insertAtPreferredLocation(Element element, Element element2, Counter counter) {
        String string;
        int n = 0;
        int n2 = 0;
        Iterator iterator = element.getContent().iterator();
        Text text = null;
        int n3 = 0;
        while (iterator.hasNext() && n2 <= counter.getCurrentIndex()) {
            string = iterator.next();
            ++n3;
            if (string instanceof Element) {
                ++n2;
                n += n3;
                n3 = 0;
            }
            if (!(string instanceof Text) || !iterator.hasNext()) continue;
            text = (Text)string;
        }
        if (text != null && text.getTextTrim().length() == 0) {
            text = (Text)text.clone();
        } else {
            string = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                string = string + "    ";
            }
            text = this.factory.text(string);
        }
        if (element.getContentSize() == 0) {
            string = (Text)text.clone();
            string.setText(string.getText().substring(0, string.getText().length() - "    ".length()));
            element.addContent(n, (Content)string);
        }
        element.addContent(n, (Content)element2);
        element.addContent(n, (Content)text);
    }

    protected void iterateContributor(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Contributor contributor = (Contributor)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateContributor(contributor, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateDependency(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Dependency dependency = (Dependency)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateDependency(dependency, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateDeveloper(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Developer developer = (Developer)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateDeveloper(developer, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateExclusion(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Exclusion exclusion = (Exclusion)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateExclusion(exclusion, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateExtension(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Extension extension = (Extension)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateExtension(extension, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateLicense(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                License license = (License)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateLicense(license, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateMailingList(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                MailingList mailingList = (MailingList)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateMailingList(mailingList, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateNotifier(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Notifier notifier = (Notifier)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateNotifier(notifier, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iteratePlugin(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Plugin plugin = (Plugin)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updatePlugin(plugin, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iteratePluginExecution(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                PluginExecution pluginExecution = (PluginExecution)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updatePluginExecution(pluginExecution, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateProfile(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Profile profile = (Profile)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateProfile(profile, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateReportPlugin(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                ReportPlugin reportPlugin = (ReportPlugin)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateReportPlugin(reportPlugin, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateReportSet(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                ReportSet reportSet = (ReportSet)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateReportSet(reportSet, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateRepository(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Repository repository = (Repository)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateRepository(repository, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateResource(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Resource resource = (Resource)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateResource(resource, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void replaceXpp3DOM(Element element, Xpp3Dom xpp3Dom, Counter counter) {
        if (xpp3Dom.getChildCount() > 0) {
            Object object;
            int n;
            Xpp3Dom[] xpp3DomArray = xpp3Dom.getChildren();
            ArrayList<Xpp3Dom> arrayList = new ArrayList<Xpp3Dom>();
            for (n = 0; n < xpp3DomArray.length; ++n) {
                arrayList.add(xpp3DomArray[n]);
            }
            n = 0;
            ListIterator listIterator = element.getChildren().listIterator();
            while (listIterator.hasNext()) {
                Element element2 = (Element)listIterator.next();
                Iterator object2 = arrayList.iterator();
                object = null;
                while (object2.hasNext()) {
                    Xpp3Dom xpp3Dom2 = (Xpp3Dom)object2.next();
                    if (!xpp3Dom2.getName().equals(element2.getName())) continue;
                    object = xpp3Dom2;
                    break;
                }
                if (object != null) {
                    arrayList.remove(object);
                    this.replaceXpp3DOM(element2, (Xpp3Dom)object, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                element.removeContent((Content)element2);
            }
            for (Xpp3Dom xpp3Dom3 : arrayList) {
                object = this.factory.element(xpp3Dom3.getName(), element.getNamespace());
                this.insertAtPreferredLocation(element, (Element)object, counter);
                counter.increaseCount();
                this.replaceXpp3DOM((Element)object, xpp3Dom3, new Counter(counter.getDepth() + 1));
            }
        } else if (xpp3Dom.getValue() != null) {
            element.setText(xpp3Dom.getValue());
        }
    }

    protected void updateActivation(Activation activation, String string, Counter counter, Element element) {
        boolean bl = activation != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "activeByDefault", !activation.isActiveByDefault() ? null : String.valueOf(activation.isActiveByDefault()), "false");
            this.findAndReplaceSimpleElement(counter2, element2, "jdk", activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), "os", counter2, element2);
            this.updateActivationProperty(activation.getProperty(), "property", counter2, element2);
            this.updateActivationFile(activation.getFile(), "file", counter2, element2);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, String string, Counter counter, Element element) {
        boolean bl = activationFile != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "missing", activationFile.getMissing(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "exists", activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, String string, Counter counter, Element element) {
        boolean bl = activationOS != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "name", activationOS.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "family", activationOS.getFamily(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "arch", activationOS.getArch(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "version", activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, String string, Counter counter, Element element) {
        boolean bl = activationProperty != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "name", activationProperty.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "value", activationProperty.getValue(), null);
        }
    }

    protected void updateBuild(Build build, String string, Counter counter, Element element) {
        boolean bl = build != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "sourceDirectory", build.getSourceDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "scriptSourceDirectory", build.getScriptSourceDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "testSourceDirectory", build.getTestSourceDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "outputDirectory", build.getOutputDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "testOutputDirectory", build.getTestOutputDirectory(), null);
            this.iterateExtension(counter2, element2, build.getExtensions(), "extensions", "extension");
            this.findAndReplaceSimpleElement(counter2, element2, "defaultGoal", build.getDefaultGoal(), null);
            this.iterateResource(counter2, element2, build.getResources(), "resources", "resource");
            this.iterateResource(counter2, element2, build.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(counter2, element2, "directory", build.getDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "finalName", build.getFinalName(), null);
            this.findAndReplaceSimpleLists(counter2, element2, build.getFilters(), "filters", "filter");
            this.updatePluginManagement(build.getPluginManagement(), "pluginManagement", counter2, element2);
            this.iteratePlugin(counter2, element2, build.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateBuildBase(BuildBase buildBase, String string, Counter counter, Element element) {
        boolean bl = buildBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "defaultGoal", buildBase.getDefaultGoal(), null);
            this.iterateResource(counter2, element2, buildBase.getResources(), "resources", "resource");
            this.iterateResource(counter2, element2, buildBase.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(counter2, element2, "directory", buildBase.getDirectory(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "finalName", buildBase.getFinalName(), null);
            this.findAndReplaceSimpleLists(counter2, element2, buildBase.getFilters(), "filters", "filter");
            this.updatePluginManagement(buildBase.getPluginManagement(), "pluginManagement", counter2, element2);
            this.iteratePlugin(counter2, element2, buildBase.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateCiManagement(CiManagement ciManagement, String string, Counter counter, Element element) {
        boolean bl = ciManagement != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "system", ciManagement.getSystem(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", ciManagement.getUrl(), null);
            this.iterateNotifier(counter2, element2, ciManagement.getNotifiers(), "notifiers", "notifier");
        }
    }

    protected void updateConfigurationContainer(ConfigurationContainer configurationContainer, String string, Counter counter, Element element) {
        boolean bl = configurationContainer != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "inherited", configurationContainer.getInherited(), null);
            this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)configurationContainer.getConfiguration());
        }
    }

    protected void updateContributor(Contributor contributor, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "name", contributor.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "email", contributor.getEmail(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", contributor.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "organization", contributor.getOrganization(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "organizationUrl", contributor.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(counter2, element2, contributor.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(counter2, element2, "timezone", contributor.getTimezone(), null);
        this.findAndReplaceProperties(counter2, element2, "properties", contributor.getProperties());
    }

    protected void updateDependency(Dependency dependency, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", dependency.getGroupId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", dependency.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "version", dependency.getVersion(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "type", dependency.getType(), "jar");
        this.findAndReplaceSimpleElement(counter2, element2, "classifier", dependency.getClassifier(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "scope", dependency.getScope(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "systemPath", dependency.getSystemPath(), null);
        this.iterateExclusion(counter2, element2, dependency.getExclusions(), "exclusions", "exclusion");
        this.findAndReplaceSimpleElement(counter2, element2, "optional", !dependency.isOptional() ? null : String.valueOf(dependency.isOptional()), "false");
    }

    protected void updateDependencyManagement(DependencyManagement dependencyManagement, String string, Counter counter, Element element) {
        boolean bl = dependencyManagement != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.iterateDependency(counter2, element2, dependencyManagement.getDependencies(), "dependencies", "dependency");
        }
    }

    protected void updateDeploymentRepository(DeploymentRepository deploymentRepository, String string, Counter counter, Element element) {
        boolean bl = deploymentRepository != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "uniqueVersion", deploymentRepository.isUniqueVersion() ? null : String.valueOf(deploymentRepository.isUniqueVersion()), "true");
            this.findAndReplaceSimpleElement(counter2, element2, "id", deploymentRepository.getId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "name", deploymentRepository.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", deploymentRepository.getUrl(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "layout", deploymentRepository.getLayout(), "default");
        }
    }

    protected void updateDeveloper(Developer developer, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "id", developer.getId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "name", developer.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "email", developer.getEmail(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", developer.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "organization", developer.getOrganization(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "organizationUrl", developer.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(counter2, element2, developer.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(counter2, element2, "timezone", developer.getTimezone(), null);
        this.findAndReplaceProperties(counter2, element2, "properties", developer.getProperties());
    }

    protected void updateDistributionManagement(DistributionManagement distributionManagement, String string, Counter counter, Element element) {
        boolean bl = distributionManagement != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.updateDeploymentRepository(distributionManagement.getRepository(), "repository", counter2, element2);
            this.updateDeploymentRepository(distributionManagement.getSnapshotRepository(), "snapshotRepository", counter2, element2);
            this.updateSite(distributionManagement.getSite(), "site", counter2, element2);
            this.findAndReplaceSimpleElement(counter2, element2, "downloadUrl", distributionManagement.getDownloadUrl(), null);
            this.updateRelocation(distributionManagement.getRelocation(), "relocation", counter2, element2);
            this.findAndReplaceSimpleElement(counter2, element2, "status", distributionManagement.getStatus(), null);
        }
    }

    protected Element updateElement(Counter counter, Element element, String string, boolean bl) {
        Element element2 = element.getChild(string, element.getNamespace());
        if (element2 != null && bl) {
            counter.increaseCount();
        }
        if (element2 == null && bl) {
            element2 = this.factory.element(string, element.getNamespace());
            this.insertAtPreferredLocation(element, element2, counter);
            counter.increaseCount();
        }
        if (!bl && element2 != null) {
            Text text;
            Content content;
            int n = element.indexOf((Content)element2);
            if (n > 0 && (content = element.getContent(n - 1)) instanceof Text && (text = (Text)content).getTextTrim().length() == 0) {
                element.removeContent((Content)text);
            }
            element.removeContent((Content)element2);
        }
        return element2;
    }

    protected void updateExclusion(Exclusion exclusion, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", exclusion.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", exclusion.getGroupId(), null);
    }

    protected void updateExtension(Extension extension, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", extension.getGroupId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", extension.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "version", extension.getVersion(), null);
    }

    protected void updateFileSet(FileSet fileSet, String string, Counter counter, Element element) {
        boolean bl = fileSet != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "directory", fileSet.getDirectory(), null);
            this.findAndReplaceSimpleLists(counter2, element2, fileSet.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(counter2, element2, fileSet.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updateIssueManagement(IssueManagement issueManagement, String string, Counter counter, Element element) {
        boolean bl = issueManagement != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "system", issueManagement.getSystem(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", issueManagement.getUrl(), null);
        }
    }

    protected void updateLicense(License license, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "name", license.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", license.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "distribution", license.getDistribution(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "comments", license.getComments(), null);
    }

    protected void updateMailingList(MailingList mailingList, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "name", mailingList.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "subscribe", mailingList.getSubscribe(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "unsubscribe", mailingList.getUnsubscribe(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "post", mailingList.getPost(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "archive", mailingList.getArchive(), null);
        this.findAndReplaceSimpleLists(counter2, element2, mailingList.getOtherArchives(), "otherArchives", "otherArchive");
    }

    protected void updateModel(Model model, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.updateParent(model.getParent(), "parent", counter2, element2);
        this.findAndReplaceSimpleElement(counter2, element2, "modelVersion", model.getModelVersion(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", model.getGroupId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", model.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "packaging", model.getPackaging(), "jar");
        this.findAndReplaceSimpleElement(counter2, element2, "name", model.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "version", model.getVersion(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "description", model.getDescription(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", model.getUrl(), null);
        this.updatePrerequisites(model.getPrerequisites(), "prerequisites", counter2, element2);
        this.updateIssueManagement(model.getIssueManagement(), "issueManagement", counter2, element2);
        this.updateCiManagement(model.getCiManagement(), "ciManagement", counter2, element2);
        this.findAndReplaceSimpleElement(counter2, element2, "inceptionYear", model.getInceptionYear(), null);
        this.iterateMailingList(counter2, element2, model.getMailingLists(), "mailingLists", "mailingList");
        this.iterateDeveloper(counter2, element2, model.getDevelopers(), "developers", "developer");
        this.iterateContributor(counter2, element2, model.getContributors(), "contributors", "contributor");
        this.iterateLicense(counter2, element2, model.getLicenses(), "licenses", "license");
        this.updateScm(model.getScm(), "scm", counter2, element2);
        this.updateOrganization(model.getOrganization(), "organization", counter2, element2);
        this.updateBuild(model.getBuild(), "build", counter2, element2);
        this.iterateProfile(counter2, element2, model.getProfiles(), "profiles", "profile");
        this.findAndReplaceSimpleLists(counter2, element2, model.getModules(), "modules", "module");
        this.iterateRepository(counter2, element2, model.getRepositories(), "repositories", "repository");
        this.iterateRepository(counter2, element2, model.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.iterateDependency(counter2, element2, model.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(counter2, element2, "reports", (Xpp3Dom)model.getReports());
        this.updateReporting(model.getReporting(), "reporting", counter2, element2);
        this.updateDependencyManagement(model.getDependencyManagement(), "dependencyManagement", counter2, element2);
        this.updateDistributionManagement(model.getDistributionManagement(), "distributionManagement", counter2, element2);
        this.findAndReplaceProperties(counter2, element2, "properties", model.getProperties());
    }

    protected void updateModelBase(ModelBase modelBase, String string, Counter counter, Element element) {
        boolean bl = modelBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(counter2, element2, modelBase.getModules(), "modules", "module");
            this.iterateRepository(counter2, element2, modelBase.getRepositories(), "repositories", "repository");
            this.iterateRepository(counter2, element2, modelBase.getPluginRepositories(), "pluginRepositories", "pluginRepository");
            this.iterateDependency(counter2, element2, modelBase.getDependencies(), "dependencies", "dependency");
            this.findAndReplaceXpp3DOM(counter2, element2, "reports", (Xpp3Dom)modelBase.getReports());
            this.updateReporting(modelBase.getReporting(), "reporting", counter2, element2);
            this.updateDependencyManagement(modelBase.getDependencyManagement(), "dependencyManagement", counter2, element2);
            this.updateDistributionManagement(modelBase.getDistributionManagement(), "distributionManagement", counter2, element2);
            this.findAndReplaceProperties(counter2, element2, "properties", modelBase.getProperties());
        }
    }

    protected void updateNotifier(Notifier notifier, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "type", notifier.getType(), "mail");
        this.findAndReplaceSimpleElement(counter2, element2, "sendOnError", notifier.isSendOnError() ? null : String.valueOf(notifier.isSendOnError()), "true");
        this.findAndReplaceSimpleElement(counter2, element2, "sendOnFailure", notifier.isSendOnFailure() ? null : String.valueOf(notifier.isSendOnFailure()), "true");
        this.findAndReplaceSimpleElement(counter2, element2, "sendOnSuccess", notifier.isSendOnSuccess() ? null : String.valueOf(notifier.isSendOnSuccess()), "true");
        this.findAndReplaceSimpleElement(counter2, element2, "sendOnWarning", notifier.isSendOnWarning() ? null : String.valueOf(notifier.isSendOnWarning()), "true");
        this.findAndReplaceSimpleElement(counter2, element2, "address", notifier.getAddress(), null);
        this.findAndReplaceProperties(counter2, element2, "configuration", notifier.getConfiguration());
    }

    protected void updateOrganization(Organization organization, String string, Counter counter, Element element) {
        boolean bl = organization != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "name", organization.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", organization.getUrl(), null);
        }
    }

    protected void updateParent(Parent parent, String string, Counter counter, Element element) {
        boolean bl = parent != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "artifactId", parent.getArtifactId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "groupId", parent.getGroupId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "version", parent.getVersion(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "relativePath", parent.getRelativePath(), "../pom.xml");
        }
    }

    protected void updatePatternSet(PatternSet patternSet, String string, Counter counter, Element element) {
        boolean bl = patternSet != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(counter2, element2, patternSet.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(counter2, element2, patternSet.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updatePlugin(Plugin plugin, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", plugin.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", plugin.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "version", plugin.getVersion(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "extensions", !plugin.isExtensions() ? null : String.valueOf(plugin.isExtensions()), "false");
        this.iteratePluginExecution(counter2, element2, plugin.getExecutions(), "executions", "execution");
        this.iterateDependency(counter2, element2, plugin.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(counter2, element2, "goals", (Xpp3Dom)plugin.getGoals());
        this.findAndReplaceSimpleElement(counter2, element2, "inherited", plugin.getInherited(), null);
        this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)plugin.getConfiguration());
    }

    protected void updatePluginConfiguration(PluginConfiguration pluginConfiguration, String string, Counter counter, Element element) {
        boolean bl = pluginConfiguration != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.updatePluginManagement(pluginConfiguration.getPluginManagement(), "pluginManagement", counter2, element2);
            this.iteratePlugin(counter2, element2, pluginConfiguration.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginContainer(PluginContainer pluginContainer, String string, Counter counter, Element element) {
        boolean bl = pluginContainer != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(counter2, element2, pluginContainer.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginExecution(PluginExecution pluginExecution, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "id", pluginExecution.getId(), "default");
        this.findAndReplaceSimpleElement(counter2, element2, "phase", pluginExecution.getPhase(), null);
        this.findAndReplaceSimpleLists(counter2, element2, pluginExecution.getGoals(), "goals", "goal");
        this.findAndReplaceSimpleElement(counter2, element2, "inherited", pluginExecution.getInherited(), null);
        this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)pluginExecution.getConfiguration());
    }

    protected void updatePluginManagement(PluginManagement pluginManagement, String string, Counter counter, Element element) {
        boolean bl = pluginManagement != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(counter2, element2, pluginManagement.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePrerequisites(Prerequisites prerequisites, String string, Counter counter, Element element) {
        boolean bl = prerequisites != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "maven", prerequisites.getMaven(), "2.0");
        }
    }

    protected void updateProfile(Profile profile, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "id", profile.getId(), null);
        this.updateActivation(profile.getActivation(), "activation", counter2, element2);
        this.updateBuildBase(profile.getBuild(), "build", counter2, element2);
        this.findAndReplaceSimpleLists(counter2, element2, profile.getModules(), "modules", "module");
        this.iterateRepository(counter2, element2, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(counter2, element2, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.iterateDependency(counter2, element2, profile.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(counter2, element2, "reports", (Xpp3Dom)profile.getReports());
        this.updateReporting(profile.getReporting(), "reporting", counter2, element2);
        this.updateDependencyManagement(profile.getDependencyManagement(), "dependencyManagement", counter2, element2);
        this.updateDistributionManagement(profile.getDistributionManagement(), "distributionManagement", counter2, element2);
        this.findAndReplaceProperties(counter2, element2, "properties", profile.getProperties());
    }

    protected void updateRelocation(Relocation relocation, String string, Counter counter, Element element) {
        boolean bl = relocation != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "groupId", relocation.getGroupId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "artifactId", relocation.getArtifactId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "version", relocation.getVersion(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "message", relocation.getMessage(), null);
        }
    }

    protected void updateReportPlugin(ReportPlugin reportPlugin, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "groupId", reportPlugin.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(counter2, element2, "artifactId", reportPlugin.getArtifactId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "version", reportPlugin.getVersion(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "inherited", reportPlugin.getInherited(), null);
        this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)reportPlugin.getConfiguration());
        this.iterateReportSet(counter2, element2, reportPlugin.getReportSets(), "reportSets", "reportSet");
    }

    protected void updateReportSet(ReportSet reportSet, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "id", reportSet.getId(), "default");
        this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)reportSet.getConfiguration());
        this.findAndReplaceSimpleElement(counter2, element2, "inherited", reportSet.getInherited(), null);
        this.findAndReplaceSimpleLists(counter2, element2, reportSet.getReports(), "reports", "report");
    }

    protected void updateReporting(Reporting reporting, String string, Counter counter, Element element) {
        boolean bl = reporting != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "excludeDefaults", !reporting.isExcludeDefaults() ? null : String.valueOf(reporting.isExcludeDefaults()), "false");
            this.findAndReplaceSimpleElement(counter2, element2, "outputDirectory", reporting.getOutputDirectory(), null);
            this.iterateReportPlugin(counter2, element2, reporting.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateRepository(Repository repository, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", counter2, element2);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", counter2, element2);
        this.findAndReplaceSimpleElement(counter2, element2, "id", repository.getId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "name", repository.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", repository.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "layout", repository.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase repositoryBase, String string, Counter counter, Element element) {
        boolean bl = repositoryBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "id", repositoryBase.getId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "name", repositoryBase.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", repositoryBase.getUrl(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "layout", repositoryBase.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String string, Counter counter, Element element) {
        boolean bl = repositoryPolicy != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "enabled", repositoryPolicy.isEnabled() ? null : String.valueOf(repositoryPolicy.isEnabled()), "true");
            this.findAndReplaceSimpleElement(counter2, element2, "updatePolicy", repositoryPolicy.getUpdatePolicy(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "checksumPolicy", repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateResource(Resource resource, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "targetPath", resource.getTargetPath(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "filtering", !resource.isFiltering() ? null : String.valueOf(resource.isFiltering()), "false");
        this.findAndReplaceSimpleElement(counter2, element2, "directory", resource.getDirectory(), null);
        this.findAndReplaceSimpleLists(counter2, element2, resource.getIncludes(), "includes", "include");
        this.findAndReplaceSimpleLists(counter2, element2, resource.getExcludes(), "excludes", "exclude");
    }

    protected void updateScm(Scm scm, String string, Counter counter, Element element) {
        boolean bl = scm != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "connection", scm.getConnection(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "developerConnection", scm.getDeveloperConnection(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "tag", scm.getTag(), "HEAD");
            this.findAndReplaceSimpleElement(counter2, element2, "url", scm.getUrl(), null);
        }
    }

    protected void updateSite(Site site, String string, Counter counter, Element element) {
        boolean bl = site != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "id", site.getId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "name", site.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", site.getUrl(), null);
        }
    }

    public void write(Model model, Document document, OutputStream outputStream) throws IOException {
        this.updateModel(model, "project", new Counter(0), document.getRootElement());
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat().setIndent("    ").setLineSeparator(System.getProperty("line.separator")));
        xMLOutputter.output(document, outputStream);
    }

    public void write(Model model, Document document, OutputStreamWriter outputStreamWriter) throws IOException {
        Format format = Format.getRawFormat().setEncoding(outputStreamWriter.getEncoding()).setLineSeparator(System.getProperty("line.separator"));
        this.write(model, document, outputStreamWriter, format);
    }

    public void write(Model model, Document document, Writer writer, Format format) throws IOException {
        this.updateModel(model, "project", new Counter(0), document.getRootElement());
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(format);
        xMLOutputter.output(document, writer);
    }

    public class Counter {
        private int currentIndex = 0;
        private int level;

        public Counter(int n) {
            this.level = n;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }
    }
}

