/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.registry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.ColumnModelRegistration;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(AttachType.Registration.class.getCanonicalName(), BreakpointType.Registration.class.getCanonicalName(), ColumnModelRegistration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        String string;
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        int n = 0;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(AttachType.Registration.class)) {
            annotation = element.getAnnotation(AttachType.Registration.class);
            string = annotation.displayName();
            int n2 = annotation.position();
            this.handleProviderRegistrationDisplayName(element, AttachType.class, string, null, n2);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(BreakpointType.Registration.class)) {
            annotation = element.getAnnotation(BreakpointType.Registration.class);
            string = annotation.displayName();
            String string2 = annotation.path();
            int n3 = annotation.position();
            this.handleProviderRegistrationDisplayName(element, BreakpointType.class, string, string2, n3);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ColumnModelRegistration.class)) {
            annotation = element.getAnnotation(ColumnModelRegistration.class);
            string = annotation.path();
            int n4 = annotation.position();
            this.handleProviderRegistration(element, ColumnModel.class, string, n4);
            ++n;
        }
        return n == set.size();
    }

    private void handleProviderRegistration(Element element, Class clazz, String string, int n) throws IllegalArgumentException, LayerGenerationException {
        String string2 = this.instantiableClassOrMethod(element);
        if (!this.isClassOf(element, clazz)) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + clazz);
        }
        string = string != null && string.length() > 0 ? "Debugger/" + string : "Debugger";
        this.layer(new Element[]{element}).instanceFile(string, null, clazz).stringvalue(SERVICE_NAME, string2).stringvalue("serviceClass", clazz.getName()).stringvalue("instanceOf", clazz.getName()).methodvalue("instanceCreate", "org.netbeans.modules.debugger.ui.registry." + clazz.getSimpleName() + "ContextAware", "createService").position(n).write();
    }

    private void handleProviderRegistrationDisplayName(Element element, Class clazz, String string, String string2, int n) throws IllegalArgumentException, LayerGenerationException {
        String string3 = this.instantiableClassOrMethod(element);
        if (!this.isClassOf(element, clazz)) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + clazz);
        }
        string2 = string2 != null && string2.length() > 0 ? "Debugger/" + string2 : "Debugger";
        this.layer(new Element[]{element}).instanceFile(string2, null, clazz).stringvalue(SERVICE_NAME, string3).stringvalue("serviceClass", clazz.getName()).stringvalue("instanceOf", clazz.getName()).bundlevalue("displayName", string).methodvalue("instanceCreate", clazz.getName() + "$ContextAware", "createService").position(n).write();
    }

    private boolean isClassOf(Element element, Class clazz) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeElement = (TypeElement)element;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    private String instantiableClassOrMethod(Element element) throws IllegalArgumentException, LayerGenerationException {
        switch (element.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", element);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor", element);
                }
                return string;
            }
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(executableElement + " must be static", element);
                }
                if (executableElement.getParameters().size() > 0) {
                    throw new LayerGenerationException(executableElement + " must not have any parameters", element);
                }
                return string2 + "." + string + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }
}

