/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewActions
extends AbstractAction {
    private String viewName;

    private ViewActions(String string) {
        this.viewName = string;
    }

    public Object getValue(String string) {
        if (string == "Name") {
            return NbBundle.getMessage(ViewActions.class, (String)((String)super.getValue(string)));
        }
        Object object = super.getValue(string);
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ViewActions.openComponent(this.viewName, true);
    }

    static TopComponent openComponent(String string, boolean bl) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        if (topComponent == null) {
            throw new IllegalArgumentException(string);
        }
        topComponent.open();
        if (bl) {
            topComponent.requestActive();
        }
        return topComponent;
    }

    public static Action createBreakpointsViewAction() {
        ViewActions viewActions = new ViewActions("breakpointsView");
        viewActions.putValue("Name", "CTL_BreakpointsAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint.gif");
        return viewActions;
    }

    public static Action createCallStackViewAction() {
        ViewActions viewActions = new ViewActions("callstackView");
        viewActions.putValue("Name", "CTL_CallStackAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/callStackView/call_stack_16.png");
        return viewActions;
    }

    public static Action createLocalsViewAction() {
        ViewActions viewActions = new ViewActions("localsView");
        viewActions.putValue("Name", "CTL_LocalVariablesAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png");
        return viewActions;
    }

    public static Action createSessionsViewAction() {
        ViewActions viewActions = new ViewActions("sessionsView");
        viewActions.putValue("Name", "CTL_SessionsAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/sessionsView/session_16.png");
        return viewActions;
    }

    public static Action createThreadsViewAction() {
        ViewActions viewActions = new ViewActions("threadsView");
        viewActions.putValue("Name", "CTL_ThreadsAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup.gif");
        return viewActions;
    }

    public static Action createWatchesViewAction() {
        ViewActions viewActions = new ViewActions("watchesView");
        viewActions.putValue("Name", "CTL_WatchesAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/watchesView/watch_16.png");
        return viewActions;
    }

    public static Action createSourcesViewAction() {
        ViewActions viewActions = new ViewActions("sources");
        viewActions.putValue("Name", "CTL_SourcesAction");
        viewActions.putValue("iconbase", "org/netbeans/modules/debugger/resources/sourcesView/sources_16.png");
        return viewActions;
    }
}

