/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddBreakpointPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String PROP_TYPE = "type";
    private static Object lastSelectedCategory;
    private boolean doNotRefresh = false;
    private Set cathegories = new TreeSet();
    private ArrayList types = new ArrayList();
    private BreakpointType type;
    private JComponent customizer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox cbCathegory;
    private JComboBox cbEvents;
    private JPanel pEvent;
    private HelpCtx helpCtx;
    private List<? extends BreakpointType> breakpointTypes = DebuggerManager.getDebuggerManager().lookup(null, BreakpointType.class);

    public AddBreakpointPanel() {
        String string = null;
        for (BreakpointType breakpointType : this.breakpointTypes) {
            String string2 = breakpointType.getCategoryDisplayName();
            if (!this.cathegories.contains(string2)) {
                this.cathegories.add(string2);
            }
            if (!breakpointType.isDefault()) continue;
            string = string2;
        }
        this.cbCathegory = new JComboBox<Object>(this.cathegories.toArray());
        this.initComponents();
        if (string != null) {
            this.cbCathegory.setSelectedItem(string);
            this.selectCathegory(string);
        } else if (this.breakpointTypes.size() > 0) {
            if (lastSelectedCategory != null && this.cathegories.contains(lastSelectedCategory)) {
                this.cbCathegory.setSelectedItem(lastSelectedCategory);
            } else {
                this.cbCathegory.setSelectedIndex(0);
            }
            this.selectCathegory((String)this.cbCathegory.getSelectedItem());
        }
    }

    public BreakpointType getType() {
        return this.type;
    }

    Controller getController() {
        if (this.type != null) {
            Controller controller = this.type.getController();
            if (controller == null && this.customizer instanceof Controller) {
                return (Controller)((Object)this.customizer);
            }
            return controller;
        }
        return null;
    }

    boolean isNoValidityController() {
        return this.type.getController() == null && this.customizer instanceof Controller;
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddBreakpointPanel.class).getString("ACSD_AddBreakpointPanel"));
        this.setLayout(new GridBagLayout());
        if (this.cathegories.size() > 1) {
            this.jLabel1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(AddBreakpointPanel.class).getString("CTL_Breakpoint_cathegory"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            this.add((Component)this.jLabel1, gridBagConstraints);
            this.cbCathegory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AddBreakpointPanel.this.cbCathegoryActionPerformed(actionEvent);
                }
            });
            this.cbCathegory.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddBreakpointPanel.class).getString("ACSD_CTL_Breakpoint_cathegory"));
            this.jLabel1.setLabelFor(this.cbCathegory);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.cbCathegory, gridBagConstraints);
        }
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AddBreakpointPanel.class).getString("CTL_Breakpoint_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.cbEvents = new JComboBox();
        this.cbEvents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBreakpointPanel.this.cbEventsActionPerformed();
            }
        });
        this.cbEvents.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddBreakpointPanel.class).getString("ACSD_CTL_Breakpoint_type"));
        this.cbEvents.setMaximumRowCount(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cbEvents, gridBagConstraints);
        this.jLabel2.setLabelFor(this.cbEvents);
        this.pEvent = new JPanel();
        this.pEvent.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pEvent, gridBagConstraints);
    }

    private void cbEventsActionPerformed() {
        if (this.doNotRefresh) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = AddBreakpointPanel.this.cbEvents.isPopupVisible();
                int n = AddBreakpointPanel.this.cbEvents.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                AddBreakpointPanel.this.update((BreakpointType)AddBreakpointPanel.this.types.get(n));
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AddBreakpointPanel.this.cbEvents.setPopupVisible(true);
                        }
                    });
                }
            }
        });
    }

    private void cbCathegoryActionPerformed(ActionEvent actionEvent) {
        if (this.doNotRefresh) {
            return;
        }
        String string = (String)this.cbCathegory.getSelectedItem();
        if (string == null) {
            return;
        }
        this.selectCathegory(string);
    }

    private void selectCathegory(String string) {
        lastSelectedCategory = string;
        this.doNotRefresh = true;
        this.cbEvents.removeAllItems();
        this.types = new ArrayList();
        int n = 0;
        for (BreakpointType breakpointType : this.breakpointTypes) {
            if (!breakpointType.getCategoryDisplayName().equals(string)) continue;
            this.cbEvents.addItem(breakpointType.getTypeDisplayName());
            this.types.add(breakpointType);
            if (!breakpointType.isDefault()) continue;
            n = this.cbEvents.getItemCount() - 1;
        }
        this.doNotRefresh = false;
        if (n < this.cbEvents.getItemCount()) {
            this.cbEvents.setSelectedIndex(n);
        }
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    private void update(BreakpointType breakpointType) {
        if (this.type == breakpointType) {
            return;
        }
        this.pEvent.removeAll();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        BreakpointType breakpointType2 = this.type;
        this.type = breakpointType;
        this.customizer = this.type.getCustomizer();
        if (this.customizer == null) {
            return;
        }
        String string = (String)this.customizer.getClientProperty("HelpID_AddBreakpointPanel");
        this.helpCtx = string != null ? new HelpCtx(string) : HelpCtx.findHelp((Component)this.customizer);
        this.pEvent.add((Component)this.customizer, "Center");
        this.pEvent.getAccessibleContext().setAccessibleDescription(this.customizer.getAccessibleContext().getAccessibleDescription());
        this.customizer.getAccessibleContext().setAccessibleName(this.pEvent.getAccessibleContext().getAccessibleName());
        this.revalidate();
        Window window = SwingUtilities.windowForComponent(this);
        if (window == null) {
            return;
        }
        window.pack();
        this.firePropertyChange(PROP_TYPE, breakpointType2, this.type);
    }
}

