/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.HashSet;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    static SearchInfo getSearchInfo(Node node) {
        SearchInfo searchInfo = (SearchInfo)node.getLookup().lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo;
        }
        DataFolder dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (dataFolder == null) {
            return null;
        }
        return SearchInfoFactory.createSearchInfo(dataFolder.getPrimaryFile(), true, new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
    }

    public static Iterator<FileObject> getFileObjectsIterator(SearchInfo searchInfo) {
        if (searchInfo instanceof SearchInfo.Files) {
            return ((SearchInfo.Files)searchInfo).filesToSearch();
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator<DataObject> iterator = searchInfo.objectsToSearch();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().getPrimaryFile());
        }
        return hashSet.iterator();
    }

    static Iterator<DataObject> toDataObjectIterator(Iterator<FileObject> iterator) {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        while (iterator.hasNext()) {
            try {
                hashSet.add(DataObject.find((FileObject)iterator.next()));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
        return hashSet.iterator();
    }
}

