/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppSymbolDemanglerImpl
implements CppSymbolDemangler {
    private static final String ECHO = "echo";
    private static final String DEM = "dem";
    private static final String GCPPFILT = "gc++filt";
    private static final String CPPFILT = "c++filt";
    private static final String EQUALS_EQUALS = " == ";
    private static final int MAX_CMDLINE_LENGTH = 2000;
    private static final Map<String, String> demangledCache = new HashMap<String, String>();
    private static final List<String> searchPaths = new ArrayList<String>();
    private final ExecutionEnvironment env;
    private final CppSymbolDemanglerFactory.CPPCompiler cppCompiler;
    private String demanglerTool;
    private boolean demanglerChecked;

    CppSymbolDemanglerImpl(Map<String, String> map) {
        if (map == null || map.get("GizmoCppCompiler") == null || map.get("GizmoCppCompilerBinPath") == null) {
            Project[] projectArray;
            Project project = OpenProjects.getDefault().getMainProject();
            if (project == null && (projectArray = OpenProjects.getDefault().getOpenProjects()).length == 1) {
                project = projectArray[0];
            }
            projectArray = project == null ? null : (NativeProject)project.getLookup().lookup(NativeProject.class);
            MakeConfiguration makeConfiguration = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
            if (projectArray == null || makeConfiguration == null) {
                this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.GNU;
                this.demanglerTool = GCPPFILT;
                this.env = ExecutionEnvironmentFactory.getLocal();
                return;
            }
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet.getCompilerFlavor().isGnuCompiler()) {
                this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.GNU;
                this.demanglerTool = GCPPFILT;
            } else {
                this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.SS;
                this.demanglerTool = DEM;
            }
            String string = compilerSet.getDirectory();
            if (!searchPaths.contains(string)) {
                searchPaths.add(string);
            }
            this.env = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        } else {
            this.env = ExecutionEnvironmentFactory.fromUniqueID((String)map.get("service.storage.execution.env.key"));
            this.cppCompiler = CppSymbolDemanglerFactory.CPPCompiler.valueOf((String)map.get("GizmoCppCompiler"));
            String string = map.get("GizmoCppCompilerBinPath");
            if (!searchPaths.contains(string)) {
                searchPaths.add(string);
            }
            this.demanglerTool = this.cppCompiler == CppSymbolDemanglerFactory.CPPCompiler.GNU ? GCPPFILT : DEM;
        }
    }

    CppSymbolDemanglerImpl(CppSymbolDemanglerFactory.CPPCompiler cPPCompiler) {
        this.cppCompiler = cPPCompiler;
        this.demanglerTool = cPPCompiler == CppSymbolDemanglerFactory.CPPCompiler.GNU ? GCPPFILT : DEM;
        this.env = ExecutionEnvironmentFactory.getLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String demangle(String string) {
        String string2 = CppSymbolDemanglerImpl.stripModuleAndOffset(string);
        if (!this.isToolAvailable() || !this.isMangled(string2)) {
            return string2;
        }
        String string3 = null;
        Object object = demangledCache;
        synchronized (object) {
            string3 = demangledCache.get(string2);
        }
        if (string3 == null) {
            object = Arrays.asList(string2);
            this.demangleImpl((List<String>)object);
            string3 = (String)object.get(0);
            Map<String, String> map = demangledCache;
            synchronized (map) {
                demangledCache.put(string2, string3);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> demangle(List<String> list) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String object2 : list) {
            arrayList.add(CppSymbolDemanglerImpl.stripModuleAndOffset(object2));
        }
        if (!this.isToolAvailable()) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Map<String, String> map = demangledCache;
        synchronized (map) {
            for (n = 0; n < arrayList.size(); ++n) {
                String n2 = (String)arrayList.get(n);
                if (!this.isMangled(n2)) continue;
                string = demangledCache.get(n2);
                if (string == null) {
                    arrayList2.add(n2);
                    arrayList3.add(n);
                    continue;
                }
                arrayList.set(n, string);
            }
        }
        if (!arrayList2.isEmpty()) {
            this.splitAndDemangle(arrayList2);
            map = demangledCache;
            synchronized (map) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    int n2 = (Integer)arrayList3.get(n);
                    string = (String)arrayList.get(n2);
                    String string2 = (String)arrayList2.get(n);
                    demangledCache.put(string, string2);
                    arrayList.set(n2, string2);
                }
            }
        }
        return arrayList;
    }

    private boolean isMangled(String string) {
        return 0 < string.length() && string.charAt(0) == '_' || 0 <= string.indexOf("__");
    }

    private static String stripModuleAndOffset(String string) {
        int n;
        int n2 = string.indexOf("+0x");
        if (0 <= n2) {
            string = string.substring(0, n2);
        }
        if (0 <= (n = string.indexOf(96))) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void splitAndDemangle(List<String> list) {
        if (this.demanglerTool == null) {
            return;
        }
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string;
            int n = listIterator.nextIndex();
            for (int i = ECHO.length() + this.demanglerTool.length(); listIterator.hasNext() && i < 2000; i += string.length() + 3) {
                string = listIterator.next();
            }
            int n2 = listIterator.nextIndex();
            List<String> list2 = list.subList(n, n2);
            this.demangleImpl(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void demangleImpl(List<String> list) {
        Object object;
        this.checkDemanglerIfNeeded();
        if (this.demanglerTool == null) {
            return;
        }
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
        if (this.demanglerTool.indexOf(GCPPFILT) >= 0 || this.demanglerTool.indexOf(CPPFILT) >= 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append(ECHO).append(" \"");
            for (String object2 : list) {
                ((StringBuilder)object).append(object2).append('\n');
            }
            ((StringBuilder)object).append("\" | ").append(this.demanglerTool);
            nativeProcessBuilder.setCommandLine(((StringBuilder)object).toString());
        } else {
            nativeProcessBuilder.setExecutable(this.demanglerTool);
            nativeProcessBuilder.setArguments(list.toArray(new String[list.size()]));
        }
        try {
            object = DLightExecutorService.submit((Callable)nativeProcessBuilder, (String)"CPPSymbolDemangler call");
            NativeProcess nativeProcess = (NativeProcess)object.get();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
            try {
                ListIterator<String> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    int n;
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        break;
                    }
                    if (string.length() == 0) continue;
                    listIterator.next();
                    if (this.cppCompiler == CppSymbolDemanglerFactory.CPPCompiler.SS && 0 <= (n = string.indexOf(EQUALS_EQUALS))) {
                        string = string.substring(n + EQUALS_EQUALS.length());
                    }
                    listIterator.set(string);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private synchronized void checkDemanglerIfNeeded() {
        if (!this.demanglerChecked) {
            String string;
            String string2 = HostInfoUtils.searchFile((ExecutionEnvironment)this.env, searchPaths, (String)this.demanglerTool, (boolean)true);
            this.demanglerTool = string2 == null ? ((string2 = HostInfoUtils.searchFile((ExecutionEnvironment)this.env, searchPaths, (String)(string = CPPFILT), (boolean)true)) == null ? null : string2) : string2;
            this.demanglerChecked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Map<String, String> map = demangledCache;
        synchronized (map) {
            demangledCache.clear();
        }
    }

    boolean isToolAvailable() {
        this.checkDemanglerIfNeeded();
        return this.demanglerTool != null;
    }
}

