/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.JavaPlatformSupport;
import org.netbeans.modules.projectimport.eclipse.core.ProjectFactory;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseProjectReference {
    private Project project;
    private final File eclipseProjectLocation;
    private final File eclipseWorkspaceLocation;
    private long timestamp;
    private String key;
    private boolean initialized;
    private EclipseProject eclipseProject;
    private ProjectImportModel importModel;
    private static final String PROJECT_PREFIX = "project-";
    private static final String WORKSPACE_PREFIX = "workspace-";

    public EclipseProjectReference(Project project, String string, String string2, long l, String string3) {
        this.eclipseProjectLocation = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string);
        this.eclipseWorkspaceLocation = string2 != null ? PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string2) : null;
        this.timestamp = l;
        this.key = string3;
        this.project = project;
    }

    Project getProject() {
        return this.project;
    }

    public File getEclipseProjectLocation() {
        return this.eclipseProjectLocation;
    }

    public File getEclipseWorkspaceLocation() {
        return this.eclipseWorkspaceLocation;
    }

    File getFallbackEclipseProjectLocation() {
        String string = EclipseProjectReference.getPreferences().get(PROJECT_PREFIX + this.getEclipseProjectLocation().getPath(), null);
        if (string != null) {
            return new File(string);
        }
        return this.getEclipseProjectLocation();
    }

    File getFallbackWorkspaceProjectLocation() {
        if (this.eclipseWorkspaceLocation == null) {
            return null;
        }
        String string = EclipseProjectReference.getPreferences().get(WORKSPACE_PREFIX + this.getEclipseWorkspaceLocation().getPath(), null);
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return this.getEclipseWorkspaceLocation();
    }

    void updateReference(String string, String string2) {
        if (string != null) {
            EclipseProjectReference.getPreferences().put(PROJECT_PREFIX + this.getEclipseProjectLocation().getPath(), string);
        }
        if (string2 != null) {
            EclipseProjectReference.getPreferences().put(WORKSPACE_PREFIX + this.getEclipseWorkspaceLocation().getPath(), string2);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(EclipseProjectReference.class);
    }

    public static EclipseProjectReference read(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, EclipseProjectReference.class, (boolean)true);
        String string = preferences.get("project", null);
        if (string == null) {
            return null;
        }
        return new EclipseProjectReference(project, string, preferences.get("workspace", null), Long.parseLong(preferences.get("timestamp", null)), preferences.get("key", null));
    }

    public static void write(Project project, EclipseProjectReference eclipseProjectReference) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, EclipseProjectReference.class, (boolean)true);
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        if (CollocationQuery.areCollocated((File)file, (File)eclipseProjectReference.eclipseProjectLocation)) {
            preferences.put("project", PropertyUtils.relativizeFile((File)file, (File)eclipseProjectReference.eclipseProjectLocation));
        } else {
            preferences.put("project", eclipseProjectReference.eclipseProjectLocation.getPath());
        }
        if (eclipseProjectReference.eclipseWorkspaceLocation != null) {
            if (CollocationQuery.areCollocated((File)file, (File)eclipseProjectReference.eclipseWorkspaceLocation)) {
                preferences.put("workspace", PropertyUtils.relativizeFile((File)file, (File)eclipseProjectReference.eclipseWorkspaceLocation));
            } else {
                preferences.put("workspace", eclipseProjectReference.eclipseWorkspaceLocation.getPath());
            }
        }
        preferences.put("timestamp", Long.toString(eclipseProjectReference.getCurrentTimestamp()));
        preferences.put("key", eclipseProjectReference.key);
    }

    public boolean isUpToDate(boolean bl) {
        if (this.getCurrentTimestamp() > this.timestamp) {
            return false;
        }
        if (!bl) {
            return true;
        }
        EclipseProject eclipseProject = this.getEclipseProject(true);
        if (eclipseProject == null) {
            return true;
        }
        if (!(eclipseProject.getProjectTypeFactory() instanceof ProjectTypeUpdater)) assert (false) : "project with <eclipse> data in project.xml is upgradable: " + this.project.getProjectDirectory() + " " + eclipseProject.getProjectTypeFactory().getClass().getName();
        ProjectTypeUpdater projectTypeUpdater = (ProjectTypeUpdater)eclipseProject.getProjectTypeFactory();
        return this.key.equals(projectTypeUpdater.calculateKey(this.importModel));
    }

    void update(List<String> list) throws IOException {
        EclipseProject eclipseProject = this.getEclipseProject(true);
        if (eclipseProject == null) {
            return;
        }
        ProjectTypeFactory projectTypeFactory = eclipseProject.getProjectTypeFactory();
        if (!(projectTypeFactory instanceof ProjectTypeUpdater)) {
            assert (false) : "project with <eclipse> data in project.xml is upgradable";
            return;
        }
        eclipseProject.resolveContainers(list, true);
        eclipseProject.setupEnvironmentVariables(list);
        this.key = ((ProjectTypeUpdater)projectTypeFactory).update(this.project, this.importModel, this.key, list);
        EclipseProjectReference.write(this.project, this);
    }

    private long getCurrentTimestamp() {
        File file = new File(this.getFallbackEclipseProjectLocation(), ".classpath");
        File file2 = new File(this.getFallbackEclipseProjectLocation(), ".project");
        return Math.max(file.lastModified(), file2.lastModified());
    }

    boolean isEclipseProjectReachable() {
        boolean bl;
        boolean bl2 = bl = EclipseUtils.isRegularProject(this.eclipseProjectLocation) && (this.eclipseWorkspaceLocation == null || this.eclipseWorkspaceLocation != null && EclipseUtils.isRegularWorkSpace(this.eclipseWorkspaceLocation));
        if (bl) {
            EclipseProjectReference.getPreferences().remove(PROJECT_PREFIX + this.eclipseProjectLocation.getPath());
            if (this.eclipseWorkspaceLocation != null) {
                EclipseProjectReference.getPreferences().remove(WORKSPACE_PREFIX + this.eclipseWorkspaceLocation.getPath());
            }
            return true;
        }
        return EclipseUtils.isRegularProject(this.getFallbackEclipseProjectLocation()) && (this.eclipseWorkspaceLocation == null || this.eclipseWorkspaceLocation != null && EclipseUtils.isRegularWorkSpace(this.getFallbackWorkspaceProjectLocation()));
    }

    public EclipseProject getEclipseProject(boolean bl) {
        if (bl || !this.initialized) {
            Comparable comparable;
            try {
                comparable = null;
                if (this.getFallbackWorkspaceProjectLocation() != null) {
                    Workspace workspace = WorkspaceFactory.getInstance().load(this.getFallbackWorkspaceProjectLocation());
                    comparable = workspace.getProjectByProjectDir(this.getFallbackEclipseProjectLocation());
                }
                if (comparable == null) {
                    comparable = ProjectFactory.getInstance().load(this.getFallbackEclipseProjectLocation(), this.getFallbackWorkspaceProjectLocation());
                }
                this.eclipseProject = comparable;
            }
            catch (ProjectImporterException projectImporterException) {
                Exceptions.printStackTrace((Throwable)projectImporterException);
                this.eclipseProject = null;
                this.initialized = true;
                return null;
            }
            comparable = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.importModel = new ProjectImportModel(this.eclipseProject, (File)comparable, JavaPlatformSupport.getJavaPlatformSupport().getJavaPlatform(this.eclipseProject, new ArrayList<String>()), Collections.<Project>emptyList());
            this.initialized = true;
        }
        return this.eclipseProject;
    }
}

