/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.jsp;

import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class JspI18nSupport
extends JavaI18nSupport {
    public JspI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new JspI18nFinder(this.document);
    }

    public boolean hasAdditionalCustomizer() {
        return false;
    }

    public JPanel getAdditionalCustomizer() {
        return null;
    }

    public void performAdditionalChanges() {
    }

    public static class Factory
    extends I18nSupport.Factory {
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JspI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.web.core.jsploader.JspDataObject", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static class JspI18nFinder
    extends JavaI18nFinder {
        protected static final int STATE_JSP = 8;
        protected static final int STATE_JSP_START_SCRIPTING = 9;
        protected static final int STATE_JSP_SCRIPTING = 10;
        protected static final int STATE_JSP_END_SCRIPTING = 11;
        private static final String[] jspStrings = new String[]{"jsp:declaration", "jsp:expression", "jsp:scriptlet"};
        private int oldJavaState;

        public JspI18nFinder(StyledDocument styledDocument) {
            super(styledDocument);
            this.state = 8;
        }

        protected void reset() {
            super.reset();
            this.state = 8;
        }

        protected HardCodedString handleCharacter(char c) {
            if (this.state == 8) {
                return this.handleStateJsp(c);
            }
            if (this.state == 9) {
                return this.handleStateJspStartScripting(c);
            }
            if (this.state == 10) {
                return this.handleStateJspScripting(c);
            }
            if (this.state == 11) {
                return this.handleStateJspEndScripting(c);
            }
            if (c == '%') {
                this.oldJavaState = this.state = 11;
                return null;
            }
            if (c == '<') {
                for (int i = 0; i < jspStrings.length; ++i) {
                    if (!this.isNextString("</" + jspStrings[i] + ">")) continue;
                    this.position += jspStrings[i].length() + 2;
                    this.state = 8;
                    return null;
                }
            }
            return super.handleCharacter(c);
        }

        protected HardCodedString handleStateJsp(char c) {
            if (c == '<') {
                this.state = 9;
            }
            return null;
        }

        protected HardCodedString handleStateJspStartScripting(char c) {
            if (c == '%') {
                this.state = 10;
            } else if (c == 'j') {
                for (int i = 0; i < jspStrings.length; ++i) {
                    if (!this.isNextString(jspStrings[i] + ">")) continue;
                    this.position += jspStrings[i].length();
                    this.state = 0;
                }
            } else {
                this.state = 8;
            }
            return null;
        }

        private boolean isNextString(String string) {
            if (this.buffer.length < this.position + string.length()) {
                return false;
            }
            try {
                if (string.equals(this.document.getText(this.position, string.length()))) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        protected HardCodedString handleStateJspScripting(char c) {
            this.state = c == '@' || c == '-' ? 8 : 0;
            return null;
        }

        protected HardCodedString handleStateJspEndScripting(char c) {
            this.state = c == '>' ? 8 : this.oldJavaState;
            return null;
        }
    }
}

