/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Dialog;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nManager;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class InsertI18nStringAction
extends CookieAction {
    static final long serialVersionUID = -7002111874047983222L;
    private transient Position position;
    private transient I18nSupport support;
    private transient I18nPanel i18nPanel;
    private transient DataObject dataObject;

    public InsertI18nStringAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodeArray) {
        try {
            EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
            if (editorCookie == null) {
                Util.debug(new IllegalArgumentException("Missing editor cookie!"));
                return;
            }
            this.dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
            if (this.dataObject == null) {
                Util.debug(new IllegalArgumentException("Missing DataObject!"));
                return;
            }
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
                Util.debug(new IllegalArgumentException("Missing editor pane!"));
                return;
            }
            this.position = NbDocument.createPosition((Document)jEditorPaneArray[0].getDocument(), (int)jEditorPaneArray[0].getCaret().getDot(), (Position.Bias)Position.Bias.Backward);
            I18nManager.getDefault().cancel();
            try {
                this.showModalPanel();
            }
            catch (IOException iOException) {
                String string = "Document loading failure " + this.dataObject.getName();
                Util.debug(string, iOException);
                this.dataObject = null;
                this.support = null;
                this.i18nPanel = null;
                this.position = null;
                return;
            }
            jEditorPaneArray[0].getCaret().setVisible(true);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        finally {
            this.dataObject = null;
            this.support = null;
            this.i18nPanel = null;
            this.position = null;
        }
    }

    private void insertI18nString() {
        try {
            I18nString i18nString = this.i18nPanel.getI18nString();
            if (i18nString.key == null || "".equals(i18nString.key)) {
                return;
            }
            this.support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
            if (this.support.hasAdditionalCustomizer()) {
                this.support.performAdditionalChanges();
            }
            String string = i18nString.getReplaceString();
            this.support.getDocument().insertString(this.position.getOffset(), string, null);
        }
        catch (IllegalStateException illegalStateException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("EXC_BadKey"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        catch (BadLocationException badLocationException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CantInsertInGuarded"), 1));
        }
    }

    private JPanel createPanel() throws IOException {
        I18nSupport.Factory factory = FactoryRegistry.getFactory(this.dataObject.getClass());
        if (factory == null) {
            throw new IllegalStateException("I18N: No factory registered for data object type=" + this.dataObject.getClass().getName());
        }
        this.support = factory.create(this.dataObject);
        this.i18nPanel = new I18nPanel(this.support.getPropertyPanel(), false, Util.getProjectFor(this.dataObject), this.dataObject.getPrimaryFile());
        this.i18nPanel.setI18nString(this.support.getDefaultI18nString());
        this.i18nPanel.setDefaultResource(this.dataObject);
        return this.i18nPanel;
    }

    private void showModalPanel() throws IOException {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.createPanel(), Util.getString("CTL_InsertI18nDialogTitle"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(InsertI18nStringAction.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            this.insertI18nString();
        }
    }

    protected boolean enable(Node[] nodeArray) {
        if (!super.enable(nodeArray)) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        if (FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()) == null) {
            return false;
        }
        if (!FactoryRegistry.hasFactory(dataObject.getClass())) {
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        return jEditorPaneArray != null && jEditorPaneArray.length > 0;
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    public String getName() {
        return I18nUtil.getBundle().getString("CTL_InsertI18nString");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.maninsert");
    }

    protected boolean asynchronous() {
        return false;
    }
}

