/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSyncActions {
    private static UploadAction uploadAction;
    private static DownloadAction downloadAction;
    private static final AtomicReference<Node[]> activatedNodesCache;
    private static final RequestProcessor.Task clearCacheTask;

    private RemoteSyncActions() {
    }

    public static Action createUploadAction() {
        if (uploadAction == null) {
            uploadAction = new UploadAction();
        }
        return uploadAction;
    }

    public static Action createDownloadAction() {
        if (downloadAction == null) {
            downloadAction = new DownloadAction();
        }
        return downloadAction;
    }

    private static void cacheActiveNodes(Node[] nodeArray) {
        activatedNodesCache.set(nodeArray);
        clearCacheTask.schedule(5000);
    }

    private static ExecutionEnvironment getEnv(Node[] nodeArray) {
        ExecutionEnvironment executionEnvironment = null;
        for (Node node : nodeArray) {
            Project project = RemoteSyncActions.getNodeProject(node);
            ExecutionEnvironment executionEnvironment2 = RemoteSyncActions.getEnv(project);
            if (executionEnvironment2 == null) continue;
            if (executionEnvironment == null) {
                executionEnvironment = executionEnvironment2;
                continue;
            }
            if (executionEnvironment.equals(executionEnvironment2)) continue;
            return null;
        }
        return executionEnvironment;
    }

    private static ExecutionEnvironment getEnv(Project project) {
        ExecutionEnvironment executionEnvironment;
        RemoteProject remoteProject;
        ExecutionEnvironment executionEnvironment2 = CompilerSetManager.getDefaultExecutionEnvironment();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (executionEnvironment = remoteProject.getDevelopmentHost()) != null) {
            executionEnvironment2 = executionEnvironment;
        }
        return executionEnvironment2;
    }

    private static Project getNodeProject(Node node) {
        if (node == null) {
            return null;
        }
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            return project;
        }
        return RemoteSyncActions.getNodeProject(node.getParentNode());
    }

    private static InputOutput getTab(String string, boolean bl) {
        InputOutput inputOutput;
        if (bl) {
            inputOutput = IOProvider.getDefault().getIO(string, false);
            inputOutput.closeInputOutput();
        }
        inputOutput = IOProvider.getDefault().getIO(string, true);
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputOutput.select();
        return inputOutput;
    }

    private static void upload(ExecutionEnvironment executionEnvironment, Node[] nodeArray) {
        InputOutput inputOutput = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadTab_Name", (Object)executionEnvironment), true);
        Uploader uploader = new Uploader(executionEnvironment, nodeArray, inputOutput);
        uploader.work();
    }

    private static void download(ExecutionEnvironment executionEnvironment, Node[] nodeArray) {
        InputOutput inputOutput = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadTab_Name", (Object)executionEnvironment), true);
        Downloader downloader = new Downloader(executionEnvironment, nodeArray, inputOutput);
        downloader.work();
    }

    private static Map<Project, Collection<File>> gatherFiles(Node[] nodeArray) {
        HashMap<Project, Collection<File>> hashMap = new HashMap<Project, Collection<File>>();
        for (Node node : nodeArray) {
            Project project = RemoteSyncActions.getNodeProject(node);
            ArrayList arrayList = (ArrayList)hashMap.get(project);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(project, arrayList);
            }
            RemoteSyncActions.gatherFiles((Collection<File>)arrayList, node);
        }
        return hashMap;
    }

    private static void gatherFiles(Collection<File> collection, Node node) {
        File file;
        Object object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null && (object = dataObject.getPrimaryFile()) != null && !(file = FileUtil.toFile((FileObject)object)).isDirectory()) {
            collection.add(file);
        }
        if ((object = (Folder)node.getLookup().lookup(Folder.class)) != null) {
            RemoteSyncActions.gatherFiles(collection, (Folder)object);
        }
    }

    private static void gatherFiles(Collection<File> collection, Folder folder) {
        for (Item item : folder.getItemsAsArray()) {
            File file = item.getFile();
            if (file == null || file.isDirectory()) continue;
            collection.add(file);
        }
        for (Folder folder2 : folder.getFolders()) {
            RemoteSyncActions.gatherFiles(collection, folder2);
        }
    }

    static {
        activatedNodesCache = new AtomicReference();
        clearCacheTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                activatedNodesCache.set(null);
            }
        });
    }

    private static class DownloadAction
    extends BaseAction {
        private DownloadAction() {
        }

        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_0");
        }

        protected String getItemText(String string) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_1", (Object)string);
        }

        protected void performAction(final ExecutionEnvironment executionEnvironment, final Node[] nodeArray) {
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)executionEnvironment).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.download(executionEnvironment, nodeArray);
                }
            });
        }
    }

    private static class UploadAction
    extends BaseAction {
        private UploadAction() {
        }

        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_0");
        }

        protected String getItemText(String string) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_1", (Object)string);
        }

        protected void performAction(final ExecutionEnvironment executionEnvironment, final Node[] nodeArray) {
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)executionEnvironment).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.upload(executionEnvironment, nodeArray);
                }
            });
        }
    }

    private static abstract class BaseAction
    extends NodeAction {
        private boolean enabled;

        private BaseAction() {
        }

        protected abstract void performAction(ExecutionEnvironment var1, Node[] var2);

        protected abstract String getDummyItemText();

        protected abstract String getItemText(String var1);

        protected boolean enable(Node[] nodeArray) {
            RemoteSyncActions.cacheActiveNodes(nodeArray);
            ExecutionEnvironment executionEnvironment = RemoteSyncActions.getEnv(nodeArray);
            this.enabled = executionEnvironment != null && executionEnvironment.isRemote();
            return this.enabled;
        }

        protected boolean wasEnabled() {
            return this.enabled;
        }

        protected void performAction(Node[] nodeArray) {
            ExecutionEnvironment executionEnvironment = RemoteSyncActions.getEnv(nodeArray);
            if (executionEnvironment != null && executionEnvironment.isRemote()) {
                this.performAction(executionEnvironment, nodeArray);
            }
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public String getName() {
            if (!this.wasEnabled()) {
                return this.getDummyItemText();
            }
            Node[] nodeArray = (Node[])activatedNodesCache.get();
            if (nodeArray == null || nodeArray.length == 0) {
                return this.getDummyItemText();
            }
            ExecutionEnvironment executionEnvironment = RemoteSyncActions.getEnv(nodeArray);
            if (executionEnvironment == null || executionEnvironment.isLocal()) {
                return this.getDummyItemText();
            }
            String string = ServerList.get((ExecutionEnvironment)executionEnvironment).getDisplayName();
            return this.getItemText(string);
        }
    }

    private static class Downloader
    extends UpDownLoader {
        public Downloader(ExecutionEnvironment executionEnvironment, Node[] nodeArray, InputOutput inputOutput) {
            super(executionEnvironment, nodeArray, inputOutput);
        }

        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_DOWNLOAD_FILE", (Object)file.getAbsolutePath());
        }

        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_DOWNLOAD", (Object)this.envName);
        }

        protected RemoteSyncSupport.Worker createWorker(Project project, final ExecutionEnvironment executionEnvironment) {
            return new RemoteSyncSupport.Worker(){
                private final PathMap pathMap;
                {
                    this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
                }

                public void process(File file, Writer writer) throws RemoteSyncSupport.PathMapperException, InterruptedException, ExecutionException, IOException {
                    String string = this.pathMap.getRemotePath(file.getAbsolutePath(), false);
                    if (string == null) {
                        throw new RemoteSyncSupport.PathMapperException(file);
                    }
                    Future future = CommonTasksSupport.downloadFile((String)string, (ExecutionEnvironment)executionEnvironment, (String)file.getAbsolutePath(), (Writer)writer);
                    int n = (Integer)future.get();
                    if (n != 0) {
                        throw new IOException(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_RC", (Object)n));
                    }
                }

                public void close() {
                }
            };
        }
    }

    private static class Uploader
    extends UpDownLoader {
        public Uploader(ExecutionEnvironment executionEnvironment, Node[] nodeArray, InputOutput inputOutput) {
            super(executionEnvironment, nodeArray, inputOutput);
        }

        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_UPLOAD_FILE", (Object)file.getAbsolutePath());
        }

        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_UPLOAD", (Object)this.envName);
        }

        protected RemoteSyncSupport.Worker createWorker(Project project, ExecutionEnvironment executionEnvironment) {
            return RemoteSyncSupport.createUploader((Project)project, (ExecutionEnvironment)executionEnvironment);
        }
    }

    private static abstract class UpDownLoader
    implements Cancellable {
        protected final ExecutionEnvironment execEnv;
        protected final String envName;
        protected final InputOutput tab;
        private boolean cancelled = false;
        private final Node[] nodes;
        private volatile Thread workingThread;

        public UpDownLoader(ExecutionEnvironment executionEnvironment, Node[] nodeArray, InputOutput inputOutput) {
            this.execEnv = executionEnvironment;
            this.nodes = nodeArray;
            this.tab = inputOutput;
            this.envName = ServerList.get((ExecutionEnvironment)executionEnvironment).getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work() {
            this.workingThread = Thread.currentThread();
            String string = this.getProgressTitle();
            this.tab.getOut().println(string);
            long l = System.currentTimeMillis();
            int n = 0;
            int n2 = 0;
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)this);
            progressHandle.start();
            try {
                if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    ConnectionManager.getInstance().connectTo(this.execEnv);
                }
                Map map = RemoteSyncActions.gatherFiles(this.nodes);
                int n3 = 0;
                int n4 = 0;
                for (Collection object : map.values()) {
                    n4 += object.size();
                }
                progressHandle.switchToDeterminate(n4);
                block19: for (Map.Entry entry : map.entrySet()) {
                    RemoteSyncSupport.Worker worker = this.createWorker((Project)entry.getKey(), this.execEnv);
                    try {
                        for (File file : (Collection)entry.getValue()) {
                            if (this.cancelled) continue block19;
                            String string2 = this.getFileProgressMessage(file);
                            this.tab.getOut().println(string2);
                            try {
                                worker.process(file, (Writer)this.tab.getErr());
                                ++n2;
                            }
                            catch (InterruptedException iOException) {
                                continue block19;
                            }
                            catch (ExecutionException executionException) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)executionException.getMessage()));
                                ++n;
                            }
                            catch (IOException iOException) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)iOException.getMessage()));
                                ++n;
                            }
                            progressHandle.progress(string2, n3++);
                        }
                    }
                    finally {
                        worker.close();
                    }
                }
            }
            catch (RemoteSyncSupport.PathMapperException pathMapperException) {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_MAPPING", (Object)pathMapperException.getFile().getAbsolutePath()));
            }
            catch (CancellationException cancellationException) {
                this.cancelled = true;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.cancelled = true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                progressHandle.finish();
            }
            this.workingThread = null;
            l = System.currentTimeMillis() - l;
            if (n == 0) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_SUCCESS", (Object)n2));
            } else if (this.cancelled) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_CANCELLED", (Object)n2));
            } else {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_ERROR", (Object)n2));
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            Thread thread = this.workingThread;
            if (thread != null) {
                thread.interrupt();
            }
            return true;
        }

        protected abstract String getProgressTitle();

        protected abstract String getFileProgressMessage(File var1);

        protected abstract RemoteSyncSupport.Worker createWorker(Project var1, ExecutionEnvironment var2);
    }
}

