/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.actions.BuildToolsAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.ValidateInstrumentationProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.ui.options.LocalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeActionProvider
implements ActionProvider {
    public static final String COMMAND_BATCH_BUILD = "batch_build";
    public static final String COMMAND_BUILD_PACKAGE = "build_packages";
    public static final String COMMAND_DEBUG_LOAD_ONLY = "debug.load.only";
    public static final String COMMAND_CUSTOM_ACTION = "custom.action";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.stepinto", "debug.load.only", "debug.single", "batch_build", "build_packages", "delete", "copy", "move", "rename", "custom.action"};
    MakeProject project;
    MakeConfigurationDescriptor projectDescriptor = null;
    Map<String, String[]> commands = new HashMap<String, String[]>();
    Map<String, String[]> commandsNoBuild;
    private boolean lastValidation = false;
    private static final String SAVE_STEP = "save";
    private static final String BUILD_STEP = "build";
    private static final String BUILD_PACKAGE_STEP = "build-package";
    private static final String CLEAN_STEP = "clean";
    private static final String RUN_STEP = "run";
    private static final String DEBUG_STEP = "debug";
    private static final String DEBUG_STEPINTO_STEP = "debug-stepinto";
    private static final String DEBUG_LOAD_ONLY_STEP = "debug-load-only";
    private static final String RUN_SINGLE_STEP = "run-single";
    private static final String DEBUG_SINGLE_STEP = "debug-single";
    private static final String COMPILE_SINGLE_STEP = "compile-single";
    private static final String CUSTOM_ACTION_STEP = "custom-action";
    private static final String REMOVE_INSTRUMENTATION_STEP = "remove-instrumentation";
    private static final String CONFIGURE_STEP = "configure";
    public static final boolean useRsync = Boolean.getBoolean("cnd.remote.useRsync");
    public static final String REMOTE_BASE_PATH = "~/NetBeansProjects/remote";
    private static Map<String, Boolean> fileExistenceCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> validExecutablesCache = new HashMap<String, Boolean>();

    public MakeActionProvider(MakeProject makeProject) {
        this.commands.put(BUILD_STEP, new String[]{SAVE_STEP, BUILD_STEP});
        this.commands.put(COMMAND_BUILD_PACKAGE, new String[]{SAVE_STEP, BUILD_STEP, BUILD_PACKAGE_STEP});
        this.commands.put(CLEAN_STEP, new String[]{SAVE_STEP, CLEAN_STEP});
        this.commands.put("rebuild", new String[]{SAVE_STEP, CLEAN_STEP, BUILD_STEP});
        this.commands.put(RUN_STEP, new String[]{SAVE_STEP, REMOVE_INSTRUMENTATION_STEP, BUILD_STEP, RUN_STEP});
        this.commands.put(DEBUG_STEP, new String[]{SAVE_STEP, REMOVE_INSTRUMENTATION_STEP, BUILD_STEP, DEBUG_STEP});
        this.commands.put("debug.stepinto", new String[]{SAVE_STEP, REMOVE_INSTRUMENTATION_STEP, BUILD_STEP, DEBUG_STEPINTO_STEP});
        this.commands.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{SAVE_STEP, BUILD_STEP, DEBUG_LOAD_ONLY_STEP});
        this.commands.put("run.single", new String[]{RUN_SINGLE_STEP});
        this.commands.put("debug.single", new String[]{DEBUG_SINGLE_STEP});
        this.commands.put("compile.single", new String[]{SAVE_STEP, COMPILE_SINGLE_STEP});
        this.commands.put(COMMAND_CUSTOM_ACTION, new String[]{SAVE_STEP, BUILD_STEP, CUSTOM_ACTION_STEP});
        this.commandsNoBuild = new HashMap<String, String[]>();
        this.commandsNoBuild.put(BUILD_STEP, new String[]{SAVE_STEP, BUILD_PACKAGE_STEP});
        this.commandsNoBuild.put(COMMAND_BUILD_PACKAGE, new String[]{SAVE_STEP, BUILD_STEP});
        this.commandsNoBuild.put(CLEAN_STEP, new String[]{SAVE_STEP, CLEAN_STEP});
        this.commandsNoBuild.put("rebuild", new String[]{SAVE_STEP, CLEAN_STEP, BUILD_STEP});
        this.commandsNoBuild.put(RUN_STEP, new String[]{REMOVE_INSTRUMENTATION_STEP, RUN_STEP});
        this.commandsNoBuild.put(DEBUG_STEP, new String[]{REMOVE_INSTRUMENTATION_STEP, DEBUG_STEP});
        this.commandsNoBuild.put("debug.stepinto", new String[]{REMOVE_INSTRUMENTATION_STEP, DEBUG_STEPINTO_STEP});
        this.commandsNoBuild.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{DEBUG_LOAD_ONLY_STEP});
        this.commandsNoBuild.put(COMMAND_CUSTOM_ACTION, new String[]{SAVE_STEP, CUSTOM_ACTION_STEP});
        this.project = makeProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean isProjectDescriptorLoaded() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            return configurationDescriptorProvider.gotDescriptor();
        }
        return true;
    }

    private MakeConfigurationDescriptor getProjectDescriptor() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.projectDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        }
        return this.projectDescriptor;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(String object, Lookup lookup) throws IllegalArgumentException {
        Object object2;
        Object object3;
        if ("delete".equals(object)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(object)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(object)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(object)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("run.single".equals(object)) {
            Node node = (Node)lookup.lookup(Node.class);
            if (node != null) {
                ShellRunAction.performAction((Node)node);
            }
            return;
        }
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        final String string = projectInformation.getDisplayName();
        final MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
        MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
        if (makeConfiguration == null) {
            return;
        }
        final ArrayList<MakeConfiguration> arrayList = new ArrayList<MakeConfiguration>();
        if (((String)object).equals(COMMAND_BATCH_BUILD)) {
            object3 = new BatchConfigurationSelector(this.project, makeConfigurationDescriptor.getConfs().getConfs());
            object2 = ((BatchConfigurationSelector)object3).getCommand();
            Configuration[] configurationArray = ((BatchConfigurationSelector)object3).getSelectedConfs();
            if (object2 == null || configurationArray == null || configurationArray.length == 0) {
                return;
            }
            object = object2;
            for (Configuration configuration : configurationArray) {
                arrayList.add((MakeConfiguration)configuration);
            }
        } else {
            arrayList.add(makeConfiguration);
        }
        object3 = object;
        object2 = new CancellableTask((String)object3, lookup){
            final /* synthetic */ String val$finalCommand;
            final /* synthetic */ Lookup val$context;
            {
                this.val$finalCommand = string2;
                this.val$context = lookup;
            }

            protected void runImpl() {
                ArrayList<ProjectActionEvent> arrayList2 = new ArrayList<ProjectActionEvent>();
                for (MakeConfiguration makeConfiguration : arrayList) {
                    MakeActionProvider.this.addAction(arrayList2, string, makeConfigurationDescriptor, makeConfiguration, this.val$finalCommand, this.val$context, this.cancelled);
                }
                if (arrayList2.size() > 0 && !this.cancelled.get()) {
                    ProjectActionSupport.getInstance().fireActionPerformed(arrayList2.toArray(new ProjectActionEvent[arrayList2.size()]));
                }
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), (CancellableTask)object2);
    }

    private static void runActionWorker(ExecutionEnvironment executionEnvironment, CancellableTask cancellableTask) {
        if (executionEnvironment.isLocal()) {
            cancellableTask.run();
        } else {
            ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
            assert (serverRecord != null);
            MakeActionProvider.invokeRemoteHostAction(serverRecord, cancellableTask);
        }
    }

    public void invokeCustomAction(final String string, final MakeConfigurationDescriptor makeConfigurationDescriptor, final MakeConfiguration makeConfiguration, final ProjectActionHandler projectActionHandler) {
        CancellableTask cancellableTask = new CancellableTask(){

            protected void runImpl() {
                ArrayList<ProjectActionEvent> arrayList = new ArrayList<ProjectActionEvent>();
                MakeActionProvider.this.addAction(arrayList, string, makeConfigurationDescriptor, makeConfiguration, MakeActionProvider.COMMAND_CUSTOM_ACTION, null, this.cancelled);
                ProjectActionSupport.getInstance().fireActionPerformed(arrayList.toArray(new ProjectActionEvent[arrayList.size()]), projectActionHandler);
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), cancellableTask);
    }

    private static void invokeRemoteHostAction(final ServerRecord serverRecord, final CancellableTask cancellableTask) {
        Object object;
        CancellableTask cancellableTask2;
        if (!serverRecord.isDeleted() && serverRecord.isOnline()) {
            cancellableTask2 = cancellableTask;
        } else {
            if (serverRecord.isDeleted()) {
                object = MessageFormat.format(MakeActionProvider.getString("ERR_RequestingDeletedConnection"), serverRecord.getDisplayName());
                int n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), object, MakeActionProvider.getString("DLG_TITLE_DeletedConnection"), 0);
                if (n == 0) {
                    ServerList.addServer((ExecutionEnvironment)serverRecord.getExecutionEnvironment(), (String)serverRecord.getDisplayName(), (RemoteSyncFactory)serverRecord.getSyncFactory(), (boolean)false, (boolean)true);
                } else {
                    return;
                }
            }
            cancellableTask2 = new CancellableTask(){

                public boolean cancel() {
                    return cancellableTask.cancel();
                }

                public void runImpl() {
                    try {
                        if (!ConnectionManager.getInstance().isConnectedTo(serverRecord.getExecutionEnvironment())) {
                            ConnectionManager.getInstance().connectTo(serverRecord.getExecutionEnvironment());
                        }
                        serverRecord.validate(true);
                        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)serverRecord.getExecutionEnvironment());
                        compilerSetManager.initialize(true, true);
                    }
                    catch (CancellationException cancellationException) {
                        this.cancel();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        final String string = MessageFormat.format(MakeActionProvider.getString("ERR_Cant_Connect"), serverRecord.getDisplayName());
                        final String string2 = MakeActionProvider.getString("DLG_TITLE_Cant_Connect");
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), string, string2, 0);
                            }
                        });
                    }
                    if (serverRecord.isOnline()) {
                        cancellableTask.run();
                    }
                }
            };
        }
        object = WindowManager.getDefault().getMainWindow();
        String string = NbBundle.getMessage(MakeActionProvider.class, (String)"MSG_Validate_Host", (Object)serverRecord.getDisplayName());
        String string2 = NbBundle.getMessage(MakeActionProvider.class, (String)"DLG_TITLE_Validate_Host");
        ModalMessageDlg.runLongTask((Frame)object, (Runnable)cancellableTask2, null, (Cancellable)cancellableTask2, (String)string2, (String)string);
    }

    public void addAction(ArrayList<ProjectActionEvent> arrayList, String string, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, String string2, Lookup lookup, AtomicBoolean atomicBoolean) throws IllegalArgumentException {
        if (atomicBoolean.get()) {
            return;
        }
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        this.lastValidation = false;
        String[] stringArray = this.getTargetNames(string2, lookup);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        List<String> list = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equals(REMOVE_INSTRUMENTATION_STEP)) {
                list = this.validateInstrumentation();
                for (String string4 : list) {
                    this.addTarget(string4, arrayList, string, makeConfigurationDescriptor, makeConfiguration, lookup, atomicBoolean, atomicBoolean2);
                }
                continue;
            }
            if ((list == null || !list.contains(string3)) && !this.addTarget(string3, arrayList, string, makeConfigurationDescriptor, makeConfiguration, lookup, atomicBoolean, atomicBoolean2)) break;
        }
    }

    private boolean addTarget(String string, ArrayList<ProjectActionEvent> arrayList, String string2, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Lookup lookup, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IllegalArgumentException {
        ProjectActionEvent.Type type = string.equals(BUILD_STEP) ? ProjectActionEvent.Type.BUILD : (string.equals(BUILD_PACKAGE_STEP) ? ProjectActionEvent.Type.BUILD : (string.equals(CLEAN_STEP) ? ProjectActionEvent.Type.CLEAN : (string.equals(COMPILE_SINGLE_STEP) ? ProjectActionEvent.Type.BUILD : (string.equals(RUN_STEP) ? ProjectActionEvent.Type.RUN : (string.equals(RUN_SINGLE_STEP) ? ProjectActionEvent.Type.RUN : (string.equals(DEBUG_STEP) ? ProjectActionEvent.Type.DEBUG : (string.equals(DEBUG_STEPINTO_STEP) ? ProjectActionEvent.Type.DEBUG_STEPINTO : (string.equals(DEBUG_LOAD_ONLY_STEP) ? ProjectActionEvent.Type.DEBUG_LOAD_ONLY : (string.equals(CUSTOM_ACTION_STEP) ? ProjectActionEvent.Type.CUSTOM_ACTION : (string.equals(CONFIGURE_STEP) ? ProjectActionEvent.Type.CONFIGURE : ProjectActionEvent.Type.RUN))))))))));
        if (atomicBoolean.get()) {
            return false;
        }
        PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
        if (string.equals(SAVE_STEP)) {
            if (MakeOptions.getInstance().getSave()) {
                LifecycleManager.getDefault().saveAll();
            }
            if (!ProjectSupport.saveAllProjects(MakeActionProvider.getString("NeedToSaveAllText"))) {
                return false;
            }
            if (useRsync && !makeConfiguration.getDevelopmentHost().isLocalhost()) {
                CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
                int n = commandProvider.run(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), "which rsync", null);
                String string3 = n != 0 || commandProvider.getOutput().indexOf(32) > -1 ? "/opt/csw/bin/rsync" : commandProvider.getOutput();
                RunProfile runProfile = makeConfiguration.getProfile().clone(makeConfiguration);
                String string4 = this.project.getProjectDirectory().getNameExt();
                String string5 = REMOTE_BASE_PATH + platformInfo.separator() + string4;
                if (string3 == null || string3.length() == 0 || "rsync" == null || "rsync".length() == 0) {
                    System.err.println("Rsync not fould in Toolchain: sources can not be synchronized");
                    return false;
                }
                String string6 = " --rsh=ssh --recursive --verbose --perms --links --delete --rsync-path=" + string3 + " --exclude \"build*\" --exclude \"dist*\" --cvs-exclude . " + makeConfiguration.getDevelopmentHost().getHostKey() + ":" + string5;
                runProfile.setArgs(string6);
                runProfile.getConsoleType().setValue(2);
                MakeConfiguration makeConfiguration2 = (MakeConfiguration)makeConfiguration.clone();
                makeConfiguration2.setDevelopmentHost(new DevelopmentHostConfiguration(ExecutionEnvironmentFactory.getLocal()));
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, string2 + " (Sync)", "rsync", makeConfiguration2, runProfile, false);
                arrayList.add(projectActionEvent);
            }
        } else if (string.equals(RUN_STEP) || string.equals(DEBUG_STEP) || string.equals(DEBUG_STEPINTO_STEP) || string.equals(DEBUG_LOAD_ONLY_STEP)) {
            atomicBoolean2.set(true);
            if (makeConfiguration.isMakefileConfiguration()) {
                String string7;
                if (string.equals(RUN_STEP)) {
                    string7 = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
                    if (string7.length() > 0 && !IpeUtils.isPathAbsolute((String)string7)) {
                        string7 = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                        string7 = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)string7);
                    }
                } else {
                    string7 = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                    string7 = FilePathAdaptor.normalize(string7);
                }
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), string7, makeConfiguration, null, false);
                arrayList.add(projectActionEvent);
                RunDialogPanel.addElementToExecutablePicklist(string7);
            } else {
                if (makeConfiguration.isLibraryConfiguration()) {
                    assert (false);
                    return false;
                }
                if (makeConfiguration.isApplicationConfiguration()) {
                    Object object;
                    Object object2;
                    Object object3;
                    RunProfile runProfile = null;
                    int n = makeConfiguration.getDevelopmentHost().getBuildPlatform();
                    if (n == 3) {
                        String string8;
                        Object object4;
                        runProfile = makeConfiguration.getProfile().clone(makeConfiguration);
                        object3 = makeConfiguration.getSubProjectOutputLocations();
                        object2 = "";
                        object = object3.iterator();
                        while (object.hasNext()) {
                            object4 = FilePathAdaptor.naturalize((String)object.next());
                            object2 = (String)object4 + ";" + object2;
                        }
                        object4 = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object = object4.iterator();
                        while (object.hasNext()) {
                            string8 = FilePathAdaptor.naturalize((String)object.next());
                            object2 = string8 + ";" + (String)object2;
                        }
                        string8 = runProfile.getEnvironment().getenv(platformInfo.getPathName());
                        if (string8 == null) {
                            if (atomicBoolean.get()) {
                                return false;
                            }
                            string8 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get(platformInfo.getPathName());
                        }
                        object2 = (String)object2 + ";" + string8;
                        runProfile.getEnvironment().putenv(platformInfo.getPathName(), (String)object2);
                    } else if (n == 4) {
                        String string9;
                        Object object5;
                        object3 = new StringBuilder();
                        object2 = makeConfiguration.getSubProjectOutputLocations();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            object5 = FilePathAdaptor.naturalize((String)object.next());
                            if (((StringBuilder)object3).length() > 0) {
                                ((StringBuilder)object3).append(":");
                            }
                            ((StringBuilder)object3).append((String)object5);
                        }
                        object5 = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object = object5.iterator();
                        while (object.hasNext()) {
                            string9 = FilePathAdaptor.naturalize((String)object.next());
                            if (((StringBuilder)object3).length() > 0) {
                                ((StringBuilder)object3).append(":");
                            }
                            ((StringBuilder)object3).append(string9);
                        }
                        if (((StringBuilder)object3).length() > 0) {
                            runProfile = makeConfiguration.getProfile().clone(makeConfiguration);
                            string9 = runProfile.getEnvironment().getenv("DYLD_LIBRARY_PATH");
                            if (string9 == null) {
                                if (atomicBoolean.get()) {
                                    return false;
                                }
                                string9 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("DYLD_LIBRARY_PATH");
                            }
                            if (string9 != null) {
                                ((StringBuilder)object3).append(":" + string9);
                            }
                            runProfile.getEnvironment().putenv("DYLD_LIBRARY_PATH", ((StringBuilder)object3).toString());
                        }
                    } else if (n == 1 || n == 0 || n == 2) {
                        String string10;
                        object3 = new StringBuilder();
                        object2 = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            string10 = FilePathAdaptor.naturalize((String)object.next());
                            if (((StringBuilder)object3).length() > 0) {
                                ((StringBuilder)object3).append(":");
                            }
                            ((StringBuilder)object3).append(string10);
                        }
                        if (((StringBuilder)object3).length() > 0) {
                            runProfile = makeConfiguration.getProfile().clone(makeConfiguration);
                            string10 = runProfile.getEnvironment().getenv("LD_LIBRARY_PATH");
                            if (string10 == null) {
                                if (atomicBoolean.get()) {
                                    return false;
                                }
                                string10 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("LD_LIBRARY_PATH");
                            }
                            if (string10 != null) {
                                ((StringBuilder)object3).append(":" + string10);
                            }
                            runProfile.getEnvironment().putenv("LD_LIBRARY_PATH", ((StringBuilder)object3).toString());
                        }
                    }
                    if (n == 4 || n == 1 || n == 0 || n == 2) {
                        if (atomicBoolean.get()) {
                            return false;
                        }
                        if (makeConfiguration.getDevelopmentHost().getExecutionEnvironment().isLocal() && HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("DISPLAY") == null && makeConfiguration.getProfile().getEnvironment().getenv("DISPLAY") == null) {
                            if (runProfile == null) {
                                runProfile = makeConfiguration.getProfile().clone(makeConfiguration);
                            }
                            runProfile.getEnvironment().putenv("DISPLAY", ":0.0");
                        }
                    }
                    object3 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    if (string.equals(RUN_STEP)) {
                        object2 = ((MakeArtifact)object3).getOutput();
                        if (!IpeUtils.isPathAbsolute((String)object2)) {
                            object2 = ((MakeArtifact)object3).getWorkingDirectory() + "/" + (String)object2;
                            object2 = FilePathAdaptor.naturalize((String)object2);
                            object2 = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)object2);
                            object2 = FilePathAdaptor.naturalize((String)object2);
                        }
                    } else {
                        object2 = IpeUtils.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)((MakeArtifact)object3).getOutput());
                    }
                    object = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), (String)object2, makeConfiguration, runProfile, false);
                    arrayList.add((ProjectActionEvent)object);
                    RunDialogPanel.addElementToExecutablePicklist((String)object2);
                } else assert (false);
            }
        } else if (string.equals(RUN_SINGLE_STEP) || string.equals(DEBUG_SINGLE_STEP)) {
            if (makeConfiguration.isMakefileConfiguration()) {
                DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
                String string11 = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath();
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, RUN_STEP, makeConfiguration), string11, makeConfiguration, null, false);
                arrayList.add(projectActionEvent);
                RunDialogPanel.addElementToExecutablePicklist(string11);
            } else assert (false);
        } else if (string.equals(BUILD_STEP)) {
            String string12;
            String string13;
            MakeArtifact makeArtifact;
            if (makeConfiguration.isCompileConfiguration() && !this.validateProject(makeConfiguration)) {
                return true;
            }
            if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, atomicBoolean2.get(), atomicBoolean)) {
                makeArtifact = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                string13 = makeArtifact.getBuildCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                string12 = "";
                int n = string13.indexOf(32);
                if (n > 0) {
                    string12 = string13.substring(n + 1);
                    string13 = string13.substring(0, n);
                }
            } else {
                return false;
            }
            RunProfile runProfile = new RunProfile(makeArtifact.getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
            runProfile.setArgs(string12);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), string13, makeConfiguration, runProfile, true);
            arrayList.add(projectActionEvent);
            atomicBoolean2.set(true);
        } else if (string.equals(BUILD_PACKAGE_STEP)) {
            String string14;
            String string15;
            if (!this.validatePackaging(makeConfiguration)) {
                arrayList.clear();
                return true;
            }
            if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                string15 = "cmd.exe";
                string14 = "/c sh ";
            } else {
                string15 = "bash";
                string14 = "";
            }
            if (makeConfiguration.getPackagingConfiguration().getVerbose().getValue()) {
                string14 = string14 + " -x ";
            }
            string14 = string14 + "nbproject/Package-" + makeConfiguration.getName() + ".bash";
            RunProfile runProfile = new RunProfile(makeConfiguration.getBaseDir(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
            runProfile.setArgs(string14);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), string15, makeConfiguration, runProfile, true);
            arrayList.add(projectActionEvent);
        } else if (string.equals(CLEAN_STEP)) {
            String string16;
            String string17;
            MakeArtifact makeArtifact;
            if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, atomicBoolean2.get(), atomicBoolean)) {
                makeArtifact = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                string17 = makeArtifact.getCleanCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                string16 = "";
                int n = string17.indexOf(32);
                if (n > 0) {
                    string16 = string17.substring(n + 1);
                    string17 = string17.substring(0, n);
                }
            } else {
                return false;
            }
            RunProfile runProfile = new RunProfile(makeArtifact.getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
            runProfile.setArgs(string16);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), string17, makeConfiguration, runProfile, true);
            arrayList.add(projectActionEvent);
            atomicBoolean2.set(true);
        } else if (string.equals(CONFIGURE_STEP)) {
            if (!this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, atomicBoolean2.get(), atomicBoolean)) {
                return false;
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), null, makeConfiguration, null, true);
            arrayList.add(projectActionEvent);
            atomicBoolean2.set(true);
        } else if (string.equals(COMPILE_SINGLE_STEP)) {
            if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, atomicBoolean2.get(), atomicBoolean)) {
                for (Node node : lookup.lookupAll(Node.class)) {
                    String string18;
                    Object object;
                    Item item = this.getNoteItem(node);
                    if (item == null) {
                        return false;
                    }
                    ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                    if (itemConfiguration == null) {
                        return false;
                    }
                    if (itemConfiguration.getExcluded().getValue()) {
                        return false;
                    }
                    if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                        return false;
                    }
                    MakeArtifact makeArtifact = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    String string19 = null;
                    if (itemConfiguration.getTool() == 0) {
                        object = itemConfiguration.getCCompilerConfiguration();
                        string19 = ((BasicCompilerConfiguration)object).getOutputFile(item, makeConfiguration, true);
                    } else if (itemConfiguration.getTool() == 1) {
                        object = itemConfiguration.getCCCompilerConfiguration();
                        string19 = ((BasicCompilerConfiguration)object).getOutputFile(item, makeConfiguration, true);
                    } else if (itemConfiguration.getTool() == 2) {
                        object = itemConfiguration.getFortranCompilerConfiguration();
                        string19 = ((BasicCompilerConfiguration)object).getOutputFile(item, makeConfiguration, true);
                    } else if (itemConfiguration.getTool() == 4) {
                        object = itemConfiguration.getAssemblerConfiguration();
                        string19 = ((BasicCompilerConfiguration)object).getOutputFile(item, makeConfiguration, true);
                    } else if (itemConfiguration.getTool() == 3) {
                        object = itemConfiguration.getCustomToolConfiguration();
                        string19 = ((CustomToolConfiguration)object).getOutputs().getValue();
                    }
                    string19 = makeConfiguration.expandMacros(string19);
                    if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                        object = "cmd.exe";
                        string18 = "/c rm -rf " + string19;
                    } else {
                        object = "rm";
                        string18 = "-rf " + string19;
                    }
                    RunProfile runProfile = new RunProfile(makeArtifact.getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                    runProfile.setArgs(string18);
                    ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, ProjectActionEvent.Type.CLEAN, MakeActionProvider.getActionName(string2, CLEAN_STEP, makeConfiguration), (String)object, makeConfiguration, runProfile, true);
                    arrayList.add(projectActionEvent);
                    object = MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration) + " -f nbproject" + '/' + "Makefile-" + makeConfiguration.getName() + ".mk " + string19;
                    string18 = "";
                    int n = ((String)object).indexOf(32);
                    if (n > 0) {
                        string18 = ((String)object).substring(n + 1);
                        object = ((String)object).substring(0, n);
                    }
                    runProfile = new RunProfile(makeArtifact.getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                    runProfile.setArgs(string18);
                    projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), (String)object, makeConfiguration, runProfile, true);
                    arrayList.add(projectActionEvent);
                }
            } else {
                return false;
            }
            atomicBoolean2.set(true);
        } else if (string.equals(CUSTOM_ACTION_STEP)) {
            String string20 = makeConfiguration.getAbsoluteOutputValue();
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string2, string, makeConfiguration), string20, makeConfiguration, null, true, lookup);
            arrayList.add(projectActionEvent);
        }
        return true;
    }

    private static String getActionName(String string, String string2, MakeConfiguration makeConfiguration) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (").append(string2);
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            stringBuilder.append(" - ").append(makeConfiguration.getDevelopmentHost().getHostKey());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean validateProject(MakeConfiguration makeConfiguration) {
        boolean bl = false;
        if (this.getProjectDescriptor().getProjectItems().length == 0) {
            bl = false;
        } else {
            for (int i = 0; i < this.getProjectDescriptor().getProjectItems().length; ++i) {
                Item item = this.getProjectDescriptor().getProjectItems()[i];
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() == 3 && itemConfiguration.getCustomToolConfiguration().getCommandLine().getValue().length() <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeActionProvider.getString("ERR_EMPTY_PROJECT"), 0));
        }
        return bl;
    }

    private String[] getTargetNames(String string, Lookup lookup) throws IllegalArgumentException {
        String[] stringArray = new String[]{};
        if (string.equals("compile.single")) {
            stringArray = this.commands.get(string);
        } else if (string.equals(RUN_STEP) || string.equals(DEBUG_STEP) || string.equals("debug.stepinto") || string.equals(COMMAND_DEBUG_LOAD_ONLY) || string.equals(COMMAND_CUSTOM_ACTION)) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            if (makeConfiguration == null) {
                return null;
            }
            RunProfile runProfile = (RunProfile)makeConfiguration.getAuxObject("runprofile");
            if (runProfile == null) {
                return null;
            }
            stringArray = runProfile.getBuildFirst() ? this.commands.get(string) : this.commandsNoBuild.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        } else if (string.equals("run.single") || string.equals("debug.single") ? (stringArray = this.commands.get(string)) == null : (stringArray = this.commands.get(string)) == null) {
            throw new IllegalArgumentException(string);
        }
        return stringArray;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if (!this.isProjectDescriptorLoaded()) {
            return false;
        }
        MakeConfiguration makeConfiguration = this.getProjectDescriptor().getActiveConfiguration();
        if (makeConfiguration == null) {
            return false;
        }
        if (string.equals(CLEAN_STEP)) {
            return true;
        }
        if (string.equals(BUILD_STEP)) {
            return true;
        }
        if (string.equals(COMMAND_BUILD_PACKAGE)) {
            return true;
        }
        if (string.equals(COMMAND_BATCH_BUILD)) {
            return true;
        }
        if (string.equals("rebuild")) {
            return true;
        }
        if (string.equals(RUN_STEP)) {
            return !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals(DEBUG_STEP)) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("debug.stepinto")) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals(COMMAND_DEBUG_LOAD_ONLY)) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("compile.single")) {
            boolean bl = true;
            for (Node node : lookup.lookupAll(Node.class)) {
                Item item = this.getNoteItem(node);
                if (item == null) {
                    return false;
                }
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null) {
                    return false;
                }
                if (itemConfiguration.getExcluded().getValue()) {
                    return false;
                }
                if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                    return false;
                }
                if (!makeConfiguration.isMakefileConfiguration()) continue;
                return false;
            }
            return bl;
        }
        if (string.equals("delete") || string.equals("copy") || string.equals("move") || string.equals("rename")) {
            return true;
        }
        if (string.equals("run.single")) {
            Node node = (Node)lookup.lookup(Node.class);
            return node != null && node.getCookie(ShellExecSupport.class) != null;
        }
        return false;
    }

    private Item getNoteItem(Node node) {
        Item item = (Item)node.getValue("Item");
        if (item == null) {
            try {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject != null) {
                    File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
                    item = this.getProjectDescriptor().findItemByFile(file);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return item;
    }

    private static String getMakeCommand(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        String string = null;
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet != null) {
            string = compilerSet.getTool(5).getPath();
        } else {
            assert (false);
            string = "make";
        }
        return string;
    }

    private List<String> validateInstrumentation() {
        return ValidateInstrumentationProvider.getDefault().validate(this.project);
    }

    private boolean validateBuildSystem(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, boolean bl, AtomicBoolean atomicBoolean) {
        ShellValidationSupport.ShellValidationStatus shellValidationStatus;
        BuildToolsAction buildToolsAction;
        CompilerSet compilerSet;
        String string;
        String string2;
        Platform platform;
        ExecutionEnvironment executionEnvironment;
        int n;
        int n2;
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        ExecutionEnvironment executionEnvironment2 = ExecutionEnvironmentFactory.fromUniqueID((String)makeConfiguration.getDevelopmentHost().getHostKey());
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = makeConfiguration.hasCFiles(makeConfigurationDescriptor);
        boolean bl3 = makeConfiguration.hasCPPFiles(makeConfigurationDescriptor);
        boolean bl4 = makeConfiguration.hasFortranFiles(makeConfigurationDescriptor);
        boolean bl5 = makeConfiguration.hasAssemblerFiles(makeConfigurationDescriptor);
        boolean bl6 = false;
        if (bl) {
            return this.lastValidation;
        }
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment2);
            assert (serverRecord != null);
            serverRecord.validate(false);
            if (atomicBoolean.get()) {
                return false;
            }
            if (!serverRecord.isOnline()) {
                this.lastValidation = false;
                bl6 = true;
            }
        }
        if ((n2 = makeConfiguration.getDevelopmentHost().getBuildPlatform()) != (n = CompilerSetManager.getDefault((ExecutionEnvironment)(executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment())).getPlatform())) {
            if (!makeConfiguration.isMakefileConfiguration()) {
                Platform platform2 = Platforms.getPlatform(n2);
                platform = Platforms.getPlatform(n);
                string2 = MakeActionProvider.getString("WRONG_PLATFORM", platform.getDisplayName(), platform2.getDisplayName());
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string2, 2)) != NotifyDescriptor.OK_OPTION) {
                    return false;
                }
            }
            makeConfiguration.getDevelopmentHost().setBuildPlatform(n);
        }
        boolean bl7 = false;
        if (compilerSet2Configuration.getFlavor() != null && compilerSet2Configuration.getFlavor().equals("Unknown")) {
            bl7 = true;
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getCompilerSet(string);
            if (compilerSet == null) {
                compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getDefaultCompilerSet();
            }
            bl6 = true;
        } else if (compilerSet2Configuration.isValid()) {
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getCompilerSet(string);
        } else {
            string = compilerSet2Configuration.getOldName();
            platform = null;
            if (compilerSet2Configuration.getFlavor() != null) {
                platform = CompilerSet.CompilerFlavor.toFlavor((String)compilerSet2Configuration.getFlavor(), (int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            if (platform == null) {
                platform = CompilerSet.CompilerFlavor.getUnknown((int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            compilerSet = CompilerSet.getCustomCompilerSet((String)"", (CompilerSet.CompilerFlavor)platform, (String)compilerSet2Configuration.getOldName());
            CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).add(compilerSet);
            compilerSet2Configuration.setValid();
        }
        platform = compilerSet.getTool(0);
        string2 = compilerSet.getTool(1);
        Tool tool = compilerSet.getTool(2);
        Tool tool2 = compilerSet.getTool(4);
        Tool tool3 = compilerSet.getTool(5);
        Tool tool4 = compilerSet.getTool(7);
        if (atomicBoolean.get()) {
            return false;
        }
        PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
        if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
            File file = new File(tool3.getPath());
            if (!MakeActionProvider.exists(tool3.getPath(), platformInfo) && Path.findCommand((String)tool3.getPath()) == null || !ToolsPanel.supportedMake((String)file.getPath())) {
                bl6 = true;
            }
        } else if (!MakeActionProvider.isValidExecutable(tool3.getPath(), platformInfo)) {
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl2 && !MakeActionProvider.exists(platform.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCCompiler", (Object)string, (Object)platform.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl3 && !MakeActionProvider.exists(string2.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCppCompiler", (Object)string, (Object)string2.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl4 && !MakeActionProvider.exists(tool.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingFortranCompiler", (Object)string, (Object)tool.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl5 && !MakeActionProvider.exists(tool2.getPath(), platformInfo)) {
            bl6 = true;
        }
        if (makeConfiguration.isQmakeConfiguration() && !MakeActionProvider.exists(tool4.getPath(), platformInfo)) {
            bl6 = true;
        }
        if (makeConfiguration.getDevelopmentHost().isLocalhost() && Boolean.getBoolean("netbeans.cnd.always_show_bta")) {
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (compilerSet.getCompilerFlavor().isSunStudioCompiler() && !CndUtils.isUnitTestMode()) {
            SunStudioUserCounter.countIDE((String)compilerSet.getDirectory(), (ExecutionEnvironment)executionEnvironment);
        }
        if (bl6) {
            if (CndUtils.isUnitTestMode()) {
                this.lastValidation = false;
            } else if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                buildToolsAction = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
                buildToolsAction.setTitle(NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_ResolveMissingTools_Title"));
                shellValidationStatus = new LocalToolsPanelModel();
                shellValidationStatus.setSelectedDevelopmentHost(executionEnvironment2);
                shellValidationStatus.setEnableDevelopmentHostChange(false);
                shellValidationStatus.setCompilerSetName(null);
                shellValidationStatus.setSelectedCompilerSetName(string);
                shellValidationStatus.setMakeRequired(true);
                shellValidationStatus.setDebuggerRequired(false);
                shellValidationStatus.setCRequired(bl2);
                shellValidationStatus.setCppRequired(bl3);
                shellValidationStatus.setFortranRequired(bl4);
                shellValidationStatus.setAsRequired(bl5);
                shellValidationStatus.setShowRequiredBuildTools(true);
                shellValidationStatus.setShowRequiredDebugTools(false);
                shellValidationStatus.setEnableRequiredCompilerCB(makeConfiguration.isMakefileConfiguration());
                if (buildToolsAction.initBuildTools((ToolsPanelModel)shellValidationStatus, arrayList, compilerSet) && makeConfigurationDescriptor.okToChange()) {
                    String string3 = shellValidationStatus.getSelectedCompilerSetName();
                    CppSettings.getDefault().setCompilerSetName(string3);
                    makeConfiguration.getCRequired().setValue(shellValidationStatus.isCRequired());
                    makeConfiguration.getCppRequired().setValue(shellValidationStatus.isCppRequired());
                    makeConfiguration.getFortranRequired().setValue(shellValidationStatus.isFortranRequired());
                    makeConfiguration.getAssemblerRequired().setValue(shellValidationStatus.isAsRequired());
                    makeConfiguration.getCompilerSet().setValue(string3);
                    makeConfigurationDescriptor.setModified();
                    makeConfigurationDescriptor.save();
                    this.lastValidation = true;
                } else {
                    this.lastValidation = false;
                }
            } else {
                if (atomicBoolean.get()) {
                    return false;
                }
                buildToolsAction = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_INVALID_COMPILER_SET", (Object)string, (Object)makeConfiguration.getDevelopmentHost().getDisplayName(false)));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)buildToolsAction);
                this.lastValidation = false;
            }
        } else {
            this.lastValidation = true;
        }
        if (this.lastValidation && compilerSet.getCompilerFlavor().isCygwinCompiler()) {
            boolean bl8;
            buildToolsAction = WindowsSupport.getInstance().getActiveShell();
            shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)buildToolsAction);
            boolean bl9 = bl8 = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
            if (!bl8) {
                String string4 = compilerSet.getDirectory();
                if (buildToolsAction == null || !string4.equals(buildToolsAction.bindir.getAbsolutePath())) {
                    WindowsSupport.getInstance().init(string4);
                    buildToolsAction = WindowsSupport.getInstance().getActiveShell();
                    shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)buildToolsAction);
                    boolean bl10 = bl8 = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
                }
            }
            if (!bl8) {
                this.lastValidation = ShellValidationSupport.confirm((ShellValidationSupport.ShellValidationStatus)shellValidationStatus);
            }
        }
        return this.lastValidation;
    }

    private boolean validatePackaging(MakeConfiguration makeConfiguration) {
        String string = null;
        if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0) {
            string = MakeActionProvider.getString("ERR_EMPTY_PACKAGE");
        }
        if (PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue()) == null) {
            string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL4", (Object)makeConfiguration.getPackagingConfiguration().getType().getValue());
        }
        if (string != null) {
            MakeCustomizerProvider makeCustomizerProvider;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0 && (makeCustomizerProvider = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class)) != null) {
                makeCustomizerProvider.showCustomizer("Packaging");
            }
            return false;
        }
        return true;
    }

    private static final boolean isValidExecutable(String string, PlatformInfo platformInfo) {
        return MakeActionProvider.existsImpl(string, platformInfo, true);
    }

    private static boolean exists(String string, PlatformInfo platformInfo) {
        return MakeActionProvider.existsImpl(string, platformInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean existsImpl(String string, PlatformInfo platformInfo, boolean bl) {
        boolean bl2;
        Object object;
        Map<String, Boolean> map;
        ExecutionEnvironment executionEnvironment = platformInfo.getExecutionEnvironment();
        String string2 = string + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment);
        Map<String, Boolean> map2 = map = bl ? validExecutablesCache : fileExistenceCache;
        synchronized (map2) {
            object = map.get(string2);
            if (object != null && ((Boolean)object).booleanValue()) {
                return true;
            }
        }
        if (bl) {
            bl2 = ServerList.isValidExecutable((ExecutionEnvironment)executionEnvironment, (String)string);
        } else {
            boolean bl3 = bl2 = platformInfo.fileExists(string) || platformInfo.isWindows() && platformInfo.fileExists(string + ".lnk") || platformInfo.findCommand(string) != null;
        }
        if (bl2) {
            object = map;
            synchronized (object) {
                map.put(string2, Boolean.TRUE);
            }
        }
        return bl2;
    }

    private static boolean isAbsolutePath(MakeConfiguration makeConfiguration, String string) {
        if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
            return string.length() > 3 && string.charAt(1) == ':' && string.charAt(2) == '/';
        }
        return string.length() > 0 && string.charAt(0) == '/';
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)string);
    }

    private static String getString(String string, String string2, String string3) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)string, (Object)string2, (Object)string3);
    }

    private static class BatchConfigurationSelector
    implements ActionListener {
        private JButton buildButton = new JButton(MakeActionProvider.access$100("BuildButton"));
        private JButton rebuildButton = new JButton(MakeActionProvider.access$100("CleanBuildButton"));
        private JButton cleanButton = new JButton(MakeActionProvider.access$100("CleanButton"));
        private JButton closeButton = new JButton(MakeActionProvider.access$100("CloseButton"));
        private ConfSelectorPanel confSelectorPanel;
        private String command = null;
        private Dialog dialog = null;

        BatchConfigurationSelector(MakeProject makeProject, Configuration[] configurationArray) {
            this.confSelectorPanel = new ConfSelectorPanel(MakeActionProvider.getString("CheckLabel"), MakeActionProvider.getString("CheckLabelMn").charAt(0), configurationArray, new JButton[]{this.buildButton, this.rebuildButton, this.cleanButton});
            String string = MessageFormat.format(MakeActionProvider.getString("BatchBuildTitle"), ProjectUtils.getInformation((Project)makeProject).getDisplayName());
            this.buildButton.setMnemonic(MakeActionProvider.getString("BuildButtonMn").charAt(0));
            this.buildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BuildButtonAD"));
            this.buildButton.addActionListener(this);
            this.rebuildButton.setMnemonic(MakeActionProvider.getString("CleanBuildButtonMn").charAt(0));
            this.rebuildButton.addActionListener(this);
            this.rebuildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanBuildButtonAD"));
            this.cleanButton.setMnemonic(MakeActionProvider.getString("CleanButtonMn").charAt(0));
            this.cleanButton.addActionListener(this);
            this.cleanButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanButtonAD"));
            this.closeButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CloseButtonAD"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.confSelectorPanel, string, true, new Object[]{this.closeButton}, (Object)this.closeButton, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BatchBuildDialogAD"));
            this.dialog.setVisible(true);
        }

        public Configuration[] getSelectedConfs() {
            return this.confSelectorPanel.getSelectedConfs();
        }

        public String getCommand() {
            return this.command;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.buildButton) {
                this.command = MakeActionProvider.BUILD_STEP;
            } else if (actionEvent.getSource() == this.rebuildButton) {
                this.command = "rebuild";
            } else if (actionEvent.getSource() == this.cleanButton) {
                this.command = MakeActionProvider.CLEAN_STEP;
            } else assert (false);
            this.dialog.dispose();
        }
    }

    private static abstract class CancellableTask
    implements Runnable,
    Cancellable {
        private volatile Thread thread;
        protected final AtomicBoolean cancelled = new AtomicBoolean(false);

        private CancellableTask() {
        }

        protected abstract void runImpl();

        public final void run() {
            this.thread = Thread.currentThread();
            if (!this.cancelled.get()) {
                this.runImpl();
            }
        }

        public boolean cancel() {
            this.cancelled.set(true);
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }
}

