/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaClientManager
implements IRepositoryListener {
    private final Map<String, BugzillaClient> clientByUrl = new HashMap<String, BugzillaClient>();

    public synchronized BugzillaClient getClient(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        BugzillaClient client = this.clientByUrl.get(taskRepository.getRepositoryUrl());
        if (client == null) {
            String language = taskRepository.getProperty("bugzilla.languageSetting");
            if (language == null || language.equals("")) {
                language = "en (default)";
            }
            try {
                client = this.createClient(taskRepository);
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Malformed Repository Url", (Throwable)e));
            }
            this.clientByUrl.put(taskRepository.getRepositoryUrl(), client);
            client.setRepositoryConfiguration(BugzillaCorePlugin.getRepositoryConfiguration(taskRepository, false, monitor));
        }
        return client;
    }

    protected BugzillaClient createClient(TaskRepository taskRepository) throws MalformedURLException {
        return BugzillaClientFactory.createClient(taskRepository);
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
    }

    private void removeClient(TaskRepository repository) {
        this.clientByUrl.remove(repository.getRepositoryUrl());
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

