/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.text.MessageFormat;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.ReviewSettingsPanelUI;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardImpl;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ReviewSettingsPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "ReviewSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ReviewSettingsPanel.HelpCtx");
    private Model model = new Model();
    private ReviewSettingsPanelUI panel;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return true;
    }

    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canNext(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    public void onEnter(AttachWizardContext attachWizardContext) {
        if (this.getContext().getAttachSettings().isRemote()) {
            this.getContext().setManual(true);
            this.getContext().setAutomatic(false);
        } else {
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsManual()) {
                this.getContext().setAutomatic(false);
            }
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsAutomation()) {
                this.getContext().setManual(false);
            }
        }
        this.getContext().setHideIntegration(true);
    }

    public void onExit(AttachWizardContext attachWizardContext) {
        boolean bl = this.getContext().getAttachSettings().commit();
        if (bl) {
            this.getContext().setConfigChanged();
        }
        this.getContext().setHideIntegration(false);
    }

    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    public void onPanelShow() {
        this.model.setSummary(this.buildSummary(this.getContext().getAttachSettings()));
        this.panel.refresh();
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ReviewSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    private String buildSummary(AttachSettings attachSettings) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_TargetTypeString"));
        stringBuffer.append("</b> ");
        stringBuffer.append(attachSettings.getTargetType());
        stringBuffer.append("<br>");
        if (!this.getContext().isProviderSingular()) {
            stringBuffer.append("<b>");
            stringBuffer.append(NbBundle.getMessage(this.getClass(), (String)"AttachWizard_TargetNameTypeString"));
            stringBuffer.append("</b> ");
            stringBuffer.append(attachSettings.getServerType());
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<b>");
        stringBuffer.append(MessageFormat.format(NbBundle.getMessage(this.getClass(), (String)"AttachWizard_TargetNameLocationString"), attachSettings.getServerType()));
        stringBuffer.append("</b> ");
        if (attachSettings.isRemote()) {
            stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_RemoteSystemString"));
            stringBuffer.append("<br>");
            stringBuffer.append("<b>");
            stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_RemoteSystemHostNameString"));
            stringBuffer.append("</b> ");
            stringBuffer.append(attachSettings.getHost());
            stringBuffer.append("<br>");
            stringBuffer.append("<b>");
            stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_RemoteSystemOsString"));
            stringBuffer.append("</b> ");
            stringBuffer.append(attachSettings.getHostOS());
            stringBuffer.append("<br>");
        } else {
            stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_LocalMachineString"));
            stringBuffer.append("<br>");
            stringBuffer.append("<b>");
            stringBuffer.append(NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_AttachMethodString"));
            stringBuffer.append("</b> ");
            stringBuffer.append(attachSettings.isDirect() ? NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_DirectAttachString") : NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_DynamicAttachString"));
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    public class Model {
        private String summary;

        public String getProviderName() {
            return ReviewSettingsPanel.this.getContext().getIntegrationProvider().getTitle();
        }

        public void setSummary(String string) {
            this.summary = string;
        }

        public String getSummary() {
            if (this.summary == null) {
                return "";
            }
            return this.summary;
        }
    }
}

