/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionsListDataProviderImpl
implements FunctionsListDataProvider {
    private final Lock lock = new Lock();
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;
    private final List<DataFilter> filters = new ArrayList<DataFilter>();

    FunctionsListDataProviderImpl() {
    }

    public void attachTo(DataStorage dataStorage) {
        this.storage = (StackDataStorage)dataStorage;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata dataTableMetadata, FunctionDatatableDescription functionDatatableDescription, List<DataTableMetadata.Column> list) {
        ArrayList<DataFilter> arrayList = null;
        Object object = this.lock;
        synchronized (object) {
            arrayList = new ArrayList<DataFilter>(this.filters);
        }
        if (functionDatatableDescription.getOffsetColumn() == null) {
            object = new ArrayList();
            List<FunctionCallTreeTableNode> list2 = FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeExclusiveMetric, arrayList, Integer.MAX_VALUE));
            for (FunctionCallTreeTableNode functionCallTreeTableNode : list2) {
                FunctionCallWithMetric functionCallWithMetric = functionCallTreeTableNode.getDeligator();
                object.add(functionCallWithMetric);
            }
            return object;
        }
        return this.storage.getFunctionsList(dataTableMetadata, list, functionDatatableDescription, arrayList);
    }

    @Override
    public List<FunctionCallWithMetric> getDetailedFunctionsList(DataTableMetadata dataTableMetadata, FunctionDatatableDescription functionDatatableDescription, List<DataTableMetadata.Column> list) {
        return this.getFunctionsList(dataTableMetadata, functionDatatableDescription, list);
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Collection collection = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider sourceFileInfoProvider : collection) {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), -1, functionCall.getOffset(), this.serviceInfoStorage.getInfo());
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            return sourceFileInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        if (bl) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(list);
        }
    }

    @Override
    public boolean hasTheSameDetails(DataTableMetadata dataTableMetadata, FunctionDatatableDescription functionDatatableDescription, List<DataTableMetadata.Column> list) {
        return true;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

