/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345825459L;
    protected static final String JAVA_EXTENSION = "java";
    protected static FileWizardIterator instance;
    protected transient int panelIndex = 0;
    protected transient WizardDescriptor.Panel[] panels;
    protected transient TemplateWizard wizardInstance;

    public static synchronized FileWizardIterator singleton() {
        if (instance == null) {
            instance = new FileWizardIterator();
        }
        return instance;
    }

    public Set<DataObject> instantiate(final TemplateWizard templateWizard) throws IOException, IllegalArgumentException {
        this.wizardInstance = templateWizard;
        DataObject dataObject = this.instantiateTemplate(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName());
        Object object = Templates.getTemplate((WizardDescriptor)this.wizardInstance).getAttribute("isMIDletTemplate");
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (bl) {
            final Project project = Templates.getProject((WizardDescriptor)this.wizardInstance);
            final AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
            if (project instanceof J2MEProject && antProjectHelper != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            J2MEProjectGenerator.addMIDletProperty(project, antProjectHelper, (String)templateWizard.getProperty("MidletName"), (String)templateWizard.getProperty("MidletClassName"), (String)templateWizard.getProperty("MidletIcon"));
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
            }
        }
        return Collections.singleton(dataObject);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new MIDPTargetChooserPanel()};
        }
        this.panelIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wizardInstance = null;
        this.panels = null;
        this.panelIndex = -1;
    }

    private DataObject instantiateTemplate(DataObject dataObject, DataFolder dataFolder, String string) throws IOException {
        String string2;
        if (string == null) {
            string = this.getDefaultName(dataObject, dataFolder);
        }
        if ((string2 = FileWizardIterator.checkValidPackageName(dataFolder)) == null) {
            string2 = FileWizardIterator.checkTargetName(dataFolder, string);
        }
        if (string2 != null) {
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string2), 256, null, string2, null, null);
        }
        return dataObject.createFromTemplate(dataFolder, string);
    }

    private static boolean isValidPackageName(String string) {
        if ("".equals(string)) {
            return true;
        }
        try {
            Utilities.isJavaIdentifier((String)string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static String checkValidPackageName(DataFolder dataFolder) throws IllegalStateException {
        FileObject fileObject = dataFolder.getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = null;
        if (classPath != null) {
            String string2 = classPath.getResourceName(fileObject, '.', false);
            if (FileWizardIterator.isValidPackageName(string2)) {
                return null;
            }
            string = MessageFormat.format(FileWizardIterator.getString("ERR_File_IllegalFolderName"), fileObject.getPath(), string2);
        } else {
            string = FileWizardIterator.getString("ERR_File_NotInSourcePath");
        }
        return string;
    }

    public static String checkTargetName(DataFolder dataFolder, String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string2 = MessageFormat.format(FileWizardIterator.getString("ERR_File_IllegalTargetName"), string);
            return string2;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (fileObject.getFileObject(string, JAVA_EXTENSION) != null) {
            String string3 = MessageFormat.format(FileWizardIterator.getString("ERR_File_TargetExists"), string);
            return string3;
        }
        return null;
    }

    private String getDefaultName(DataObject dataObject, DataFolder dataFolder) {
        String string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)dataObject.getName(), (String)JAVA_EXTENSION);
        return string;
    }

    static String getString(String string) {
        return NbBundle.getMessage(FileWizardIterator.class, (String)string);
    }

    static char getMnemonic(String string) {
        return FileWizardIterator.getString(string).charAt(0);
    }

    private void updateStepsList() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        jComponent.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)"TITLE_File")});
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.panelIndex));
    }
}

