/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.project.support.customizer.AntArtifactChooser;
import org.netbeans.modules.project.support.customizer.LibrariesChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualClasspathSupport {
    static File lastFile = null;
    final JTable classpathTable;
    final JButton addJarButton;
    final JButton addFolderButton;
    final JButton addLibraryButton;
    final String libraryType;
    final JButton addArtifactButton;
    final JButton removeButton;
    final JButton upButton;
    final JButton downButton;
    private FileObject myRoot;
    private final ClasspathTableModel classpathModel;
    private ProjectProperties properties;
    private String libsClasspath;
    private String extraClasspath;

    public VisualClasspathSupport(JTable jTable, JButton jButton, JButton jButton2, JButton jButton3, String string, JButton jButton4, JButton jButton5, JButton jButton6, JButton jButton7) {
        this.classpathTable = jTable;
        this.classpathModel = new ClasspathTableModel();
        this.classpathTable.setModel(this.classpathModel);
        this.classpathTable.getSelectionModel().setSelectionMode(2);
        this.classpathTable.setDefaultRenderer(VisualClassPathItem.class, new ClassPathRenderer());
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        JTableHeader jTableHeader = jTable.getTableHeader();
        tableColumn.setMaxWidth(24 + SwingUtilities.computeStringWidth(jTableHeader.getFontMetrics(jTableHeader.getFont()), String.valueOf(tableColumn.getHeaderValue())));
        this.addJarButton = jButton;
        this.addFolderButton = jButton2;
        this.addLibraryButton = jButton3;
        this.libraryType = string;
        this.addArtifactButton = jButton4;
        this.removeButton = jButton5;
        this.upButton = jButton6;
        this.downButton = jButton7;
        ClasspathSupportListener classpathSupportListener = new ClasspathSupportListener();
        jButton.addActionListener(classpathSupportListener);
        jButton2.addActionListener(classpathSupportListener);
        jButton3.addActionListener(classpathSupportListener);
        jButton4.addActionListener(classpathSupportListener);
        jButton5.addActionListener(classpathSupportListener);
        jButton6.addActionListener(classpathSupportListener);
        jButton7.addActionListener(classpathSupportListener);
        jTable.getSelectionModel().addListSelectionListener(classpathSupportListener);
        classpathSupportListener.valueChanged(null);
    }

    public void setProperties(ProjectProperties projectProperties) {
        this.properties = projectProperties;
        this.myRoot = projectProperties.getProjectDirectory();
    }

    public void setEnabled(boolean bl) {
        this.classpathTable.setEnabled(bl);
        this.addJarButton.setEnabled(bl);
        this.addFolderButton.setEnabled(bl);
        this.addLibraryButton.setEnabled(bl);
        this.addArtifactButton.setEnabled(bl);
        if (bl) {
            int n;
            boolean bl2;
            int[] nArray = this.classpathTable.getSelectedRows();
            boolean bl3 = bl2 = nArray != null && nArray.length > 0;
            if (bl2) {
                for (n = 0; n < nArray.length; ++n) {
                    VisualClassPathItem visualClassPathItem = this.classpathModel.get(nArray[n]);
                    if (visualClassPathItem.canDelete()) continue;
                    bl2 = false;
                    break;
                }
            }
            n = nArray != null && nArray.length > 0 && nArray[0] != 0 ? 1 : 0;
            boolean bl4 = nArray != null && nArray.length > 0 && nArray[nArray.length - 1] != this.classpathModel.getRowCount() - 1;
            this.removeButton.setEnabled(bl2);
            this.upButton.setEnabled(n != 0);
            this.downButton.setEnabled(bl4);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void setVisualClassPathItems(List<VisualClassPathItem> list) {
        this.classpathModel.clear();
        for (VisualClassPathItem visualClassPathItem : list) {
            this.classpathModel.addElement(visualClassPathItem);
        }
    }

    public List<VisualClassPathItem> getVisualClassPathItems() {
        ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
        Enumeration<VisualClassPathItem> enumeration = this.classpathModel.elements();
        while (enumeration.hasMoreElements()) {
            VisualClassPathItem visualClassPathItem = enumeration.nextElement();
            arrayList.add(visualClassPathItem);
        }
        return arrayList;
    }

    public List<VisualClassPathItem> getExtraClassPathItems() {
        ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
        Enumeration<VisualClassPathItem> enumeration = this.classpathModel.elements();
        while (enumeration.hasMoreElements()) {
            VisualClassPathItem visualClassPathItem = enumeration.nextElement();
            if (!visualClassPathItem.isExtra()) continue;
            arrayList.add(visualClassPathItem);
        }
        return arrayList;
    }

    public synchronized void setPropertyNames(String string, String string2) {
        this.libsClasspath = string;
        this.extraClasspath = string2;
    }

    private synchronized void fireActionPerformed() {
        this.properties.put(this.libsClasspath, this.getVisualClassPathItems());
        this.properties.put(this.extraClasspath, this.getExtraClassPathItems());
    }

    protected void addLibraries(Library[] libraryArray) {
        int[] nArray = this.classpathTable.getSelectedRows();
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        for (int i = 0; i < libraryArray.length; ++i) {
            String string = libraryArray[i].getName();
            this.classpathModel.add(n + 1 + i, new VisualClassPathItem(libraryArray[i], 1, "${libs." + string + ".classpath}", libraryArray[i].getDisplayName()));
        }
        this.fireActionPerformed();
    }

    protected void addJarFiles(File[] fileArray) {
        int[] nArray = this.classpathTable.getSelectedRows();
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = FileUtil.normalizeFile((File)fileArray[i]);
            this.classpathModel.add(n + 1 + i, new VisualClassPathItem(fileArray[i], 0, null, fileArray[i].getPath()));
        }
        this.fireActionPerformed();
    }

    protected void addFolders(File[] fileArray) {
        int[] nArray = this.classpathTable.getSelectedRows();
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = FileUtil.normalizeFile((File)fileArray[i]);
            this.classpathModel.add(n + 1 + i, new VisualClassPathItem(fileArray[i], 4, null, fileArray[i].getPath()));
        }
        this.fireActionPerformed();
    }

    protected void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItemArray) {
        int[] nArray = this.classpathTable.getSelectedRows();
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        for (int i = 0; i < artifactItemArray.length; ++i) {
            String string;
            AntArtifact antArtifact = artifactItemArray[i].getArtifact();
            URI uRI = artifactItemArray[i].getURI();
            try {
                string = FileUtil.normalizeFile((File)new File(antArtifact.getScriptLocation().getParentFile().toURI().resolve(uRI))).getPath();
            }
            catch (Exception exception) {
                string = uRI.getPath();
            }
            Project project = antArtifact.getProject();
            if (project != null && project.getProjectDirectory().equals(this.myRoot)) continue;
            this.classpathModel.add(n + 1 + i, new VisualClassPathItem(antArtifact, uRI, 2, null, string));
        }
        this.fireActionPerformed();
    }

    protected void removeElements() {
        int n;
        int[] nArray = this.classpathTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) assert (false) : "Remove button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            this.classpathModel.remove(nArray[n]);
        }
        if (this.classpathModel.getRowCount() > 0) {
            n = nArray[nArray.length - 1] - nArray.length + 1;
            if (n > this.classpathModel.getRowCount() - 1) {
                n = this.classpathModel.getRowCount() - 1;
            }
            this.classpathTable.getSelectionModel().setSelectionInterval(n, n);
        }
        this.fireActionPerformed();
    }

    protected void moveUp() {
        int n;
        int[] nArray = this.classpathTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) assert (false) : "MoveUp button should be disabled";
        for (n = 0; n < nArray.length; ++n) {
            VisualClassPathItem visualClassPathItem = this.classpathModel.get(nArray[n]);
            this.classpathModel.remove(nArray[n]);
            this.classpathModel.add(nArray[n] - 1, visualClassPathItem);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] - 1;
            if (n == 0) {
                this.classpathTable.getSelectionModel().setSelectionInterval(nArray[n], nArray[n]);
                continue;
            }
            this.classpathTable.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
        }
        this.fireActionPerformed();
    }

    protected void moveDown() {
        int n;
        int[] nArray = this.classpathTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) assert (false) : "MoveDown button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            VisualClassPathItem visualClassPathItem = this.classpathModel.get(nArray[n]);
            this.classpathModel.remove(nArray[n]);
            this.classpathModel.add(nArray[n] + 1, visualClassPathItem);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
            if (n == 0) {
                this.classpathTable.getSelectionModel().setSelectionInterval(nArray[n], nArray[n]);
                continue;
            }
            this.classpathTable.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
        }
        this.fireActionPerformed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClasspathTableModel
    extends AbstractTableModel {
        private Vector<VisualClassPathItem> items = new Vector();

        private ClasspathTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return NbBundle.getMessage(VisualClasspathSupport.class, (String)(n == 0 ? "CPTable_Column1" : "CPTable_Column2"));
        }

        public Class getColumnClass(int n) {
            return n == 0 ? VisualClassPathItem.class : Boolean.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.items.get(n).setExtra((Boolean)object == false);
            VisualClasspathSupport.this.fireActionPerformed();
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public VisualClassPathItem get(int n) {
            return this.items.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.get(n) : Boolean.valueOf(!this.get(n).isExtra());
        }

        public void clear() {
            this.items.clear();
            this.fireTableDataChanged();
        }

        public void addElement(VisualClassPathItem visualClassPathItem) {
            int n = this.items.size();
            this.items.add(visualClassPathItem);
            this.fireTableRowsInserted(n, n);
        }

        public void add(int n, VisualClassPathItem visualClassPathItem) {
            this.items.add(n, visualClassPathItem);
            this.fireTableRowsInserted(n, n);
        }

        public void remove(int n) {
            this.items.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public Enumeration<VisualClassPathItem> elements() {
            return this.items.elements();
        }
    }

    private static class JarFileFilter
    extends FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return file.isDirectory() || string.endsWith(".zip") || string.endsWith(".jar");
        }

        public String getDescription() {
            return NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_JarFileFilter");
        }
    }

    private static class ClassPathRenderer
    extends DefaultTableCellRenderer {
        private ClassPathRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)object;
            this.setIcon(visualClassPathItem == null ? null : visualClassPathItem.getIcon());
            return this;
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener {
        private ClasspathSupportListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == VisualClasspathSupport.this.addJarButton) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setDialogTitle(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddJar"));
                jFileChooser.setFileFilter(new JarFileFilter());
                jFileChooser.setAcceptAllFileFilterUsed(false);
                if (lastFile != null) {
                    jFileChooser.setSelectedFile(lastFile);
                }
                if ((n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(VisualClasspathSupport.this.addJarButton))) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    if (fileArray.length > 0) {
                        lastFile = fileArray[0];
                    }
                    VisualClasspathSupport.this.addJarFiles(fileArray);
                }
            } else if (object == VisualClasspathSupport.this.addFolderButton) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setDialogTitle(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddFolder"));
                if (lastFile != null) {
                    jFileChooser.setSelectedFile(lastFile);
                }
                if ((n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(VisualClasspathSupport.this.addFolderButton))) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    if (fileArray.length > 0) {
                        lastFile = fileArray[0];
                    }
                    VisualClasspathSupport.this.addFolders(fileArray);
                }
            } else if (object == VisualClasspathSupport.this.addLibraryButton) {
                LibrariesChooser librariesChooser = new LibrariesChooser(VisualClasspathSupport.this.libraryType);
                JButton jButton = new JButton(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                Object[] objectArray = new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION};
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)librariesChooser, NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"), true, objectArray, objectArray[0], 0, null, null);
                dialogDescriptor.setHelpCtx(new HelpCtx(LibrariesChooser.class));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"));
                dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"));
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == objectArray[0]) {
                    VisualClasspathSupport.this.addLibraries(librariesChooser.getSelectedLibraries());
                }
                dialog.dispose();
            } else if (object == VisualClasspathSupport.this.addArtifactButton) {
                AntArtifactChooser.ArtifactItem[] artifactItemArray = AntArtifactChooser.showDialog("jar");
                if (artifactItemArray != null) {
                    VisualClasspathSupport.this.addArtifacts(artifactItemArray);
                }
            } else if (object == VisualClasspathSupport.this.removeButton) {
                VisualClasspathSupport.this.removeElements();
            } else if (object == VisualClasspathSupport.this.upButton) {
                VisualClasspathSupport.this.moveUp();
            } else if (object == VisualClasspathSupport.this.downButton) {
                VisualClasspathSupport.this.moveDown();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            VisualClasspathSupport.this.setEnabled(true);
        }
    }
}

