/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.AbilitiesPanel;
import org.netbeans.modules.mobility.project.ui.FNode;
import org.netbeans.modules.mobility.project.ui.FileMonitor;
import org.netbeans.modules.mobility.project.ui.LazyInitFilterNode;
import org.netbeans.modules.mobility.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.mobility.project.ui.MissingFileDetector;
import org.netbeans.modules.mobility.project.ui.actions.RemoveResourceAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.actions.CopyAction;
import org.openide.actions.EditAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

final class OneResourceNode
extends LazyInitFilterNode
implements FileMonitor {
    static final String ARCHIVE_ICON = "org/netbeans/modules/mobility/project/ui/resources/libraries.gif";
    private final File root;
    private ProjectConfiguration config;
    private boolean multi;

    OneResourceNode(J2MEProject j2MEProject, ProjectConfiguration projectConfiguration, VisualClassPathItem visualClassPathItem, File file, boolean bl) {
        this(Lookups.fixed((Object[])new Object[]{j2MEProject, AbilitiesPanel.hintInstance, projectConfiguration == null ? j2MEProject.getConfigurationHelper().getActiveConfiguration() : projectConfiguration, visualClassPathItem}), file);
        this.config = projectConfiguration;
        this.setValue("VCPI", visualClassPathItem);
        this.setValue("resource", Boolean.TRUE);
        this.multi = bl;
        if (bl) {
            this.setDisplayName(NbBundle.getMessage(OneResourceNode.class, (String)"LBL_JarFromMultiJarLibrary", (Object[])new Object[]{visualClassPathItem.getDisplayName(), file.getName()}));
        } else {
            this.setDisplayName(visualClassPathItem.getDisplayName());
        }
    }

    private OneResourceNode(Lookup lookup, File file) {
        super(lookup);
        if (file == null) {
            throw new NullPointerException("Null root");
        }
        this.root = file;
        this.setValue("resource", Boolean.TRUE);
        this.setValue("error", !file.exists());
        this.change();
        MissingFileDetector.register(file, this);
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        return new Node.PropertySet[]{set};
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray;
        J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (j2MEProject != null);
        boolean bl2 = j2MEProject.canModifyLibraries(this.config);
        if (bl2) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = RemoveResourceAction.getStaticInstance();
            actionArray = actionArray2;
            actionArray2[1] = SystemAction.get(CopyAction.class);
        } else {
            Action[] actionArray3 = new Action[1];
            actionArray = actionArray3;
            actionArray3[0] = SystemAction.get(CopyAction.class);
        }
        return actionArray;
    }

    public Image getIcon(int n) {
        return ((VisualClassPathItem)this.getLookup().lookup(VisualClassPathItem.class)).getImage();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private void change() {
        boolean bl;
        boolean bl2 = !this.root.exists();
        this.setValue("error", bl2);
        boolean bl3 = bl = !this.isLazyChildren() && FilterNode.Children.LEAF == this.getChildren() && !bl2;
        if (bl) {
            this.reinit();
        }
    }

    public void fileCreated() {
        this.change();
    }

    public void fileDeleted() {
        this.change();
    }

    public void fileChanged() {
        this.reinit();
    }

    protected FilterNode.Children createRealChildren() {
        FileObject fileObject;
        if (this.root == null) {
            return null;
        }
        try {
            fileObject = FileUtil.toFileObject((File)this.root);
        }
        catch (NullPointerException nullPointerException) {
            IllegalStateException illegalStateException = new IllegalStateException("NPE from toFileObject for " + this.root, nullPointerException);
            throw illegalStateException;
        }
        assert (this.root != null);
        if (fileObject != null) {
            Node node = this.findNodeForRoot(fileObject);
            return new RemoveActionsFilterChildren(node);
        }
        return new FilterNode.Children((Node)new AbstractNode((Children)this.createLazyChildren()));
    }

    private Node findNodeForRoot(FileObject fileObject) {
        Object object = null;
        try {
            if ("jar".equals(fileObject.getURL().getProtocol())) {
                ImageIcon imageIcon;
                fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
                ImageIcon imageIcon2 = imageIcon = ImageUtilities.loadImageIcon((String)ARCHIVE_ICON, (boolean)false);
                object = PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject, fileObject.getNameExt(), imageIcon2, imageIcon));
            } else if (fileObject.isFolder()) {
                object = DataFolder.findFolder((FileObject)fileObject).getNodeDelegate();
            } else {
                try {
                    object = DataObject.find((FileObject)fileObject).getNodeDelegate();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
            }
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)this.getLookup().lookup(VisualClassPathItem.class);
            if (visualClassPathItem != null) {
                Lookup lookup = this.getLookup();
                J2MEProject j2MEProject = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
                assert (j2MEProject != null);
                boolean bl = j2MEProject.isUsingDefaultLibs(this.config);
                object.setValue("VCPI", (Object)visualClassPathItem);
                object = new FNode((Node)object, lookup, bl ? null : new Action[]{}, visualClassPathItem);
                object.setDisplayName(visualClassPathItem.getDisplayName());
                object.setValue("gray", (Object)bl);
                object.setValue("resource", (Object)"Resource");
            }
            return object;
        }
        catch (Exception exception) {
            return new AbstractNode((Children)this.createLazyChildren());
        }
    }

    private static final class RemoveActionsFilterChildren
    extends FilterNode.Children {
        RemoveActionsFilterChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new RemoveActionsFilterNode(node);
        }
    }

    private static final class RemoveActionsFilterNode
    extends FilterNode {
        RemoveActionsFilterNode(Node node) {
            super(node);
        }

        public Action[] getActions(boolean bl) {
            LinkedList<SystemAction> linkedList = new LinkedList<SystemAction>();
            if (this.getLookup().lookupItem(new Lookup.Template(OpenCookie.class)) != null) {
                linkedList.add(SystemAction.get(OpenAction.class));
            }
            if (this.getLookup().lookupItem(new Lookup.Template(EditCookie.class)) != null) {
                linkedList.add(SystemAction.get(EditAction.class));
            }
            if (this.getLookup().lookupItem(new Lookup.Template(ViewCookie.class)) != null) {
                linkedList.add(SystemAction.get(ViewAction.class));
            }
            if (!linkedList.isEmpty()) {
                linkedList.add(null);
            }
            linkedList.add(SystemAction.get(ToolsAction.class));
            linkedList.add(SystemAction.get(PropertiesAction.class));
            Action[] actionArray = linkedList.toArray(new Action[linkedList.size()]);
            return actionArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathProperty
    extends PropertySupport.ReadOnly<String> {
        PathProperty() {
            super("path", String.class, NbBundle.getMessage(NameProperty.class, (String)"LBL_LibraryPathProperty"), NbBundle.getMessage(NameProperty.class, (String)"DESC_LibraryPathProperty"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return OneResourceNode.this.root.getPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameProperty
    extends PropertySupport.ReadOnly<String> {
        NameProperty() {
            super("name", String.class, NbBundle.getMessage(NameProperty.class, (String)"LBL_LibraryNameProperty"), NbBundle.getMessage(NameProperty.class, (String)"DESC_LibraryNameProperty"));
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)OneResourceNode.this.getLookup().lookup(VisualClassPathItem.class);
            if (visualClassPathItem.getType() == 0 || visualClassPathItem.getType() == 2) {
                String string = visualClassPathItem.getRawText();
                int n = string.lastIndexOf(47);
                if (n > 0) {
                    string = string.substring(n);
                }
                return string;
            }
            return visualClassPathItem.getDisplayName();
        }
    }
}

