/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEActionProvider;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final J2MEProject project;
    private final AntProjectHelper helper;
    private final ReferenceHelper refHelper;

    public J2MEProjectOperations(J2MEProject j2MEProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = j2MEProject;
        this.helper = antProjectHelper;
        this.refHelper = referenceHelper;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        J2MEProjectOperations.addFile(fileObject, "nbproject", arrayList);
        J2MEProjectOperations.addFile(fileObject, "build.xml", arrayList);
        J2MEProjectOperations.addFile(fileObject, "manifest.mf", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        FileObject fileObject;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        String string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
        if (string != null && (fileObject = this.helper.resolveFileObject(string)) != null) {
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        J2MEActionProvider j2MEActionProvider = (J2MEActionProvider)this.project.getLookup().lookup(J2MEActionProvider.class);
        assert (j2MEActionProvider != null);
        Properties properties = new Properties();
        String[] stringArray = j2MEActionProvider.getTargetNames("clean-all");
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() {
        this.helper.notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        this.project.setName(string);
        this.refHelper.fixReferences(file);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) {
        if (project == null) {
            this.helper.notifyDeleted();
            return;
        }
        this.project.setName(string);
        this.refHelper.fixReferences(file);
    }
}

