/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.impl;

import java.util.Locale;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLAttribute;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLQNames;
import org.netbeans.modules.xml.wsdl.model.spi.WSDLComponentBase;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class ImportImpl
extends WSDLComponentBase
implements Import {
    public ImportImpl(WSDLModel wSDLModel, Element element) {
        super(wSDLModel, element);
    }

    public ImportImpl(WSDLModel wSDLModel) {
        this(wSDLModel, ImportImpl.createNewElement(WSDLQNames.IMPORT.getQName(), wSDLModel));
    }

    public void accept(WSDLVisitor wSDLVisitor) {
        wSDLVisitor.visit(this);
    }

    public void setNamespace(String string) {
        this.setAttribute("namespaceURI", WSDLAttribute.NAMESPACE_URI, string);
    }

    public void setLocation(String string) {
        this.setAttribute("location", WSDLAttribute.LOCATION, string);
    }

    public String getNamespace() {
        return this.getAttribute(WSDLAttribute.NAMESPACE_URI);
    }

    public String getLocation() {
        return this.getAttribute(WSDLAttribute.LOCATION);
    }

    public WSDLModel getImportedWSDLModel() throws CatalogModelException {
        DocumentModel documentModel = this.resolveImportedModel();
        if (documentModel instanceof WSDLModel) {
            return (WSDLModel)documentModel;
        }
        String string = NbBundle.getMessage(ImportImpl.class, (String)"MSG_CANNOT_LOAD_WSDL", (Object)this.getLocation());
        throw new CatalogModelException(string);
    }

    public WSDLModel resolveToWSDLModel() throws CatalogModelException {
        DocumentModel documentModel = this.resolveImportedModel();
        if (documentModel instanceof WSDLModel) {
            return (WSDLModel)documentModel;
        }
        return null;
    }

    public SchemaModel resolveToSchemaModel() throws CatalogModelException {
        DocumentModel documentModel = this.resolveImportedModel();
        if (documentModel instanceof SchemaModel) {
            return (SchemaModel)documentModel;
        }
        return null;
    }

    public DocumentModel resolveImportedModel() throws CatalogModelException {
        ModelSource modelSource = this.resolveModel(this.getLocation());
        String string = this.getLocation().toLowerCase(Locale.US);
        if (string.endsWith(".wsdl")) {
            return this.loadAsWSDL(modelSource);
        }
        if (string.endsWith(".xsd")) {
            return this.loadAsSchema(modelSource);
        }
        WSDLModel wSDLModel = this.loadAsWSDL(modelSource);
        if (wSDLModel == null) {
            wSDLModel = this.loadAsSchema(modelSource);
        }
        return wSDLModel;
    }

    private WSDLModel loadAsWSDL(ModelSource modelSource) {
        WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
        if (wSDLModel != null && wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        return wSDLModel;
    }

    private SchemaModel loadAsSchema(ModelSource modelSource) {
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
        if (schemaModel != null && schemaModel.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        return schemaModel;
    }
}

