/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.http.validation;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPOperation;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPUrlEncoded;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPUrlReplacement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class HTTPComponentValidator
implements Validator,
HTTPComponent.Visitor {
    private static final String HTTP_HOST_TOKEN = "${HttpHostName}";
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private Validation mValidation;
    private Validation.ValidationType mValidationType;
    private ValidationResult mValidationResult;
    private HTTPBinding.Verb mVerb;

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        WSDLModel wSDLModel;
        if (!(model instanceof WSDLModel)) {
            return null;
        }
        this.mVerb = HTTPBinding.Verb.GET;
        this.mValidation = validation;
        this.mValidationType = validationType;
        HashSet<Validator.ResultItem> hashSet = new HashSet<Validator.ResultItem>();
        HashSet<Model> hashSet2 = new HashSet<Model>();
        hashSet2.add(model);
        this.mValidationResult = new ValidationResult(hashSet, hashSet2);
        if (model instanceof WSDLModel) {
            wSDLModel = (WSDLModel)model;
            if (model.getState() == Model.State.NOT_WELL_FORMED) {
                return null;
            }
            Definitions definitions = wSDLModel.getDefinitions();
            for (Binding referenceableWSDLComponent : definitions.getBindings()) {
                int n = referenceableWSDLComponent.getExtensibilityElements(HTTPBinding.class).size();
                if (n > 1) {
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)referenceableWSDLComponent, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPBindingValidator.One_binding_allowed")));
                }
                for (HTTPBinding hTTPBinding : referenceableWSDLComponent.getExtensibilityElements(HTTPBinding.class)) {
                    hTTPBinding.accept(this);
                }
                for (BindingOperation bindingOperation : referenceableWSDLComponent.getBindingOperations()) {
                    int n2;
                    WSDLComponent wSDLComponent2;
                    for (WSDLComponent wSDLComponent2 : bindingOperation.getExtensibilityElements(HTTPOperation.class)) {
                        wSDLComponent2.accept(this);
                    }
                    List list = bindingOperation.getExtensibilityElements(HTTPOperation.class);
                    if (list.size() <= 0 || (wSDLComponent2 = bindingOperation.getBindingInput()) == null) continue;
                    int n3 = wSDLComponent2.getExtensibilityElements(HTTPUrlEncoded.class).size();
                    int n4 = n3 + (n2 = wSDLComponent2.getExtensibilityElements(HTTPUrlReplacement.class).size());
                    if (n4 == 0 && this.mVerb == HTTPBinding.Verb.GET) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)wSDLComponent2, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.Encoding_required")));
                    } else if (n4 > 1) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)wSDLComponent2, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.One_encoding_allowed")));
                    }
                    for (HTTPComponent hTTPComponent : wSDLComponent2.getExtensibilityElements(HTTPUrlEncoded.class)) {
                        hTTPComponent.accept(this);
                    }
                    for (HTTPComponent hTTPComponent : wSDLComponent2.getExtensibilityElements(HTTPUrlReplacement.class)) {
                        hTTPComponent.accept(this);
                    }
                }
            }
            for (Service service : definitions.getServices()) {
                for (Port port : service.getPorts()) {
                    Binding binding;
                    if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()) == null) continue;
                    int n = port.getExtensibilityElements(HTTPAddress.class).size();
                    int n5 = binding.getExtensibilityElements(HTTPBinding.class).size();
                    if (n5 > 0) {
                        if (n == 0) {
                            hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Missing_address")));
                        } else if (n > 1) {
                            hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.One_address_allowed")));
                        }
                    }
                    for (HTTPAddress hTTPAddress : port.getExtensibilityElements(HTTPAddress.class)) {
                        hTTPAddress.accept(this);
                    }
                }
            }
        }
        this.mValidation = null;
        this.mValidationType = null;
        wSDLModel = this.mValidationResult;
        this.mValidationResult = null;
        return wSDLModel;
    }

    public void visit(HTTPAddress hTTPAddress) {
        Collection collection = this.mValidationResult.getValidationResult();
        String string = hTTPAddress.getLocation();
        if (string == null) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPAddress, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(string)) {
            return;
        }
        if (string.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0 && string.startsWith("http")) {
            int n;
            int n2 = string.indexOf(":", 6);
            if (HTTP_DEFAULT_PORT_TOKEN.equals(string.substring(n2 + 1, n = string.indexOf("/", 7)))) {
                return;
            }
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPAddress, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            return;
        }
        if (string.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0 && string.startsWith("https")) {
            int n;
            int n3 = string.indexOf(":", 7);
            if (HTTPS_DEFAULT_PORT_TOKEN.equals(string.substring(n3 + 1, n = string.indexOf("/", 8)))) {
                return;
            }
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPAddress, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            return;
        }
        if (this.containsToken(string)) {
            if (!this.isValidAddressToken(string)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPAddress, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_token_format")));
                return;
            }
        } else {
            try {
                URI uRI = new URI(string);
                String string2 = uRI.getScheme();
                if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
                    return;
                }
                uRI.toURL();
            }
            catch (Exception exception) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPAddress, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            }
        }
    }

    public void visit(HTTPBinding hTTPBinding) {
        Collection collection = this.mValidationResult.getValidationResult();
        HTTPBinding.Verb verb = hTTPBinding.getVerb();
        if (verb == null) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPBinding, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPBindingValidator.Verb_required")));
        } else {
            this.mVerb = verb;
        }
    }

    public void visit(HTTPOperation hTTPOperation) {
        Collection collection = this.mValidationResult.getValidationResult();
        if (hTTPOperation.getLocation() == null) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)hTTPOperation, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPOperationValidator.Location_attribute_required")));
        }
    }

    public void visit(HTTPUrlEncoded hTTPUrlEncoded) {
        Collection collection = this.mValidationResult.getValidationResult();
        if (this.mVerb == HTTPBinding.Verb.POST) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)hTTPUrlEncoded, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.POST_ignores_urlEncoding")));
        }
    }

    public void visit(HTTPUrlReplacement hTTPUrlReplacement) {
        Collection collection = this.mValidationResult.getValidationResult();
        if (this.mVerb == HTTPBinding.Verb.POST) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)hTTPUrlReplacement, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.POST_ignores_urlEncoding")));
        }
    }

    private boolean containsToken(String string) {
        boolean bl = false;
        if (string != null && string.length() >= 4) {
            int n = string.indexOf("${");
            int n2 = n == -1 ? -1 : string.indexOf("}", n + 1);
            bl = n2 - n >= 3;
        }
        return bl;
    }

    private boolean isToken(String string) {
        boolean bl = false;
        if (string != null && string.length() >= 4) {
            bl = string.charAt(0) == '$' && string.charAt(1) == '{' && string.indexOf("${", 1) == -1 && string.indexOf("}") == string.length() - 1;
        }
        return bl;
    }

    private boolean isValidAddressToken(String string) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = true;
        if (string.startsWith("http://")) {
            string = string.substring(7, string.length());
            bl = true;
        }
        if (string.startsWith("https://")) {
            string = string.substring(8, string.length());
            bl = true;
        }
        if (!bl) {
            n2 = string.indexOf("${");
            n = string.indexOf("}");
            if (n == string.length() - 1 && n2 == 0) {
                bl2 = true;
            } else {
                return false;
            }
        }
        if (string.contains("${")) {
            n2 = string.indexOf(":");
            n = string.lastIndexOf("/");
            if (n != -1) {
                String string2;
                int n3;
                int n4;
                String string3 = string.substring(n + 1, string.length());
                int n5 = string3.indexOf("${");
                if (n5 == 0 ? (n4 = string3.indexOf("}")) < n5 : string3.indexOf("}") > 0) {
                    return false;
                }
                n4 = string.indexOf("${");
                if (n4 == 0 ? (n3 = (string2 = string.substring(1, n2)).indexOf("}")) < 1 : string.substring(1, n2).indexOf("}") > 0) {
                    return false;
                }
                string2 = string.substring(n2 + 1, n);
                if (string2.indexOf("${") != -1 && string2.indexOf("}") > 0) {
                    bl2 = true;
                } else {
                    return false;
                }
            }
        }
        return bl2;
    }
}

